/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.discovery;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceManager;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.nem.discover.util.DiscoveryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;

public class StorageResourceManager
implements IResourceManager {
    private final Log logger = LogFactory.getInstance((Object)this);

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        NeMgrProtocolExtend neMgrProtocolExtend = this.getService().findByMoId(moId);
        neMgrProtocolExtend.eraseSensitiveData();
        return neMgrProtocolExtend;
    }

    public void validate(NeMgrProtocolExtend neMgrProtocol) {
        long moId = neMgrProtocol.getMoId();
        IManagementProtocolService service = this.getService();
        NeMgrProtocolExtend oldExtend = service.findByMoId(Long.valueOf(moId));
        if (null == oldExtend) {
            throw new LegoCheckedException(201L);
        }
        this.checkIpAndPwdChangedTogether(neMgrProtocol, oldExtend);
        this.validateIp(neMgrProtocol, oldExtend);
        this.validatePort(neMgrProtocol, oldExtend);
        this.validateLoginInfo(neMgrProtocol, oldExtend);
        this.validateOceanProtectAuthInfo(neMgrProtocol, oldExtend);
    }

    private void checkIpAndPwdChangedTogether(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        String ipAddress = newExtend.getNetworkIpAddress();
        if (Objects.equals(ipAddress, oldExtend.getNetworkIpAddress())) {
            return;
        }
        if (!newExtend.isModifyAuthInfo()) {
            this.logger.error((Object)"The storage password does not change with the IP address changed.");
            throw new LegoCheckedException(2099466L);
        }
    }

    private void validateIp(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        if (this.isIpChanged(newExtend, oldExtend)) {
            if (!CommUtil.checkDrmIpParam((String)newExtend.getNetworkIpAddress())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (DiscoveryUtil.checkIpDuplicate((String)newExtend.getNetworkIpAddress())) {
                this.logger.error((Object)"Ip of device is managed: %s", new Object[]{newExtend.getNetworkIpAddress()});
                throw new LegoCheckedException(127406L);
            }
        }
    }

    private void validatePort(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        String newPort;
        long portVal;
        if (this.isPortChanged(newExtend, oldExtend) && !ValidateUtil.checkPort((long)(portVal = NumberUtil.parseLong((Object)(newPort = (String)newExtend.getExtendParams().get("port"))).longValue()))) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void validateLoginInfo(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        if (this.isLoginInfoChanged(newExtend, oldExtend)) {
            String newUserName = newExtend.getNetworkUserName();
            this.validateUsername(newUserName);
            String newPassword = newExtend.getNetworkPassword();
            this.validatePwd(newPassword);
            try {
                RestConnectionManager.getInstance().buildConnection(newExtend, null).authenticate();
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"Check login info failed: ip: %s, error msg: %s", new Object[]{newExtend.getNetworkIpAddress(), e.getMessage()});
                throw e;
            }
            catch (Exception e) {
                this.logger.error((Object)"Check login info failed: ip: %s, error msg: %s.", new Object[]{newExtend.getNetworkIpAddress(), ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1077949061L);
            }
        }
    }

    private void validateOceanProtectAuthInfo(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        if (this.isOceanProtectAuthInfoChanged(newExtend, oldExtend)) {
            Map newExtendParams = newExtend.getExtendParams();
            String newUserName = (String)newExtendParams.get("OceanProtectUsername");
            if (!ValidateUtil.checkLength((String)newUserName, (int)5, (int)64)) {
                this.logger.error((Object)"The length of ProtectManager username ranges from 5 to 64 bits.");
                throw new LegoCheckedException(1073947393L);
            }
            String newPassword = (String)newExtendParams.get("OceanProtectPassword");
            if (!ValidateUtil.checkLength((String)newPassword, (int)8, (int)64)) {
                this.logger.error((Object)"The length of ProtectManager password ranges from 8 to 64 bits.");
                throw new LegoCheckedException(1073947393L);
            }
            try {
                RestConnection connection = RestConnectionManager.getInstance().buildConnection(newExtend, "oceanProtectConnection");
                connection.authenticate();
                newExtend.getExtendParams().remove("protectManagerPasswordError");
                NetworkEntity networkEntity = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "moId", (Object)oldExtend.getMoId());
                RestConnectionManager.getInstance().setConnection(networkEntity.getSn() + "oceanProtectConnection", connection);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"Check ProtectManager login info failed: ip: %s, error msg: %s", new Object[]{newExtend.getNetworkIpAddress(), e.getMessage()});
                throw e;
            }
            catch (Exception e) {
                this.logger.error((Object)"Check ProtectManager login info failed: ip: %s, error msg: %s", new Object[]{newExtend.getNetworkIpAddress(), ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1677929488L);
            }
        }
    }

    private boolean isOceanProtectAuthInfoChanged(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        Map newExtendParams = newExtend.getExtendParams();
        String newUserName = (String)newExtendParams.get("OceanProtectUsername");
        String newPassword = (String)newExtendParams.get("OceanProtectPassword");
        if (VerifyUtil.isEmpty((String)newUserName) || VerifyUtil.isEmpty((String)newPassword)) {
            return false;
        }
        Map oldExtendParams = oldExtend.getExtendParams();
        String oldUserName = (String)oldExtendParams.get("OceanProtectUsername");
        String oldPassword = (String)oldExtendParams.get("OceanProtectPassword");
        return !newUserName.equals(oldUserName) || !newPassword.equals(oldPassword);
    }

    private void validateUsername(String name) {
        if (!ValidateUtil.checkLength((String)name, (int)1, (int)32)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void validatePwd(String pwd) {
        if (!ValidateUtil.checkLength((String)pwd, (int)1, (int)32)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean isIpChanged(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        String newIp = newExtend.getNetworkIpAddress();
        String oldIp = oldExtend.getNetworkIpAddress();
        if (VerifyUtil.isEmpty((String)newIp)) {
            return false;
        }
        return !newIp.equals(oldIp);
    }

    private boolean isPortChanged(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        String protocol = (String)oldExtend.getExtendParams().get("protocol");
        if (null == protocol || !protocol.equals("REST")) {
            return false;
        }
        String newPort = (String)newExtend.getExtendParams().get("port");
        String oldPort = (String)oldExtend.getExtendParams().get("port");
        if (VerifyUtil.isEmpty((String)newPort) || VerifyUtil.isEmpty((String)oldPort)) {
            return false;
        }
        return !newPort.equals(oldPort);
    }

    private boolean isLoginInfoChanged(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend) {
        String newUserName = newExtend.getNetworkUserName();
        String newPassword = newExtend.getNetworkPassword();
        boolean isModifyPwd = newExtend.isModifyAuthInfo();
        if (!isModifyPwd) {
            return false;
        }
        if (null == newUserName || null == newPassword) {
            return false;
        }
        return !newUserName.equals(oldExtend.getNetworkUserName()) || !newPassword.equals(oldExtend.getNetworkPassword());
    }

    private void processNetworkEntityAndStorageUnit(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend, List<Object> updated) {
        Long moId = newExtend.getMoId();
        NetworkEntity networkEntity = (NetworkEntity)CommonDAOLocator.getMoDao().get((Serializable)moId);
        String sn = networkEntity.getSn();
        if (this.isIpChanged(newExtend, oldExtend)) {
            String oldIpAddress = networkEntity.getLinkIp();
            String oldManagedIps = networkEntity.getManagedIps();
            String newIpAddress = newExtend.getNetworkIpAddress();
            String newManagedIps = oldManagedIps;
            if (!oldManagedIps.contains(newIpAddress)) {
                newManagedIps = oldManagedIps.replace(oldIpAddress, newIpAddress);
            }
            networkEntity.setIpAddress(newIpAddress);
            networkEntity.setLinkIp(newIpAddress);
            networkEntity.setManagedIps(newManagedIps);
            StorageUnit storageUnit = (StorageUnit)CommonDAOLocator.getMoDao().getMo(StorageUnit.class, "devSn", (Object)sn);
            storageUnit.setIpAddress(newIpAddress);
            storageUnit.setLinkIp(newIpAddress);
            storageUnit.setManageIps(newManagedIps);
            updated.add(networkEntity);
            updated.add(storageUnit);
        }
    }

    private void processDrResource(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend, List<Object> updated) {
        Long moId = newExtend.getMoId();
        NetworkEntity networkEntity = (NetworkEntity)CommonDAOLocator.getMoDao().get((Serializable)moId);
        String sn = networkEntity.getSn();
        if (this.isIpChanged(newExtend, oldExtend)) {
            List list = CommonDAOLocator.getBaseDao().find("from DrResource where deviceSn=?", new Object[]{sn});
            for (Object object : list) {
                DrResource temp = (DrResource)object;
                temp.setIpAddress(newExtend.getNetworkIpAddress());
            }
            updated.addAll(list);
        }
    }

    private void processNeMgrProtocolExtend(NeMgrProtocolExtend newExtend, NeMgrProtocolExtend oldExtend, List<Object> updated) {
        Map extendParams = oldExtend.getExtendParams();
        boolean modify = false;
        if (this.isIpChanged(newExtend, oldExtend)) {
            oldExtend.setNetworkIpAddress(newExtend.getNetworkIpAddress());
            modify = true;
        }
        if (this.isPortChanged(newExtend, oldExtend)) {
            extendParams.put("port", newExtend.getExtendParams().get("port"));
            modify = true;
        }
        if (this.isLoginInfoChanged(newExtend, oldExtend)) {
            oldExtend.setNetworkUserName(newExtend.getNetworkUserName());
            oldExtend.setNetworkPassword(newExtend.getNetworkPassword());
            modify = true;
        }
        if (this.isOceanProtectAuthInfoChanged(newExtend, oldExtend)) {
            Map newExtendParams = newExtend.getExtendParams();
            String newUserName = (String)newExtendParams.get("OceanProtectUsername");
            String newPassword = (String)newExtendParams.get("OceanProtectPassword");
            String newPort = (String)newExtendParams.get("OceanProtectPort");
            oldExtend.getExtendParams().put("OceanProtectUsername", newUserName);
            oldExtend.getExtendParams().put("OceanProtectPassword", WccEncryptor.encrypt((String)newPassword));
            oldExtend.getExtendParams().put("OceanProtectPort", newPort);
            oldExtend.getExtendParams().remove("protectManagerPasswordError");
            modify = true;
        }
        if (modify) {
            oldExtend.setNetworkPassword(WccEncryptor.encrypt((String)oldExtend.getNetworkPassword()));
            updated.add(oldExtend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        Long moId = neMgrProtocol.getMoId();
        NeMgrProtocolExtend oldExtend = this.getService().findByMoId(moId);
        NetworkEntity oldNetworkEntity = (NetworkEntity)CommonDAOLocator.getMoDao().get((Serializable)moId);
        String sn = oldNetworkEntity.getSn();
        ArrayList<Object> updated = new ArrayList<Object>();
        this.processNetworkEntityAndStorageUnit(neMgrProtocol, oldExtend, updated);
        this.processDrResource(neMgrProtocol, oldExtend, updated);
        this.processNeMgrProtocolExtend(neMgrProtocol, oldExtend, updated);
        if (updated.isEmpty()) {
            return;
        }
        OperationLock lock = DeviceOperationLock.getLock((String)sn);
        if (!lock.tryLock()) {
            this.logger.warn((Object)("Someone[" + lock.getOwnerName() + "] has locked array, devSn=" + sn), 90160758784000L);
            throw new LegoCheckedException(102401L);
        }
        try {
            this.logger.info((Object)("Get array operation lock ... devSn=" + sn), 90160758784000L);
            UpdateStorageMgrProtocalTransaction callback = new UpdateStorageMgrProtocalTransaction(updated);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().execute((HibernateCallback)callback);
        }
        finally {
            lock.unTryLock();
            this.logger.info((Object)("Release array operation lock ... devSn=" + sn), 90160758784000L);
        }
    }

    public String getResourceType() {
        return "ism.deviceType.storage.mainType";
    }

    public IManagementProtocolService getService() {
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        return service;
    }

    class UpdateStorageMgrProtocalTransaction
    implements HibernateCallback {
        private List<Object> updated;

        public UpdateStorageMgrProtocalTransaction(List<Object> updated) {
            this.updated = updated;
        }

        public Object doInHibernate(Session session) {
            try {
                for (Object object : this.updated) {
                    CommonDAOLocator.getMoDao().getHibernateTemplate().update(object);
                }
            }
            catch (DataAccessException e) {
                StorageResourceManager.this.logger.error((Object)"Save storage info error!", 90160758786306L);
                throw new LegoCheckedException(132416L, (Throwable)e);
            }
            catch (HibernateException e) {
                StorageResourceManager.this.logger.error((Object)"Save host info error!", 90160758786306L);
                throw new LegoCheckedException(132416L, (Throwable)e);
            }
            return null;
        }
    }
}

