/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.discovery.msg;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;

public class NetworkMessageSubscriber
extends MessageTaskManager {
    private final Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());

    public NetworkMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(105L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        if (msgType != 105L) {
            this.logger.error((Object)"Message was not subscribed, msgType: %s", new Object[]{String.valueOf(msgType)});
            return;
        }
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            if (!(obj instanceof NetworkEntity)) continue;
            NetworkEntity ne = (NetworkEntity)obj;
            this.restoreCertAlarm(ne, "0x000803220005", ne.getUuid());
            this.restoreCertAlarm(ne, "0x3230024", ne.getUuid());
            this.restoreCertAlarm(ne, "0x3230025", ne.getUuid());
            this.restoreCertAlarm(ne, "0x3230026", ne.getUuid());
            AlarmUtil.restoreAlarm((String)"0x3230064", (String[])new String[]{ne.getSn()});
        }
    }

    private void restoreCertAlarm(NetworkEntity ne, String alarmId, String moUuid) {
        try {
            AlarmUtil.restoreSimilarAlarms((String)alarmId, (String)moUuid);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Delete resource failed, Name: %s, errMsg: %s", new Object[]{ne.getName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }
}

