/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.calculator;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.protection.calculator.ArrayHyperMetroSnapshotRPOCalculator;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperVaultRPOCalculator
extends BaseRecoveryPointObjectiveCalculator {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroSnapshotRPOCalculator.class);
    private static final String PROTECT_GROUP_REPLICA_PREFIX = "PROTECT_GROUP_REPLICA_PREFIX_";
    private String comma = ",";

    public List<String> getTypes() {
        return Arrays.asList(String.valueOf(17), String.valueOf(30), String.valueOf(32));
    }

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        if (!this.init(context).booleanValue()) {
            return null;
        }
        LinkedHashMap<String, Object> cfgRPO = new LinkedHashMap<String, Object>();
        this.calculateSnapshotCfgRPO(context, DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue(), cfgRPO);
        this.calculateSnapshotCfgRPO(context, DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue(), cfgRPO);
        this.calculateSnapshotCfgRPO(context, DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), cfgRPO);
        return cfgRPO;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        LinkedHashMap<String, Object> actualRPO = new LinkedHashMap<String, Object>();
        this.calculateSnapshotActualRpo(context, actualRPO, DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue());
        this.calculateSnapshotActualRpo(context, actualRPO, DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue());
        this.calculateSnapshotActualRpo(context, actualRPO, DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        return actualRPO;
    }

    private void calculateSnapshotActualRpo(RPOContext context, Map<String, Object> actualRPO, int protectLocation) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"schedules is empty!");
            return;
        }
        List<Schedule> scheduleList = this.getScheduleListByProtectLocation(protectLocation, schedules);
        for (Schedule schedule : scheduleList) {
            if (schedule == null) {
                logger.error((Object)("schedule is empty! protectLocation:" + protectLocation + ""));
                continue;
            }
            String key = this.getKey(protectLocation, schedule.getTargetSiteId(), schedule.getSourceSiteId(), schedule.getProtectedType());
            ProtectGroupReplica latestActiveReplica = this.getLatestActiveSnapshotReplica(context, protectLocation, schedule.getProtectedType());
            if (latestActiveReplica == null) {
                actualRPO.put(key, -3);
                continue;
            }
            this.setActualRPO(context, actualRPO, key, latestActiveReplica);
        }
    }

    private void setActualRPO(RPOContext context, Map<String, Object> actualRPO, String key, ProtectGroupReplica latestActiveReplica) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Long lastSuccessExecutedTime = this.getLastSuccessExcTime(protectGroup, latestActiveReplica.getId());
        if (lastSuccessExecutedTime != null) {
            actualRPO.put(key, System.currentTimeMillis() - lastSuccessExecutedTime);
            return;
        }
        actualRPO.put(key, -3);
    }

    private void calculateSnapshotCfgRPO(RPOContext context, int protectLocation, Map<String, Object> cfgRPO) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"schedules is empty!");
            return;
        }
        List<Schedule> scheduleList = this.getScheduleListByProtectLocation(protectLocation, schedules);
        if (VerifyUtil.isEmpty(scheduleList)) {
            logger.error((Object)("the schedule of protectLocation(" + protectLocation + ") is empty!"));
            return;
        }
        for (Schedule schedule : scheduleList) {
            String key = this.getKey(protectLocation, schedule.getTargetSiteId(), schedule.getSourceSiteId(), schedule.getProtectedType());
            this.setCfgRPO(cfgRPO, schedule, key);
        }
    }

    private ProtectGroupReplica getLatestActiveSnapshotReplica(RPOContext context, int protectLocation, int protectedType) {
        List pgReplicas = (List)context.getObject(PROTECT_GROUP_REPLICA_PREFIX + protectLocation);
        return this.getLatestActivatedReplica(pgReplicas, protectedType);
    }

    private void setCfgRPO(Map<String, Object> cfgRPO, Schedule schedule, String key) {
        if (VerifyUtil.isEmpty((Object)schedule.isEnableRpoCheck()) || schedule.getScheduleMode() == 1) {
            cfgRPO.put(key, -1);
            return;
        }
        if (!schedule.isEnableRpoCheck().booleanValue()) {
            cfgRPO.put(key, -3);
            return;
        }
        if (!ProtectionJobUtil.getInstance().isTimeInRange((ISchedule)schedule, new Date())) {
            cfgRPO.put(key, -1);
            return;
        }
        cfgRPO.put(key, this.getConfigRPO(schedule.getExpectedRPO()));
    }

    private String getKey(int protectLocation, String recoverySite, String productSiteId, int protectedType) {
        String key = protectLocation + this.comma + productSiteId + this.comma + recoverySite + this.comma + protectedType;
        return key;
    }

    private List<Schedule> getScheduleListByProtectLocation(int protectLocation, Set<Schedule> schedules) {
        ArrayList<Schedule> scheduleList = new ArrayList<Schedule>();
        for (Schedule sch : schedules) {
            if (sch.getProtectLocation() != protectLocation) continue;
            scheduleList.add(sch);
        }
        return scheduleList;
    }

    private Boolean init(RPOContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set pgReplicaList = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)pgReplicaList)) {
            logger.error((Object)"pgReplicaList is empty!");
            return false;
        }
        for (ProtectGroupReplica protectGroupReplica : pgReplicaList) {
            if (!ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)protectGroupReplica) && protectGroupReplica.getType() != 2) continue;
            String key = PROTECT_GROUP_REPLICA_PREFIX + protectGroupReplica.getProtectLocation();
            Object object = context.getObject(key);
            if (object == null) {
                ArrayList<ProtectGroupReplica> pgReplicas = new ArrayList<ProtectGroupReplica>();
                pgReplicas.add(protectGroupReplica);
                context.addObject(key, pgReplicas);
                continue;
            }
            List protectGroupReplicas = (List)object;
            protectGroupReplicas.add(protectGroupReplica);
        }
        return true;
    }

    protected String getSiteId(String str) {
        String[] siteIdArray = str.split(this.comma);
        if (siteIdArray.length != 4) {
            logger.error((Object)("getSiteId error! str:" + str), 90160758787071L);
            return "";
        }
        return siteIdArray[2];
    }

    protected Object getProductSiteId(String key) {
        String[] siteIdArray = key.split(this.comma);
        if (siteIdArray.length != 4) {
            logger.error((Object)("getProductSiteId error! key: " + key), 90160758787071L);
            return "";
        }
        return siteIdArray[1];
    }

    protected Object getProtectedType(String key) {
        String[] siteIdArray = key.split(this.comma);
        if (siteIdArray.length != 4) {
            logger.error((Object)("getProtectedType error! key: " + key), 90160758787071L);
            return "";
        }
        return siteIdArray[3];
    }
}

