/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.interceptor.lun.group;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunGroupManager;
import com.huawei.ism.drm.storage.protection.interceptor.lun.group.LunGroupRollbackItem;
import com.huawei.ism.drm.storage.protection.interceptor.lun.group.LunRollbackItem;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.lego.cbb.resource.rollback.IResourceRollbackTask;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class LunConsistentGroupFactory {
    private static final List<Integer> HYPER_CDP_TYPE = new ArrayList<Integer>(Arrays.asList(ScheduleProtectedType.HYPERCDP.getValue(), ScheduleProtectedType.SECURE_SNAPSHOT.getValue()));
    private IResourceRollbackTask task;
    private ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
    private StorageLunGroupManagerProxy proxy = StorageLunGroupManagerProxy.getInstance();

    private LunConsistentGroupFactory(IResourceRollbackTask task) {
        if (null == task) {
            throw new IllegalArgumentException("task is null");
        }
        this.task = task;
    }

    public static LunConsistentGroupFactory newFactory(IResourceRollbackTask task) {
        return new LunConsistentGroupFactory(task);
    }

    public void createLunConsistentGroup(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Object)protectGroup.getTemplate())) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getTemplate().getSchedules())) {
            return;
        }
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        Map storageInfos = builder.getAllStroageInfo(protectGroup);
        IProtectObjectProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            List storageInfoList;
            String devSn;
            if (this.noNeedCreateCg(schedule, protectGroup, devSn = (String)devSns.get(schedule.getProtectLocation())) || CollectionUtils.isEmpty((Collection)(storageInfoList = (List)storageInfos.get(devSn))) || !schedule.isEnable().booleanValue()) continue;
            Map<String, List<String>> lunMap = this.getLunMap(provider, devSn, storageInfoList);
            this.dealLunCG(protectGroup, lunMap);
        }
    }

    private boolean noNeedCreateCg(Schedule schedule, ProtectGroup protectGroup, String devSn) {
        if (!HYPER_CDP_TYPE.contains(schedule.getProtectedType()) || schedule.getPeriodType() == 5) {
            return true;
        }
        if (schedule.getProtectedType() == ScheduleProtectedType.SECURE_SNAPSHOT.getValue()) {
            List relationBos;
            String cgUuid = (String)protectGroup.getProps().get("cgUuid");
            if (VerifyUtil.isEmpty((String)cgUuid)) {
                return true;
            }
            Collection repRelationBos = protectGroup.getAllReplicationRelation().values();
            if (!CollectionUtils.isEmpty(repRelationBos) && !CollectionUtils.isEmpty((Collection)(relationBos = (List)repRelationBos.iterator().next()))) {
                cgUuid = ((ReplicationRelationBo)relationBos.get(0)).getReplicationId();
            }
            StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
            ReplicationGroup replicationGroup = sraProxy.getReplicationGroup(devSn, cgUuid);
            String key = this.generateLunCGKey(devSn);
            if (!VerifyUtil.isEmpty((Object)replicationGroup)) {
                protectGroup.getProps().put(key, replicationGroup.getLocalPgId());
            }
            return false;
        }
        return false;
    }

    private Map<String, List<String>> getLunMap(IProtectObjectProvider provider, String devSn, List<ProtectObjectStorageInfo> storageInfoList) {
        HashMap<String, List<String>> lunMap = new HashMap<String, List<String>>();
        for (ProtectObjectStorageInfo storageInfo : storageInfoList) {
            String resourceId = storageInfo.getResourceId();
            String key = this.generateLunCGKey(devSn);
            if (provider.isProtectArchieveLog(storageInfo)) {
                key = this.generateLunLogCGKey(devSn);
            }
            ProtectGroupUtil.putObjectToMap(lunMap, (Object)key, (Object)resourceId);
        }
        return lunMap;
    }

    public void createLunConsistentGroup(ProtectGroup protectGroup, Schedule schedule) {
        List dbResults;
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        Map storageInfos = builder.getAllStroageInfo(protectGroup);
        IProtectObjectProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        if (schedule.getProtectedType() == ScheduleProtectedType.HYPERCDP.getValue() && schedule.getPeriodType() != 5) {
            String devSn = (String)devSns.get(schedule.getProtectLocation());
            List storageInfoList = (List)storageInfos.get(devSn);
            Map<String, List<String>> lunMap = this.getLunMap(provider, devSn, storageInfoList);
            this.dealLunCG(protectGroup, lunMap);
        }
        if (!VerifyUtil.isEmpty((Collection)(dbResults = CommonDAOLocator.getMoDao().find("from ProtectGroup where uuid=?", new Object[]{protectGroup.getUuid()})))) {
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), protectGroup.getProps());
        }
    }

    private String generateLunCGKey(String devSn) {
        return "PROP_KEY_LUN_CG_KEY:" + devSn;
    }

    private String generateLunLogCGKey(String devSn) {
        return "PROP_KEY_LUN_LOG_CG_KEY:" + devSn;
    }

    private void dealLunCG(ProtectGroup protectGroup, Map<String, List<String>> map) {
        if (VerifyUtil.isEmpty(map)) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            String devSn = entry.getKey().split(":")[1];
            List<String> list = entry.getValue();
            String lunCGId = (String)protectGroup.getProps().get(key);
            if (null != lunCGId) {
                this.refreshLunCG(devSn, lunCGId, list);
                continue;
            }
            this.createLunCG(protectGroup, devSn, list, key);
        }
    }

    private void refreshLunCG(String devSn, String cgId, List<String> lunIds) {
        IStorageLunGroupManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn);
        List luns = manager.queryLuns(devSn, cgId);
        HashSet<String> existLuns = new HashSet<String>();
        luns.forEach(lun -> existLuns.add(lun.getResourceId()));
        this.addLunToCG(lunIds, existLuns, devSn, cgId);
        this.removeLunFromCG(lunIds, existLuns, devSn, cgId);
    }

    private void removeLunFromCG(List<String> lunIds, Set<String> existLuns, String devSn, String cgId) {
        IStorageLunGroupManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn);
        for (String lunId : existLuns) {
            if (lunIds.contains(lunId)) continue;
            manager.remove(devSn, cgId, lunId);
        }
    }

    private void addLunToCG(List<String> lunIds, Set<String> existLuns, String devSn, String cgId) {
        IStorageLunGroupManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn);
        for (String lunId : lunIds) {
            if (existLuns.contains(lunId)) continue;
            manager.addLunToConsistencyGroup(devSn, cgId, lunId, null);
            this.task.addItem((IRollbackItem)new LunRollbackItem(devSn, cgId, lunId));
        }
    }

    private void createLunCG(ProtectGroup protectGroup, String devSn, List<String> lunIds, String key) {
        IRecoveryResourceService recoveryService;
        Lun lun;
        String vstoreId;
        String cgName;
        IStorageLunGroupManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn);
        LunConsistencyGroup lunCG = manager.create(devSn, cgName = "RD_CG_" + System.currentTimeMillis(), vstoreId = VerifyUtil.isEmpty((String)(lun = (recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getTargetLunById(devSn, lunIds.get(0))).getVstoreId()) ? null : lun.getVstoreId());
        if (null != lunCG) {
            protectGroup.getProps().put(key, lunCG.getId());
            this.task.addItem((IRollbackItem)new LunGroupRollbackItem(lunCG));
            for (String lunId : lunIds) {
                manager.addLunToConsistencyGroup(devSn, lunCG.getId(), lunId, vstoreId);
                this.task.addItem((IRollbackItem)new LunRollbackItem(devSn, lunCG.getId(), lunId));
            }
        }
    }
}

