/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.observer;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OracleAllFlashObserver
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashObserver.class);
    private static final List<Integer> NORMAL_STATUS_LIST = ImmutableList.of((Object)DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus(), (Object)DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus());

    public void before(MessageEvent event) {
        if (event.getMessageType() == 0) {
            return;
        }
        if (VerifyUtil.isEmpty((Collection)event.getObjectList())) {
            return;
        }
        for (DRMObject drmObj : event.getObjectList()) {
            ProtectGroup protectGroup;
            if (!(drmObj instanceof ProtectGroup) || (protectGroup = (ProtectGroup)drmObj).getTemplate().getType() != 47 || !NORMAL_STATUS_LIST.contains(protectGroup.getStatus())) continue;
            String[] params = new String[]{(String)protectGroup.getProps().get("DB_NAMES"), protectGroup.getName()};
            LOGGER.debug((Object)"Begin check adg status at %s", new Object[]{this.getClass().getSimpleName()});
            try {
                this.checkAdgStatus(protectGroup);
                AlarmReporter.restoreAlarm((String)"0x3230099", (String[])params);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Fail to check adg status at: %s", new Object[]{protectGroup.getName()});
                AlarmReporter.sendAlarm((String)"0x3230099", (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
            }
            LOGGER.debug((Object)"End check adg status at %s", new Object[]{this.getClass().getSimpleName()});
        }
    }

    private void checkAdgStatus(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        polist.forEach(po -> {
            po.getProps().put("QUERY_TYPE", "0");
            IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
            applicationManager.checkEnvStatus(po);
        });
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

