/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.service.path.AbstractProtectionPathImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ArrayHyperVaultProtectionPath
extends AbstractProtectionPathImpl {
    protected static final String REMOTE_REPLICA = "REMOTE_REPLICA";
    private static final Log LOGGER = LogFactory.getInstance(ArrayHyperVaultProtectionPath.class);
    private static final String HYPERVAULTKEY = "HYPER_VAULT";

    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        ProtectionPath storageResPath;
        ProtectionPath sitePath;
        ExecutionContext context = this.init(luns, batchOperation);
        try {
            this.initData(context, protectgroup);
            sitePath = this.buildSitePath(protectgroup, context);
            storageResPath = this.buildStorageResPath(protectgroup, context);
        }
        catch (LegoCheckedException e) {
            ArrayList<String> sitePathDetails = new ArrayList<String>();
            sitePathDetails.add("");
            sitePath = new ProtectionPath();
            storageResPath = new ProtectionPath();
            sitePath.setPathDetails(sitePathDetails);
            storageResPath.setPathDetails(sitePathDetails);
            LOGGER.error((Object)"ArrayHyperVaultProtectionPath error!", (Throwable)e);
        }
        return this.buildProtectionPath(sitePath, storageResPath, context, protectgroup);
    }

    protected void initData(ExecutionContext context, ProtectGroup protectgroup) {
        ProtectObjectStorageInfo storageInfo = this.getStorageInfo(protectgroup);
        long startTime = System.currentTimeMillis();
        HyperVault hyperVault = this.getHyperVaultMgr(storageInfo.getResourceProviderSN()).queryHyperVaultByResourceId(storageInfo.getResourceProviderSN(), storageInfo.getResourceId());
        LOGGER.debug((Object)"Realtime to query hyper vault cost time: %s", new Object[]{System.currentTimeMillis() - startTime + ""});
        context.setAttribute(HYPERVAULTKEY, (Object)hyperVault);
    }

    private IStorageHyperVaultManager getHyperVaultMgr(String devSn) {
        IStorageHyperVaultManager service = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (service == null) {
            LOGGER.error((Object)"To get the IStorageHyperVaultManager failed! devSn: %s", new Object[]{devSn});
            throw new LegoCheckedException(-1L);
        }
        return service;
    }

    private ProtectObjectStorageInfo getStorageInfo(ProtectGroup protectGroup) {
        Set protectObjectSet = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)protectObjectSet)) {
            LOGGER.error((Object)"The protectObjectSet is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject po = (ProtectObject)protectObjectSet.iterator().next();
        Set resourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)resourceSet)) {
            LOGGER.error((Object)"The resourceSet is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectObjectStorageInfo)resourceSet.iterator().next();
    }

    private ProtectionPath buildSitePath(ProtectGroup protectgroup, ExecutionContext context) {
        String pgMsg = this.getPgMsg(protectgroup);
        LOGGER.debug((Object)"Start build site protection path..., with pgMsg: %s", new Object[]{pgMsg});
        ProtectionPath siteProtectionPath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        sitePathDetails.add(this.getSiteRelation(context));
        siteProtectionPath.setPathDetails(sitePathDetails);
        LOGGER.debug((Object)"End build site protection path..., pgMsg: %s", new Object[]{pgMsg});
        return siteProtectionPath;
    }

    private String getPgMsg(ProtectGroup protectgroup) {
        return " pgName:" + protectgroup.getName() + ", pgId:" + protectgroup.getUuid();
    }

    private ProtectionPath buildStorageResPath(ProtectGroup protectgroup, ExecutionContext context) {
        LOGGER.debug((Object)"start build storage resource protection path...pg name: %s", new Object[]{protectgroup.getName()});
        ProtectionPath protectionpath = new ProtectionPath();
        ArrayList<String> rdPathDetailList = new ArrayList<String>();
        rdPathDetailList.add(this.getRDPath(context));
        protectionpath.setPathDetails(rdPathDetailList);
        LOGGER.debug((Object)"End build storage resource protection path...");
        return protectionpath;
    }

    protected String getRDPath(ExecutionContext context) {
        StringBuilder rdPathStr = new StringBuilder();
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPERVAULTKEY, HyperVault.class);
        if (hyperVault == null) {
            LOGGER.error((Object)"HyperVault is empty!");
            return "";
        }
        String localDevSn = hyperVault.getDevSn();
        String localResourceId = hyperVault.getLocalResourceId();
        String remoteDeviceSn = hyperVault.getRemoteDeviceSn();
        String remoteResourceId = hyperVault.getRemoteResourceId();
        this.appendResourceInfo(rdPathStr, localDevSn, localResourceId);
        rdPathStr.append(" --> ");
        this.appendResourceInfo(rdPathStr, remoteDeviceSn, remoteResourceId);
        return rdPathStr.toString();
    }

    private void appendResourceInfo(StringBuilder rdPathStr, String localDevSn, String localResourceId) {
        DrResource drResource = this.getStorageBySn(localDevSn);
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        rdPathStr.append(this.getResourceName(storageResourceService, localDevSn, localResourceId)).append("(").append(this.getIp(drResource)).append(")");
    }

    private String getResourceName(IStorageResourceService storageResourceService, String providerSN, String resourceId) {
        if (storageResourceService == null) {
            LOGGER.error((Object)"The storageResourceService is null!");
            return "";
        }
        StorageResource storageResource = storageResourceService.getStorageResource(providerSN, resourceId, StorageResource.class);
        if (storageResource == null) {
            LOGGER.error((Object)"The storageResource is null!");
            return "";
        }
        return storageResource.getName();
    }

    private String getIp(DrResource drResource) {
        if (drResource != null) {
            return drResource.getIpAddress();
        }
        LOGGER.error((Object)"The drResource is null!");
        return "";
    }

    protected String getSiteRelation(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPERVAULTKEY, HyperVault.class);
        if (hyperVault == null) {
            LOGGER.error((Object)"The hyperVault is empty!");
            return "";
        }
        String localDevSn = hyperVault.getDevSn();
        String remoteDevSn = hyperVault.getRemoteDeviceSn();
        return this.getSiteRelation(localDevSn, remoteDevSn);
    }

    protected String getSiteRelation(String localDevSn, String remoteDevSn) {
        StringBuilder siteRelationStr = new StringBuilder();
        Site localSite = this.getSiteByStorageSn(localDevSn);
        Site remoteSite = this.getSiteByStorageSn(remoteDevSn);
        siteRelationStr.append(localSite != null ? localSite.getName() : "");
        siteRelationStr.append(localSite != null ? " --> " : "");
        siteRelationStr.append(remoteSite != null ? remoteSite.getName() : "");
        return siteRelationStr.toString();
    }

    private ProtectionPathData buildProtectionPath(ProtectionPath siteProtectionPath, ProtectionPath storageResProtectionPath, ExecutionContext context, ProtectGroup protectgroup) {
        ArrayList<ProtectionPath> protectionPathList = new ArrayList<ProtectionPath>();
        protectionPathList.add(siteProtectionPath);
        protectionPathList.add(storageResProtectionPath);
        ProtectionPathData protectionPathData = new ProtectionPathData(protectionPathList);
        BatchOperation batchOperation = this.getBatchOperation(context);
        if (batchOperation.getErrorCode() != 0L) {
            batchOperation.setTargetName(protectgroup.getName());
            protectionPathData.setOperation(batchOperation);
        }
        return protectionPathData;
    }

    public int getPolicyTemplateType() {
        return 17;
    }
}

