/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.protection.path.builder.ArrayHyperVaultProtectionPath;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArraySanHyperVaultProtectionPath
extends ArrayHyperVaultProtectionPath {
    private static final Log LOGGER = LogFactory.getInstance(ArraySanHyperVaultProtectionPath.class);

    @Override
    protected void initData(ExecutionContext context, ProtectGroup protectGroup) {
        Set replicaSet = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)replicaSet)) {
            LOGGER.error((Object)"Remote replicas not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica remoteReplica = null;
        for (ProtectGroupReplica replica : replicaSet) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica)) continue;
            remoteReplica = replica;
        }
        if (VerifyUtil.isEmpty(remoteReplica)) {
            LOGGER.error((Object)"Remote replicas not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        context.setAttribute("STORAGE_RESOURCES_KEY", this.getAllStorageResources(remoteReplica));
        context.setAttribute("REMOTE_REPLICA", (Object)remoteReplica);
    }

    private Map<String, StorageResource> getAllStorageResources(ProtectGroupReplica replica) {
        ArrayList<String> srcResources = new ArrayList<String>();
        ArrayList<String> tgtResources = new ArrayList<String>();
        for (ProtectObjectReplica por : replica.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                srcResources.add(rsi.getSrcStorageId());
                tgtResources.add(rsi.getStorageId());
            }
        }
        ArrayList allResources = new ArrayList();
        DrmEnumDefine.RESOURCE_TYPE_E resourceType = this.getResourceTypeByPgReplica();
        LOGGER.info((Object)"Resource type is %s", new Object[]{resourceType});
        allResources.addAll(this.getStorageService().getStorageResources(replica.getProductArray(), srcResources, resourceType));
        allResources.addAll(this.getStorageService().getStorageResources(replica.getRecoveryArray(), tgtResources, resourceType));
        HashMap<String, StorageResource> map = new HashMap<String, StorageResource>();
        for (StorageResource storageResource : allResources) {
            map.put(storageResource.getDevSn() + storageResource.getResourceId(), storageResource);
        }
        return map;
    }

    protected DrmEnumDefine.RESOURCE_TYPE_E getResourceTypeByPgReplica() {
        return DrmEnumDefine.RESOURCE_TYPE_E.LUN;
    }

    @Override
    protected String getRDPath(ExecutionContext context) {
        HashMap proLunInfo = new HashMap();
        HashMap recoveryLunInfo = new HashMap();
        StringBuffer sb = new StringBuffer();
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getAttribute("REMOTE_REPLICA", ProtectGroupReplica.class);
        HashSet pathSet = new HashSet();
        for (ProtectObjectReplica por : replica.getReplicas()) {
            this.getTargetLunNamesAndIp(por, recoveryLunInfo, context);
            List list = this.getProductLunNamesAndIp(por, proLunInfo, context);
            this.getResult(list, sb, proLunInfo, recoveryLunInfo, pathSet);
        }
        return sb.toString();
    }

    @Override
    protected String getSiteRelation(ExecutionContext context) {
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getAttribute("REMOTE_REPLICA", ProtectGroupReplica.class);
        String localDevSn = replica.getProductArray();
        String remoteDevSn = replica.getRecoveryArray();
        return super.getSiteRelation(localDevSn, remoteDevSn);
    }

    @Override
    public int getPolicyTemplateType() {
        return 30;
    }
}

