/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.service.path.AbstractProtectionPathImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OracleAllFlashProtectionPath
extends AbstractProtectionPathImpl {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashProtectionPath.class);

    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        ExecutionContext context = this.init(luns, batchOperation);
        ArrayList<ProtectionPath> pathList = new ArrayList<ProtectionPath>();
        ProtectionPath siteprotectionpath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        sitePathDetails.add(this.getSiteRelation(protectgroup));
        siteprotectionpath.setPathDetails(sitePathDetails);
        pathList.add(siteprotectionpath);
        rdPathDetails.add(this.getRDPath(protectgroup, context));
        ProtectionPath recoveryprotectionpath = new ProtectionPath();
        recoveryprotectionpath.setPathDetails(rdPathDetails);
        pathList.add(recoveryprotectionpath);
        ProtectionPathData pathData = new ProtectionPathData(pathList);
        if (batchOperation.getErrorCode() != 0L) {
            batchOperation.setTargetName(protectgroup.getName());
            pathData.setOperation(batchOperation);
        }
        return pathData;
    }

    protected String getSiteRelation(ProtectGroup protectgroup) {
        if (VerifyUtil.isEmpty((Object)protectgroup) || VerifyUtil.isEmpty((Collection)protectgroup.getReplicaList())) {
            LOGGER.error((Object)"Protectgroup is empty or replicalist is empty");
            throw new LegoCheckedException(1073947393L);
        }
        return protectgroup.getProductSiteName() + " --> " + this.getSiteService().getSiteById(((ProtectGroupReplica)protectgroup.getReplicaList().iterator().next()).getRecoverySite()).getName() + System.lineSeparator();
    }

    public int getPolicyTemplateType() {
        return 47;
    }

    protected String getRDPath(ProtectGroup protectgroup, ExecutionContext context) {
        HashMap proLunInfo = new HashMap();
        HashMap recoveryLunInfo = new HashMap();
        StringBuffer sb = new StringBuffer();
        for (ProtectGroupReplica protectgroupreplica : protectgroup.getReplicaList()) {
            HashSet pathSet = new HashSet();
            for (ProtectObjectReplica por : protectgroupreplica.getReplicas()) {
                this.getTargetLunNamesAndIp(por, recoveryLunInfo, context);
                List list = this.getProductLunNamesAndIp(por, proLunInfo, context);
                this.getResult(list, sb, proLunInfo, recoveryLunInfo, pathSet);
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

