/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayAsyncReplicationBuilder;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractArrayHyperMetroAsyncBuilder
extends AbstractReplicaBuilder {
    protected static final Log logger = LogFactory.getInstance(AbstractArrayHyperMetroAsyncBuilder.class);
    private static final String OLD_REPLICA = "OLD_REPLICA";
    private static final String NEW_RESOURCE_ID_SET = "NEW_RESOURCE_ID_SET";
    private ArrayAsyncReplicationBuilder asyncReplicationBuilder = new ArrayAsyncReplicationBuilder();

    public ArrayAsyncReplicationBuilder getAsyncReplicationBuilder() {
        return this.asyncReplicationBuilder;
    }

    public void setAsyncReplicationBuilder(ArrayAsyncReplicationBuilder asyncReplicationBuilder) {
        this.asyncReplicationBuilder = asyncReplicationBuilder;
    }

    public void buildReplica(ProtectGroup protectGroup) {
        this.check(protectGroup);
        ExecutionContext context = new ExecutionContext();
        this.init(protectGroup, context);
        this.buildProtectGroupReplica(protectGroup, context);
        this.dealProtectGroupReplicaStatus(protectGroup, context);
    }

    private void init(ProtectGroup protectGroup, ExecutionContext context) {
        if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
            context.setAttribute(OLD_REPLICA, null);
        } else {
            context.setAttribute(OLD_REPLICA, (Object)protectGroup.getAnyoneReplicationReplica());
        }
        HashSet newResourceIdSet = new HashSet();
        context.setAttribute(NEW_RESOURCE_ID_SET, newResourceIdSet);
    }

    private void dealProtectGroupReplicaStatus(ProtectGroup protectGroup, ExecutionContext context) {
        if (this.getReplicationType() == 1) {
            this.setProtectGroupReplicaStatus(protectGroup.getReplicaList(), DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue());
            return;
        }
        Object replicaObj = context.getAttribute(OLD_REPLICA);
        if (replicaObj == null) {
            this.setProtectGroupReplicaStatus(protectGroup.getReplicaList(), DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue());
            return;
        }
        ProtectGroupReplica oldProtectGroupReplica = (ProtectGroupReplica)replicaObj;
        Set newResourceIdSet = (Set)context.getAttribute(NEW_RESOURCE_ID_SET);
        if (this.existNewResource(oldProtectGroupReplica, newResourceIdSet)) {
            logger.info((Object)"Set protectGroupReplica status invalid! Because New resource is added!");
            this.setProtectGroupReplicaStatus(protectGroup.getReplicaList(), DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue());
            return;
        }
    }

    private void setProtectGroupReplicaStatus(Set<ProtectGroupReplica> replicaList, int status) {
        for (ProtectGroupReplica pgr : replicaList) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)pgr)) continue;
            pgr.setStatus(status);
        }
    }

    private boolean existNewResource(ProtectGroupReplica oldProtectGroupReplica, Set<String> newResourceIdSet) {
        Set protectObjectReplicas = oldProtectGroupReplica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)protectObjectReplicas)) {
            return true;
        }
        HashSet<String> oldResourceIdSet = new HashSet<String>();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            Set storageInfos = protectObjectReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageInfos)) continue;
            for (RelicaStorageInfo storageInfo : storageInfos) {
                oldResourceIdSet.add(storageInfo.getSrcStorageId());
            }
        }
        for (String newResourceId : newResourceIdSet) {
            if (oldResourceIdSet.contains(newResourceId)) continue;
            logger.info((Object)("New resource[" + newResourceId + "] is added!"), 90160758784000L);
            return true;
        }
        return false;
    }

    private void buildProtectGroupReplica(ProtectGroup protectGroup, ExecutionContext context) {
        this.clearProtectGroupReplica(protectGroup);
        ProtectGroupReplica protectGroupReplica = this.createProtectGroupReplica(protectGroup, context);
        protectGroup.getReplicaList().add(protectGroupReplica);
        this.buildProtectObjectReplica(protectGroup, context, protectGroupReplica);
    }

    protected ProtectGroupReplica createProtectGroupReplica(ProtectGroup protectGroup, ExecutionContext context) {
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName("REMOTEREPLICA-" + protectGroup.getName() + "-" + 1);
        String srcDeviceSN = this.getSrcDeviceSN(protectGroup);
        context.setAttribute("SRC_DEVICE", (Object)srcDeviceSN);
        protectGroupReplica.setProductArray(srcDeviceSN);
        protectGroupReplica.setType(this.getReplicationType());
        protectGroupReplica.setIndex(1);
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        return protectGroupReplica;
    }

    private void buildProtectObjectReplica(ProtectGroup protectGroup, ExecutionContext context, ProtectGroupReplica protectGroupRemoteReplica) {
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica protectObjectReplica = new ProtectObjectReplica();
            protectObjectReplica.setId(UUIDGenerator.getUUID());
            protectObjectReplica.setPoId(protectObject.getUuid());
            protectObjectReplica.setPgReplica(protectGroupRemoteReplica);
            protectGroupRemoteReplica.getReplicas().add(protectObjectReplica);
            this.buildProtectObjectStorageInfoReplica(protectGroup, protectObject, protectObjectReplica, context, protectGroupRemoteReplica);
        }
    }

    private void buildProtectObjectStorageInfoReplica(ProtectGroup protectGroup, ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, ExecutionContext context, ProtectGroupReplica protectGroupRemoteReplica) {
        Set newResourceIdSet = (Set)context.getAttribute(NEW_RESOURCE_ID_SET);
        String srcDevSN = (String)context.getAttribute("SRC_DEVICE");
        Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo posi : usedStorageResourceSet) {
            StorageResource srcRes = this.getSrcStorageResource(srcDevSN, posi);
            List<ReplicationPair> pairs = this.getPairsByResources(srcRes, posi.getResourceType());
            this.checkReplicationPair(srcRes, pairs);
            this.buildReplicationPairReplica(protectGroup, pairs, protectObjectReplica, posi, protectGroupRemoteReplica);
            newResourceIdSet.add(srcRes.getResourceId());
        }
    }

    protected List<ReplicationPair> getPairsByResources(StorageResource srcRes, Integer resourceType) {
        return this.asyncReplicationBuilder.getPairsByResources(resourceType, srcRes);
    }

    private void buildReplicationPairReplica(ProtectGroup protectGroup, List<ReplicationPair> pairs, ProtectObjectReplica protectObjectReplica, ProtectObjectStorageInfo posi, ProtectGroupReplica protectGroupRemoteReplica) {
        ReplicationPair replicationPair = pairs.iterator().next();
        boolean isSynchronization = this.getReplicationType() == 1;
        for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
            RemoteStorageReplica remoteStorageReplica = new RemoteStorageReplica();
            remoteStorageReplica.setId(UUIDGenerator.getUUID());
            remoteStorageReplica.setSrcStorageId(replicationPair.getSrcLunId());
            remoteStorageReplica.setSrcStorageProviderSN(replicationPair.getSrcDevSN());
            remoteStorageReplica.setStorageId(replicationTargetLun.getTgtLunId());
            remoteStorageReplica.setStorageProviderSN(replicationTargetLun.getTgtDevSN());
            remoteStorageReplica.setPoReplica(protectObjectReplica);
            remoteStorageReplica.setReplicationPairId(replicationPair.getReplicationId());
            remoteStorageReplica.setConsistentGroupId(replicationPair.getConsistentGroupId());
            if (!VerifyUtil.isEmpty((String)replicationPair.getVstorePairId()) && !replicationPair.getVstorePairId().startsWith("--")) {
                remoteStorageReplica.setVstorePairId(replicationPair.getVstorePairId());
                protectGroup.getProps().put("PROP_KEY_VSTORE_REPLICATION_PAIR_ID", replicationPair.getVstorePairId());
            }
            remoteStorageReplica.setSynchronization(Boolean.valueOf(isSynchronization));
            remoteStorageReplica.setProtectObjectStorageWwn(posi.getLunWWN());
            remoteStorageReplica.setDrRingId(replicationPair.getDrRingId());
            protectObjectReplica.getStorageInfos().add(remoteStorageReplica);
            protectGroupRemoteReplica.setRecoveryArray(replicationTargetLun.getTgtDevSN());
            protectGroupRemoteReplica.setRecoverySite(this.getSiteBySn(replicationTargetLun.getTgtDevSN()));
        }
    }

    private void clearProtectGroupReplica(ProtectGroup protectGroup) {
        if (protectGroup.getReplicaList() != null) {
            ProtectGroupUtil.clearRemoteReplicas((Set)protectGroup.getReplicaList());
        } else {
            protectGroup.setReplicaList(new HashSet());
        }
    }

    private void check(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"protectgroup is null!", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkReplicationPair(StorageResource srcRes, List<ReplicationPair> pairs) {
        if (VerifyUtil.isEmpty(pairs)) {
            logger.warn((Object)("master lun(" + srcRes.getMoId() + ")'s ReplicationPair is empty."), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
        if (pairs.size() != 1) {
            logger.error((Object)("pairs size is not one! size:" + pairs.size()), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    protected ProtectObjectStorageInfo randomAProtectObjectStorageInfo(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        this.checkEmpty(polist, "polist is empty! pgName : " + protectGroup.getName());
        ProtectObject po = (ProtectObject)polist.iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        this.checkEmpty(usedStorageResourceSet, "usedStorageResourceSet is empty! pgName : " + protectGroup.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName());
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi;
    }

    protected void checkEmpty(Collection<?> collection, String msg) {
        if (VerifyUtil.isEmpty(collection)) {
            logger.error((Object)msg, 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkEmpty(String str, String msg) {
        if (VerifyUtil.isEmpty((String)str)) {
            logger.error((Object)msg, 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkEmpty(Object obj, String msg) {
        if (VerifyUtil.isEmpty((Object)obj)) {
            logger.error((Object)msg, 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected int getReplicationType() {
        return 2;
    }

    protected abstract String getSrcDeviceSN(ProtectGroup var1);

    protected abstract StorageResource getSrcStorageResource(String var1, ProtectObjectStorageInfo var2);
}

