/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySyncReplicationBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Collection;

public class ArrayAsyncAsyncCascade3DCBuilder
extends ArraySyncReplicationBuilder {
    private static final Log logger = LogFactory.getInstance(ArrayAsyncAsyncCascade3DCBuilder.class);

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"Polist is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet())) {
            logger.error((Object)"UsedStorageResourceSet is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        protectGroup.getReplicaList().clear();
        String srcDevSN = ((ProtectObjectStorageInfo)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next()).getResourceProviderSN();
        String productSite = protectGroup.getProductSiteId();
        protectGroup.setPgReplicaIndex(1);
        protectGroup.setProductSiteId(productSite);
        if (VerifyUtil.isEmpty((String)srcDevSN)) {
            logger.error((Object)"AsyncAsync product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.getBuilderContext().put("REPLICA_INDEX", 1);
        this.getBuilderContext().put("PROTECT_TYPE", 2);
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        ExecutionContext context = this.initData(protectGroup);
        ProtectGroupReplica protectGroupReplicaAB = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplicaAB.setStatus(DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue());
        protectGroup.getReplicaList().add(protectGroupReplicaAB);
        this.getBuilderContext().put("REPLICA_INDEX", 2);
        this.getBuilderContext().put("PROTECT_TYPE", 2);
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue());
        this.getBuilderContext().put("SRC_DEVICE", protectGroupReplicaAB.getRecoveryArray());
        context = this.initDataBC(protectGroup);
        ProtectGroupReplica protectGroupReplicaBC = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplicaBC.setStatus(DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue());
        protectGroup.getReplicaList().add(protectGroupReplicaBC);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    protected void generatePosi(int protectLocation, ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
            Lun lunMo;
            if (DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue() == protectLocation) {
                lunMo = new Lun();
                lunMo.setDevSn(posi.getResourceProviderSN());
                lunMo.setResourceId(posi.getResourceId());
            } else {
                lunMo = this.getTgtLunBySrcLun(posi.getResourceProviderSN(), posi.getResourceId());
            }
            if (lunMo == null) {
                logger.warn((Object)("can't get lun info(" + posi.getResourceProviderSN() + "_" + posi.getResourceId() + ")."));
                throw new LegoCheckedException(1073948175L);
            }
            this.generatePosiByLun(2, protectObjectReplica, protectGroupReplica, posi, lunMo, context);
        }
    }

    @Override
    protected Lun getTgtLunBySrcLun(String deviceId, String lunId) {
        String tgtLunInfo = String.valueOf(this.getBuilderContext().get(this.getDevAndLun(deviceId, lunId)));
        if (!VerifyUtil.isEmpty((String)tgtLunInfo)) {
            Object[] info = tgtLunInfo.split(":");
            if (VerifyUtil.isEmpty((Object[])info) || info.length < 2) {
                return null;
            }
            Lun lun = new Lun();
            lun.setDevSn((String)info[0]);
            lun.setResourceId((String)info[1]);
            return lun;
        }
        return null;
    }
}

