/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySnapshotBuilder;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySanAirGapSnapshotFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class ArraySanAirGapSnapshotBuilder
extends ArraySnapshotBuilder {
    private static final Log logger = LogFactory.getInstance(ArraySanAirGapSnapshotBuilder.class);
    private ArraySanAirGapSnapshotFilter arraySanAirGapSnapshotFilter;

    @Override
    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return super.beforeDeleteProtectGroup(protectGroup);
    }

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            this.getLogger().error((Object)"ProtectGroup is null.1073947393");
            throw new LegoCheckedException(1073947393L);
        }
        this.getAirGapFilter().isMatch(new ArrayList<ProtectObject>(protectGroup.getPolist()));
        ProtectGroupUtil.clearRemoteReplicas((Set)protectGroup.getReplicaList());
        ExecutionContext siteAirGapContext = (ExecutionContext)this.getAttrFromFilterContext("SITE_PROVIDER_CONTEXT");
        List pairs = (List)siteAirGapContext.getAttribute("pairList");
        if (pairs.size() <= 0) {
            throw new LegoCheckedException(2117645L);
        }
        ReplicationPair anyPair = (ReplicationPair)pairs.stream().findFirst().get();
        this.getBuilderContext().put("REPLICA_INDEX", 1);
        this.getBuilderContext().put("PROTECT_TYPE", anyPair.getReplicationMode());
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        this.getBuilderContext().put("SRC_DEVICE", anyPair.getSrcDevSN());
        HashMap<String, ReplicationPair> repMap = new HashMap<String, ReplicationPair>();
        for (ReplicationPair replicationPair : pairs) {
            ReplicationTargetLun tgtLun = (ReplicationTargetLun)replicationPair.getRepTgtLuns().get(0);
            repMap.put(tgtLun.getTgtLunId(), replicationPair);
        }
        this.generateReplicaByPair(protectGroup, anyPair.getReplicationMode(), repMap);
        List siteInfoList = (List)this.getAttrFromFilterContext("siteInfoList");
        if (!CollectionUtils.isEmpty((Collection)siteInfoList)) {
            protectGroup.getProps().put("PROP_KEY_SITE_INFO", JSONArray.fromObject((Object)siteInfoList).toString());
        }
        protectGroup.getProps().put("isAirGapType", "true");
    }

    protected void generateReplicaByPair(ProtectGroup protectGroup, Integer replicaMode, Map<String, ReplicationPair> repMap) {
        String airGapDevSn = (String)this.getAttrFromFilterContext("airGapDevSn");
        ProtectGroupReplica replica = new ProtectGroupReplica();
        replica.setId(UUIDGenerator.getUUID());
        replica.setName("REMOTEREPLICA-" + protectGroup.getName() + "-" + this.getString("REPLICA_INDEX"));
        replica.setProductArray(this.getString("SRC_DEVICE"));
        replica.setRecoveryArray(airGapDevSn);
        replica.setType(this.getInt("PROTECT_TYPE"));
        replica.setIndex(this.getInt("REPLICA_INDEX"));
        replica.setPg(protectGroup);
        replica.setStatus(DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue());
        replica.setProtectLocation(this.getInt("PROTECT_LOCATION"));
        this.genPoReplica(protectGroup, replica, repMap);
        int status = replicaMode.equals(1) ? DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue() : DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue();
        replica.setStatus(status);
        protectGroup.getReplicaList().add(replica);
    }

    private void genPoReplica(ProtectGroup protectGroup, ProtectGroupReplica replica, Map<String, ReplicationPair> repMap) {
        protectGroup.getPolist().forEach(protectObject -> {
            ProtectObjectReplica poReplica = new ProtectObjectReplica();
            poReplica.setId(UUIDGenerator.getUUID());
            poReplica.setPoId(protectObject.getUuid());
            poReplica.setPgReplica(replica);
            this.generatePosi((ProtectObject)protectObject, poReplica, repMap);
            replica.getReplicas().add(poReplica);
        });
    }

    private void generatePosi(ProtectObject protectObject, ProtectObjectReplica poReplica, Map<String, ReplicationPair> repMap) {
        for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
            ReplicationPair replicationPair = repMap.get(posi.getResourceId());
            if (VerifyUtil.isEmpty((Object)replicationPair)) {
                this.getLogger().warn((Object)("No pair for:" + posi.getResourceName()));
                continue;
            }
            for (ReplicationTargetLun repTargetLun : replicationPair.getRepTgtLuns()) {
                RemoteStorageReplica storageReplica = new RemoteStorageReplica();
                storageReplica.setId(UUIDGenerator.getUUID());
                storageReplica.setSrcStorageId(replicationPair.getSrcLunId());
                storageReplica.setSrcStorageProviderSN(replicationPair.getSrcDevSN());
                storageReplica.setStorageId(repTargetLun.getTgtLunId());
                storageReplica.setStorageProviderSN(repTargetLun.getTgtDevSN());
                storageReplica.setPoReplica(poReplica);
                storageReplica.setReplicationPairId(replicationPair.getReplicationId());
                storageReplica.setVstorePairId(replicationPair.getVstorePairId());
                storageReplica.setConsistentGroupId(replicationPair.getConsistentGroupId());
                storageReplica.setSynchronization(Boolean.valueOf(replicationPair.getReplicationMode() == 1));
                storageReplica.setProtectObjectStorageWwn(posi.getLunWWN());
                poReplica.getStorageInfos().add(storageReplica);
                poReplica.getPgReplica().setRecoveryArray(repTargetLun.getTgtDevSN());
                String recoverySiteId = this.getSiteBySn(repTargetLun.getTgtDevSN());
                poReplica.getPgReplica().setRecoverySite(recoverySiteId);
            }
        }
    }

    @Override
    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        String airGapDevSn = (String)this.getAttrFromFilterContext("airGapDevSn");
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), airGapDevSn);
        return result;
    }

    @Override
    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        HashMap<String, List<ProtectObjectStorageInfo>> map = new HashMap<String, List<ProtectObjectStorageInfo>>();
        protectGroup.distinctStorageInfo().forEach(storageInfo -> ProtectGroupUtil.putObjectToMap((Map)map, (Object)storageInfo.getResourceProviderSN(), (Object)storageInfo));
        return map;
    }

    @Override
    public int getType() {
        return 44;
    }

    public void setArraySanAirGapSnapshotFilter(ArraySanAirGapSnapshotFilter arraySanAirGapSnapshotFilter) {
        this.arraySanAirGapSnapshotFilter = arraySanAirGapSnapshotFilter;
    }

    protected <T> T getAttrFromFilterContext(String key) {
        return (T)this.arraySanAirGapSnapshotFilter.getFilterContext().get(key);
    }

    protected ArraySanAirGapSnapshotFilter getAirGapFilter() {
        return this.arraySanAirGapSnapshotFilter;
    }

    protected Log getLogger() {
        return logger;
    }
}

