/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayAsyncReplicationBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySnapshotBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ArraySanHyperVaultBuilder
extends AbstractReplicaBuilder {
    private static Log logger = LogFactory.getInstance(ArraySanHyperVaultBuilder.class);
    private ArrayAsyncReplicationBuilder asyncReplicationBuilder;
    private ArraySnapshotBuilder arraySnapshotBuilder;

    public void buildReplica(ProtectGroup protectGroup) {
        this.buildReplica(protectGroup, (IReplicaBuilder)this.asyncReplicationBuilder);
    }

    protected void buildReplica(ProtectGroup protectGroup, IReplicaBuilder builder) {
        builder.buildReplica(protectGroup);
    }

    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        logger.debug((Object)"delete replicas before deleteProtectGroup.");
        Set<ProtectGroupReplica> faildReplicas = this.arraySnapshotBuilder.beforeDeleteProtectGroup(protectGroup);
        protectGroup.getReplicaList().clear();
        protectGroup.getReplicaList().addAll(faildReplicas);
        return faildReplicas;
    }

    public void deleteSnapshots(ProtectGroupReplica protectGroupReplica) {
        this.arraySnapshotBuilder.deleteSnapshotsOnPgr(protectGroupReplica);
    }

    public int getType() {
        return 30;
    }

    public void setAsyncReplicationBuilder(ArrayAsyncReplicationBuilder asyncReplicationBuilder) {
        this.asyncReplicationBuilder = asyncReplicationBuilder;
    }

    public void setArraySnapshotBuilder(ArraySnapshotBuilder arraySnapshotBuilder) {
        this.arraySnapshotBuilder = arraySnapshotBuilder;
    }

    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        ProtectGroupReplica remoteReplica = protectGroup.getAnyoneReplicationReplica();
        if (null == remoteReplica) {
            logger.error((Object)("There's no remote ProtectGroupReplica in ProtectGroup." + protectGroup.getUuid()));
            throw new LegoCheckedException(1073947394L);
        }
        result.put(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue(), remoteReplica.getProductArray());
        result.put(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), remoteReplica.getRecoveryArray());
        return result;
    }

    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        ProtectGroupReplica replica = protectGroup.getAnyoneReplicationReplica();
        HashMap<String, List<ProtectObjectStorageInfo>> map = new HashMap<String, List<ProtectObjectStorageInfo>>();
        HashMap<String, ProtectObjectStorageInfo> storageInfoMap = new HashMap<String, ProtectObjectStorageInfo>();
        protectGroup.distinctStorageInfo().forEach(poStorageInfo -> storageInfoMap.put(poStorageInfo.getResourceProviderSN() + poStorageInfo.getResourceId(), (ProtectObjectStorageInfo)poStorageInfo));
        this.putStorageInfo(replica, map, storageInfoMap);
        return map;
    }

    protected void putStorageInfo(ProtectGroupReplica replica, Map<String, List<ProtectObjectStorageInfo>> map, Map<String, ProtectObjectStorageInfo> storageInfoMap) {
        replica.getReplicas().forEach(poReplica -> poReplica.getStorageInfos().forEach(storageInfo -> {
            String replicaKey = storageInfo.getSrcStorageProviderSN() + storageInfo.getSrcStorageId();
            ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)storageInfoMap.get(replicaKey);
            if (null != info) {
                this.convertReplicaInfoToStorageInfo(map, info, (RelicaStorageInfo)storageInfo);
                ProtectGroupUtil.putObjectToMap((Map)map, (Object)info.getResourceProviderSN(), (Object)info);
            }
        }));
    }

    protected void convertReplicaInfoToStorageInfo(Map<String, List<ProtectObjectStorageInfo>> map, ProtectObjectStorageInfo poStorageInfo, RelicaStorageInfo storageInfo) {
        ProtectObjectStorageInfo tgtStorageInfo = new ProtectObjectStorageInfo();
        String tgtDevSn = storageInfo.getStorageProviderSN();
        tgtStorageInfo.setResourceProviderSN(tgtDevSn);
        tgtStorageInfo.setResourceId(storageInfo.getStorageId());
        tgtStorageInfo.setArchiveLog(poStorageInfo.getArchiveLog());
        tgtStorageInfo.setLunWWN(poStorageInfo.getLunWWN());
        ProtectGroupUtil.putObjectToMap(map, (Object)tgtDevSn, (Object)tgtStorageInfo);
    }

    protected static ProtectGroupReplica getPgReplicaByLocation(ProtectGroup protectGroup, int protectLocation) {
        List pgReplicaList = protectGroup.listAllReplicatonRepica();
        Optional<ProtectGroupReplica> replicaOpt = pgReplicaList.stream().filter(replica -> replica.getProtectLocation() == protectLocation).findFirst();
        if (!replicaOpt.isPresent()) {
            logger.error((Object)"Not find replica by protectLocation:{} of protectGroup uuid:{}", new Object[]{protectLocation, protectGroup.getUuid()});
            throw new LegoCheckedException(1073947394L);
        }
        return replicaOpt.get();
    }
}

