/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayAsyncHyperMetroBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanHyperVaultBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArraySanVaultHyperMetroBuidler
extends ArraySanHyperVaultBuilder {
    private static Log logger = LogFactory.getInstance(ArraySanVaultHyperMetroBuidler.class);
    private ArrayAsyncHyperMetroBuilder arrayAsyncHyperMetroBuilder;

    @Override
    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return super.beforeDeleteProtectGroup(protectGroup);
    }

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        this.buildReplica(protectGroup, (IReplicaBuilder)this.arrayAsyncHyperMetroBuilder);
    }

    @Override
    public int getType() {
        return 32;
    }

    public ArrayAsyncHyperMetroBuilder getArrayAsyncHyperMetroBuilder() {
        return this.arrayAsyncHyperMetroBuilder;
    }

    public void setArrayAsyncHyperMetroBuilder(ArrayAsyncHyperMetroBuilder arrayAsyncHyperMetroBuilder) {
        this.arrayAsyncHyperMetroBuilder = arrayAsyncHyperMetroBuilder;
    }

    @Override
    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        Map<Integer, String> result = super.getProtectedDeviceSn(protectGroup);
        ProtectGroupReplica remoteReplica = protectGroup.getAnyoneReplicationReplica();
        ProtectObjectReplica protectObjectReplica = (ProtectObjectReplica)remoteReplica.getReplicas().iterator().next();
        RelicaStorageInfo storageInfo = (RelicaStorageInfo)protectObjectReplica.getStorageInfos().iterator().next();
        String devSn = storageInfo.getStorageProviderSN();
        String resourceId = storageInfo.getStorageId();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        Lun lun = storageService.getLunBySnAndLunId(devSn, resourceId);
        if (VerifyUtil.isEmpty((Object)lun)) {
            throw new LegoCheckedException(2117645L, "lun does not exist: lunId=" + resourceId);
        }
        List allStorageResources = storageService.getStorageResourceByWwn(new String[]{lun.getWwn()});
        for (StorageResource storageResource : allStorageResources) {
            if (result.containsValue(storageResource.getDevSn())) continue;
            result.put(DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue(), storageResource.getDevSn());
            break;
        }
        return result;
    }

    @Override
    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        Map<String, List<ProtectObjectStorageInfo>> map = super.getAllStroageInfo(protectGroup);
        ProtectGroupReplica replica = protectGroup.getAnyoneReplicationReplica();
        String devSn = null;
        HashSet<String> set = new HashSet<String>();
        for (ProtectObjectReplica protectObjectReplica : replica.getReplicas()) {
            for (Object relicaStorageInfo : protectObjectReplica.getStorageInfos()) {
                devSn = relicaStorageInfo.getStorageProviderSN();
                set.add(relicaStorageInfo.getStorageId());
            }
        }
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List luns = storageService.queryLunByDevSnAndLunIds(devSn, new ArrayList(set));
        HashSet<String> wwnSet = new HashSet<String>();
        for (Lun lun : luns) {
            wwnSet.add(lun.getWwn());
        }
        List allStorageResources = storageService.getStorageResourceByWwn(wwnSet.toArray(new String[wwnSet.size()]));
        HashMap<String, List<StorageResource>> wwnMap = new HashMap<String, List<StorageResource>>();
        for (StorageResource resource : allStorageResources) {
            ArrayList<StorageResource> list = (ArrayList<StorageResource>)wwnMap.get(((Lun)resource).getWwn());
            if (null == list) {
                list = new ArrayList<StorageResource>();
            }
            list.add(resource);
            wwnMap.put(((Lun)resource).getWwn(), list);
        }
        for (StorageResource resource : allStorageResources) {
            if (resource.getDevSn().equals(devSn)) continue;
            ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
            info.setResourceProviderSN(resource.getDevSn());
            info.setResourceId(resource.getResourceId());
            ProtectObjectStorageInfo remote = this.getRemoteProtectObjectStorageInfo(map, wwnMap, devSn, resource);
            if (null != remote) {
                info.setArchiveLog(remote.getArchiveLog());
            }
            info.setLunWWN(((Lun)resource).getWwn());
            ProtectGroupUtil.putObjectToMap(map, (Object)resource.getDevSn(), (Object)info);
        }
        return map;
    }

    private ProtectObjectStorageInfo getRemoteProtectObjectStorageInfo(Map<String, List<ProtectObjectStorageInfo>> map, Map<String, List<StorageResource>> wwnMap, String remoteDevSn, StorageResource resource) {
        List<ProtectObjectStorageInfo> list = map.get(remoteDevSn);
        if (null == list) {
            return null;
        }
        for (ProtectObjectStorageInfo storageInfo : list) {
            if (storageInfo.getLunWWN().equals(((Lun)resource).getWwn())) {
                return storageInfo;
            }
            StorageResource hyperMetroResource = this.getHyperMetroResource(wwnMap, resource);
            if (null == hyperMetroResource || !storageInfo.getResourceProviderSN().equals(hyperMetroResource.getDevSn()) || !storageInfo.getResourceId().equals(hyperMetroResource.getResourceId())) continue;
            return storageInfo;
        }
        return null;
    }

    private StorageResource getHyperMetroResource(Map<String, List<StorageResource>> wwnMap, StorageResource storageResource) {
        List<StorageResource> list = wwnMap.get(((Lun)storageResource).getWwn());
        if (null == list) {
            return null;
        }
        for (StorageResource resource : list) {
            if (resource.getDevSn().equals(storageResource.getDevSn())) continue;
            return resource;
        }
        return null;
    }
}

