/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArraySnapshotBuilder
extends AbstractReplicaBuilder {
    private static Log logger = LogFactory.getInstance(ArraySnapshotBuilder.class);

    public void buildReplica(ProtectGroup protectGroup) {
        logger.debug((Object)"build Replica");
    }

    public int getType() {
        return 2;
    }

    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        logger.debug((Object)("beforeDeletePg: " + protectGroup.getName()));
        HashSet<ProtectGroupReplica> failedDeleteReplicaSet = new HashSet<ProtectGroupReplica>();
        for (ProtectGroupReplica pgr : protectGroup.getReplicaList()) {
            if (pgr.isStorageReplicationReplica()) continue;
            ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
            IReplicaFactory factory = manager.getReplicaFactory(pgr.getType());
            try {
                factory.deleteReplicas(protectGroup, Arrays.asList(pgr), true);
            }
            catch (Exception e) {
                logger.error((Object)("delete replica failed. replicaName:" + pgr.getName()));
                failedDeleteReplicaSet.add(pgr);
            }
        }
        return failedDeleteReplicaSet;
    }

    public void deleteSnapshotsOnPgr(ProtectGroupReplica protectGroupReplica) {
        if (null == protectGroupReplica || protectGroupReplica.isStorageReplicationReplica()) {
            logger.info((Object)"protectGroupReplica is null ");
            return;
        }
        ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
        IReplicaFactory factory = manager.getReplicaFactory(protectGroupReplica.getType());
        try {
            factory.deleteReplicas(protectGroupReplica.getPg(), Arrays.asList(protectGroupReplica), true);
        }
        catch (Exception e) {
            logger.error((Object)("delete replica failed. replicaName:" + protectGroupReplica.getName()));
        }
    }

    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Set protectObjects = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)protectObjects)) {
            throw new LegoCheckedException(1073947393L);
        }
        Set storageInfos = ((ProtectObject)protectObjects.iterator().next()).getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            throw new LegoCheckedException(1073947393L);
        }
        result.put(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue(), ((ProtectObjectStorageInfo)storageInfos.iterator().next()).getResourceProviderSN());
        return result;
    }

    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        HashMap<String, List<ProtectObjectStorageInfo>> map = new HashMap<String, List<ProtectObjectStorageInfo>>();
        protectGroup.distinctStorageInfo().forEach(storageInfo -> ProtectGroupUtil.putObjectToMap((Map)map, (Object)storageInfo.getResourceProviderSN(), (Object)storageInfo));
        return map;
    }
}

