/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySnapshotBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.Set;

public class NasSnapshotBuilder
extends ArraySnapshotBuilder {
    private static Log logger = LogFactory.getInstance(NasSnapshotBuilder.class);

    @Override
    public int getType() {
        logger.debug((Object)"type:PolicyTemplateType.NAS_SNAPSHOT");
        return 14;
    }

    protected int getReplicationType() {
        logger.debug((Object)"getReplicationType: DrmConstant.PROTECT_TYPE_NAS_SNAPSHOT");
        return 8;
    }

    @Override
    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        logger.debug((Object)("beforeDeletePg: " + protectGroup.getName()));
        HashSet<ProtectGroupReplica> failedDeleteReplicaSet = new HashSet<ProtectGroupReplica>();
        HashSet<RelicaStorageInfo> failedStorageInfoSet = new HashSet<RelicaStorageInfo>();
        for (ProtectGroupReplica pgr : protectGroup.getReplicaList()) {
            for (ProtectObjectReplica por : pgr.getReplicas()) {
                for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                    if (!(rsi instanceof LocalStorageReplica) || this.deleteSnapshot((LocalStorageReplica)rsi)) continue;
                    failedStorageInfoSet.add(rsi);
                }
            }
        }
        if (!VerifyUtil.isEmpty(failedStorageInfoSet)) {
            ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)protectGroup.getReplicaList().iterator().next();
            try {
                ProtectGroupReplica clonePgReplica = (ProtectGroupReplica)protectGroupReplica.clone();
                Set poReplicaSet = clonePgReplica.getReplicas();
                ProtectObjectReplica protectObjectReplica = (ProtectObjectReplica)poReplicaSet.iterator().next();
                protectObjectReplica.setStorageInfos(failedStorageInfoSet);
                poReplicaSet.clear();
                poReplicaSet.add(protectObjectReplica);
                failedDeleteReplicaSet.add(clonePgReplica);
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)("clone pgreplica error! error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return failedDeleteReplicaSet;
    }

    private boolean deleteSnapshot(LocalStorageReplica localStorageReplica) {
        if ("NONE".equals(localStorageReplica.getStorageId())) {
            logger.info((Object)("deleteSnapshotOnStorage success: " + localStorageReplica.getSnapshotName()), 90160758784001L);
            return true;
        }
        IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(localStorageReplica.getSrcStorageProviderSN());
        try {
            OperationResult or = fileSystemSnapshotManagerProxy.deleteSnapshot(localStorageReplica.getSrcStorageProviderSN(), localStorageReplica.getStorageId());
            if (or.isSuccess()) {
                return true;
            }
            String errorCode = or.getErrorCode();
            long errCode = 1073948679L;
            try {
                errCode = Long.parseLong(errorCode);
            }
            catch (Exception e) {
                logger.error((Object)("operation<Long.parseLong(errorCode)> error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 1073948679L);
            }
            throw new LegoCheckedException(errCode, or.getArgs());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("deleteSnapshotOnStorage error: " + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + localStorageReplica.getSnapshotName() + ",Id:" + localStorageReplica.getStorageId() + "," + ExceptionUtil.getErrorMessage((Throwable)e) + ", errorcode:" + e.getErrorCode()));
            if (e.getErrorCode() == 1073754118L) {
                return true;
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("deleteSnapshotOnStorage error: " + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + localStorageReplica.getSnapshotName() + ",Id:" + localStorageReplica.getStorageId() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("deleteSnapshotOnStorage error: " + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + localStorageReplica.getSnapshotName() + ",Id:" + localStorageReplica.getStorageId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return false;
    }
}

