/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder.oracle;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySyncReplicationBuilder;
import com.huawei.ism.drm.storage.protection.template.filter.oracle.OracleAllFlashFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OracleAllFlashBuilder
extends ArraySyncReplicationBuilder {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashBuilder.class);
    protected static final String LUNID_TO_PAIR = "LUNID_TO_PAIR";
    private OracleAllFlashFilter oracleAllFlashFilter;

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        if (protectGroup == null || VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) || VerifyUtil.isEmpty((Collection)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet())) {
            LOGGER.error((Object)"ProtectGroup is invalid");
            throw new LegoCheckedException(1073947393L);
        }
        protectGroup.getReplicaList().clear();
        String srcDevSN = ((ProtectObjectStorageInfo)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next()).getResourceProviderSN();
        protectGroup.setPgReplicaIndex(1);
        if (VerifyUtil.isEmpty((String)srcDevSN)) {
            LOGGER.error((Object)"Product array is null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica protectGroupReplicaAB = this.buildProtectGroupReplica(protectGroup, 1, 1, DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), srcDevSN);
        protectGroup.getReplicaList().add(protectGroupReplicaAB);
        this.setPgProps(protectGroup, "STAND_BY_HOSTSNS", this.oracleAllFlashFilter);
        this.setPgProps(protectGroup, "REMOTE_PAIR_SRCLUNIDS", this.oracleAllFlashFilter);
        this.setPgProps(protectGroup, "REMOTE_PAIR_TRGLUNIDS", this.oracleAllFlashFilter);
        this.setPgProps(protectGroup, "DB_NAMES", this.oracleAllFlashFilter);
        this.setPgProps(protectGroup, "REDO_LUN_WWN", this.oracleAllFlashFilter);
        this.setPgProps(protectGroup, "REDO_BACK_UP_LUN_IDS", this.oracleAllFlashFilter);
    }

    private void setPgProps(ProtectGroup protectGroup, String key, OracleAllFlashFilter oracleAllFlashFilter) {
        Object object = oracleAllFlashFilter.getFilterContext().get(key);
        if (object instanceof String) {
            protectGroup.getProps().put(key, (String)object);
        }
    }

    @Override
    public int getType() {
        return 47;
    }

    @Override
    protected Map<String, List<ReplicationPair>> getLunIdPairMap(Set<String> resIdSet, List<Lun> lunList) {
        if (VerifyUtil.isEmpty(resIdSet) || VerifyUtil.isEmpty(lunList)) {
            return new HashMap<String, List<ReplicationPair>>();
        }
        Lun[] lunArray = lunList.toArray(new Lun[0]);
        long startTime = System.currentTimeMillis();
        List<ReplicationPair> pairList = this.getPairs(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue(), (StorageResource[])lunArray);
        LOGGER.debug((Object)"Get getPairsByLun. cost time:s%", System.currentTimeMillis() - startTime);
        return this.classifyPairs(pairList);
    }

    private Map<String, List<ReplicationPair>> classifyPairs(List<ReplicationPair> replicationPairList) {
        if (VerifyUtil.isEmpty(replicationPairList)) {
            LOGGER.warn((Object)"replicationPairList is empty.");
            throw new LegoCheckedException(1073948175L);
        }
        return replicationPairList.stream().distinct().collect(Collectors.groupingBy(ReplicationPair::getSrcLunId));
    }

    @Override
    public void generatePosi(int protectLocation, ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        LOGGER.debug((Object)"Generate Posi");
        for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
            Lun lunMo = new Lun();
            lunMo.setDevSn(posi.getResourceProviderSN());
            String lunId = posi.getResourceId();
            lunMo.setLunId(lunId);
            Map lunIdToPair = new HashMap();
            if (context.getAttribute(LUNID_TO_PAIR) instanceof Map) {
                lunIdToPair = (Map)context.getAttribute(LUNID_TO_PAIR);
            }
            if (!lunIdToPair.containsKey(lunId)) continue;
            ReplicationPair pair = (ReplicationPair)((List)lunIdToPair.get(lunId)).get(0);
            String siteASN = null;
            String siteBSN = null;
            if (this.oracleAllFlashFilter.getFilterContext().get("siteASn") instanceof String) {
                siteASN = (String)this.oracleAllFlashFilter.getFilterContext().get("siteASn");
            }
            if (this.oracleAllFlashFilter.getFilterContext().get("siteBSn") instanceof String) {
                siteBSN = (String)this.oracleAllFlashFilter.getFilterContext().get("siteBSn");
            }
            if (!pair.getSrcDevSN().equals(siteASN) || !pair.getTgtDevSN().equals(siteBSN)) continue;
            Integer replicationMode = ((ReplicationPair)((List)lunIdToPair.get(lunId)).get(0)).getReplicationMode();
            this.generatePosiByLun(replicationMode, protectObjectReplica, protectGroupReplica, posi, lunMo, context);
        }
    }

    public void setOracleAllFlashFilter(OracleAllFlashFilter oracleAllFlashFilter) {
        this.oracleAllFlashFilter = oracleAllFlashFilter;
    }

    private ProtectGroupReplica buildProtectGroupReplica(ProtectGroup protectGroup, int replicaIndex, int protectType, int protectLocation, String srcDevSN) {
        this.getBuilderContext().put("REPLICA_INDEX", replicaIndex);
        this.getBuilderContext().put("PROTECT_TYPE", protectType);
        this.getBuilderContext().put("PROTECT_LOCATION", protectLocation);
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        ExecutionContext context = this.initData(protectGroup);
        ProtectGroupReplica protectGroupReplica = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplica.setStatus(DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue());
        return protectGroupReplica;
    }
}

