/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class AbstractReplicaFactory
implements IReplicaFactory {
    private static final String COPY_NAME_PREFIX = "CopyFrom_";
    private static final int COPY_NAME_LENGTH = 256;
    private static final Log logger = LogFactory.getInstance(AbstractReplicaFactory.class);

    protected String buildReplicaName(ProtectGroupReplica sourceReplica) {
        if (null == sourceReplica) {
            return "CopyFrom_Null";
        }
        String name = COPY_NAME_PREFIX + sourceReplica.getName() + "_" + this.getCurrentDate();
        if (name.length() > 256) {
            name = COPY_NAME_PREFIX + sourceReplica.getId() + "_" + this.getCurrentDate();
        }
        return name;
    }

    private String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateFormat.format(date);
    }

    public void deleteReplicas(ProtectGroup pg, List<ProtectGroupReplica> toDelete, boolean isNeedSendAlarm) {
        if (VerifyUtil.isEmpty(toDelete)) {
            logger.debug((Object)String.format("The replicas which need delete is empty! pg is %s", pg));
            return;
        }
        toDelete.forEach(replica -> this.deleteReplica((ProtectGroupReplica)replica, isNeedSendAlarm));
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        List failedIds = replicaService.deleteProtectGroupReplicaFromDBById(toDelete);
        if (!VerifyUtil.isEmpty((Collection)failedIds)) {
            logger.error((Object)String.format("delete replicas failed, cause by visit db exception, replicaIds is %s", failedIds));
        }
    }

    protected void deleteReplica(ProtectGroupReplica toDelete, boolean isNeedSendAlarm) {
        logger.debug((Object)"deleteReplicaOnStroage.");
    }

    protected String getIpAddress(String devSn) {
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{devSn});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            return ((DrResource)resources.get(0)).getIpAddress();
        }
        return "";
    }
}

