/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSnapshotManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSnapshotManager;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.protection.replica.factory.SnapshotReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class AntiBlackmailReplicaFactory
extends SnapshotReplicaFactory {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailReplicaFactory.class);

    @Override
    public int getFactoryType() {
        return 11;
    }

    @Override
    protected List<Snapshot> querySnapshot(LocalStorageReplica localStorageReplica) {
        String deviceSN = localStorageReplica.getSrcStorageProviderSN();
        String snapshotUuid = localStorageReplica.getSnapshotName();
        String resourceUuid = localStorageReplica.getPoReplica().getPlaceholderProtectObjectId();
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(deviceSN);
        Optional snapshotOptional = snapshotManager.querySpecificSnapshot(deviceSN, resourceUuid, snapshotUuid);
        if (!snapshotOptional.isPresent()) {
            LOGGER.error((Object)"Can't query the snapshot with id(:%s), resourceUuid: %s, dev sn: %s.", new Object[]{snapshotUuid, resourceUuid, deviceSN});
            return Collections.emptyList();
        }
        Snapshot snapshot = new Snapshot();
        snapshot.setName(((AntiBlackmailSnapshot)snapshotOptional.get()).getUuid());
        return Collections.singletonList(snapshot);
    }

    @Override
    protected OperationResult deleteSnapshot(LocalStorageReplica localStorageReplica, Snapshot snapshot) {
        String deviceSN = localStorageReplica.getSrcStorageProviderSN();
        String snapshotUuid = localStorageReplica.getSnapshotName();
        LOGGER.info((Object)"Delete antiBlackmail snapshot{%s} on the storage device{%s}.", new Object[]{snapshotUuid, deviceSN});
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(deviceSN);
        OperationResult operationResult = snapshotManager.deleteSpecificSnapshot(deviceSN, snapshotUuid);
        if (!operationResult.isSuccess()) {
            LOGGER.error((Object)"The delete copy task send failed, dev sn: %s, snapshotUuid: %s.", new Object[]{deviceSN, snapshotUuid});
            AntiBlackmailUtil.sendDeleteFailAlarmMsg((String)deviceSN, (String)localStorageReplica.getPoReplica().getPgReplica().getPg().getName(), (String)snapshotUuid);
            operationResult.setSuccess(true);
        } else {
            AntiBlackMailConstant.DELETE_PM_SNAPSHOT_EXECUTOR.submit(() -> AntiBlackmailUtil.dealResultAndSendAlarm((String)deviceSN, (String)snapshotUuid, (ProtectGroupReplica)localStorageReplica.getPoReplica().getPgReplica()));
        }
        return operationResult;
    }
}

