/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.google.common.base.Joiner;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaTools;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.protection.replica.factory.AbstractReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SnapshotReplicaFactory
extends AbstractReplicaFactory {
    private static Log logger = LogFactory.getInstance(SnapshotReplicaFactory.class);

    public ProtectGroupReplica createReplica(ProtectGroupReplica sourceReplica) {
        ProtectGroupReplica cloneReplica = null;
        try {
            cloneReplica = (ProtectGroupReplica)sourceReplica.clone();
            cloneReplica.setId(UUIDGenerator.getUUID());
            cloneReplica.setName("SnapshotCopy_" + this.buildReplicaName(sourceReplica));
            cloneReplica.setSourceReplicaId(sourceReplica.getId());
            cloneReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            cloneReplica.setMountedHost("");
            cloneReplica.addProperty("planId", null);
            cloneReplica.setGeneration(Integer.valueOf(2));
            String parentType = sourceReplica.getProperty("ParentType");
            if (!VerifyUtil.isEmpty((String)parentType)) {
                cloneReplica.addProperty("ParentType", parentType);
            } else {
                cloneReplica.addProperty("ParentType", String.valueOf(sourceReplica.getType()));
            }
            Set replicaList = cloneReplica.getReplicas();
            String devId = sourceReplica.getStorageDeviceId();
            HashMap<String, Snapshot> context = new HashMap<String, Snapshot>();
            HashMap<String, SnapshotConsistentGroup> snapshotConsistentGroupMap = new HashMap<String, SnapshotConsistentGroup>();
            for (ProtectObjectReplica protectObjectReplica : replicaList) {
                protectObjectReplica.setId(UUIDGenerator.getUUID());
                Set protectObjectStorageList = protectObjectReplica.getStorageInfos();
                RelicaStorageInfo relicaStorageInfo = (RelicaStorageInfo)CommonUtil.getFirstElement((Collection)protectObjectStorageList);
                if (!VerifyUtil.isEmpty((Object)relicaStorageInfo) && relicaStorageInfo instanceof LocalStorageReplica && !VerifyUtil.isEmpty((String)((LocalStorageReplica)relicaStorageInfo).getConsistentGroupId())) {
                    this.buildSnapGroupReplica(devId, protectObjectReplica, snapshotConsistentGroupMap);
                    continue;
                }
                this.buildSnapshotReplica(devId, protectObjectStorageList, context);
            }
            cloneReplica.setType(3);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"An error occurred while cloning a copy");
        }
        return cloneReplica;
    }

    private void buildSnapshotReplica(String devId, Set<RelicaStorageInfo> protectObjectStorageList, Map<String, Snapshot> context) {
        StorageSnapshotManagerProxy proxy = StorageSnapshotManagerProxy.getInstance();
        IStorageSnapshotManager snapshotManager = proxy.getStorageSnapshotMgrByDevId(devId);
        for (RelicaStorageInfo storageInfo : protectObjectStorageList) {
            String copyName;
            if (!(storageInfo instanceof LocalStorageReplica)) break;
            storageInfo.setId(UUIDGenerator.getUUID());
            String devSn = storageInfo.getSrcStorageProviderSN();
            String srcSnapshotId = storageInfo.getStorageId();
            String lunId = storageInfo.getSrcStorageId();
            int type = Optional.of(storageInfo.getPoReplica().getPgReplica().getType()).orElse(0);
            boolean isHyperCDP = false;
            if (type == 102) {
                copyName = "DRdata_Secure" + lunId + "_" + System.currentTimeMillis();
                isHyperCDP = true;
            } else {
                copyName = "DRdata_" + lunId + "_" + System.currentTimeMillis();
            }
            Snapshot snapshot = context.get(storageInfo.getSrcStorageId());
            if (snapshot == null) {
                snapshot = snapshotManager.copySnapshot(devSn, srcSnapshotId, copyName, isHyperCDP);
                context.put(storageInfo.getSrcStorageId(), snapshot);
            }
            storageInfo.setStorageId(snapshot.getId());
            ((LocalStorageReplica)storageInfo).setSnapshotName(copyName);
        }
    }

    private void buildSnapGroupReplica(String devId, ProtectObjectReplica poRep, Map<String, SnapshotConsistentGroup> snapshotConsistentGroupMap) {
        IStorageSnapshotGroupManager snapshotGroupManager = StorageSnapshotGroupManagerProxy.getInstance().getStorageSnapshotGroupMgrByDevId(devId);
        IStorageSnapshotManager storageSnapshotManager = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devId);
        Set infos = poRep.getStorageInfos();
        if (VerifyUtil.isEmpty((Collection)infos)) {
            return;
        }
        HashSet newStorageInfos = new HashSet();
        HashSet srcCgidSet = new HashSet();
        HashSet srcResourceidSet = new HashSet();
        Joiner joiner = Joiner.on((String)"-");
        HashMap poStorageWwnMap = new HashMap();
        infos.forEach(info -> {
            srcCgidSet.add(((LocalStorageReplica)info).getConsistentGroupId());
            srcResourceidSet.add(info.getSrcStorageId());
            poStorageWwnMap.put(joiner.join((Object[])new String[]{info.getSrcStorageProviderSN(), info.getSrcStorageId()}), info.getProtectObjectStorageWwn());
        });
        srcCgidSet.stream().forEach(cgid -> {
            SnapshotConsistentGroup snapshotConsistentGroup = (SnapshotConsistentGroup)snapshotConsistentGroupMap.get(cgid);
            if (null == snapshotConsistentGroup) {
                String cgName = "CopyFrom_" + cgid + "_" + System.currentTimeMillis();
                snapshotConsistentGroup = poRep.getPgReplica().getType() == 4 || poRep.getPgReplica().getType() == 102 ? snapshotGroupManager.copyFromHyperCDP(devId, cgName, cgid) : snapshotGroupManager.copy(devId, cgName, cgid);
                snapshotConsistentGroupMap.put((String)cgid, snapshotConsistentGroup);
            }
            List newSnap = storageSnapshotManager.querySnapshots(devId, XveMOType.SNAPSHOT_CONSISTENCY_GROUP, snapshotConsistentGroup.getId());
            ExecutionService.map((Collection)newSnap, snapshot -> {
                Integer lunId = snapshot.getSrcResourceId();
                String newName = "DRdata_" + lunId + "_" + System.currentTimeMillis();
                storageSnapshotManager.renameSnapshot(snapshot.getDevSn(), snapshot, newName);
                return null;
            });
            newSnap.stream().filter(snapshot -> srcResourceidSet.contains(String.valueOf(snapshot.getSrcResourceId()))).forEach(snapshot -> {
                LocalStorageReplica localStorageReplica = new LocalStorageReplica();
                localStorageReplica.setId(UUIDGenerator.getUUID());
                localStorageReplica.setSnapshotName(snapshot.getSnapshotName());
                localStorageReplica.setSrcStorageId(String.valueOf(snapshot.getSrcResourceId()));
                localStorageReplica.setSrcStorageProviderSN(devId);
                localStorageReplica.setStorageId(snapshot.getSnapshotId());
                localStorageReplica.setStorageProviderSN(devId);
                localStorageReplica.setPoReplica(poRep);
                localStorageReplica.setProtectObjectStorageWwn((String)poStorageWwnMap.get(joiner.join((Object[])new String[]{devId, String.valueOf(snapshot.getSrcResourceId())})));
                localStorageReplica.setConsistentGroupId(((SnapshotConsistentGroup)snapshotConsistentGroupMap.get(cgid)).getId());
                newStorageInfos.add(localStorageReplica);
            });
        });
        poRep.setStorageInfos(newStorageInfos);
    }

    public boolean validReplica(ProtectGroupReplica replica, boolean needHandleException) {
        return CheckReplicaTools.checkSnapshotCorrect((ProtectGroupReplica)replica, (boolean)needHandleException);
    }

    @Override
    protected void deleteReplica(ProtectGroupReplica toDelete, boolean isNeedSendAlarm) {
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            this.deleteSingleSnapshotReplicaForVasa(toDelete);
        } else if (toDelete.isSanSnapshotConsitentGroupReplica()) {
            this.deleteSnapGroupReplicaOnStorage(toDelete);
        } else {
            this.deleteSingleSnapshotReplica(toDelete, isNeedSendAlarm);
        }
    }

    protected List<Snapshot> querySnapshot(LocalStorageReplica localStorageReplica) {
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(localStorageReplica.getSrcStorageProviderSN());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        Snapshot snapshot = new Snapshot();
        snapshot.setId(localStorageReplica.getStorageId());
        return proxy.getSnapshot(localStorageReplica.getSrcStorageProviderSN(), snapshot);
    }

    protected OperationResult deleteSnapshot(LocalStorageReplica localStorageReplica, Snapshot snapshot) {
        String deviceSN = localStorageReplica.getSrcStorageProviderSN();
        String snapshotId = snapshot.getId();
        logger.info((Object)"Delete snapshot{%s} on the storage device{%s}.", new Object[]{snapshotId, deviceSN});
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(deviceSN);
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        return proxy.deleteSnapshot(localStorageReplica.getSrcStorageProviderSN(), snapshot);
    }

    private void deleteSnapGroupReplicaOnStorage(ProtectGroupReplica replica) {
        if (replica.getType() != 3 || !replica.isSanSnapshotConsitentGroupReplica()) {
            logger.error((Object)("unsupported operate for this replica " + replica));
            throw new LegoCheckedException(0x300001L);
        }
        StorageSnapshotGroupManagerProxy proxy = StorageSnapshotGroupManagerProxy.getInstance();
        String devId = replica.getRecoveryArray();
        IStorageSnapshotGroupManager manager = proxy.getStorageSnapshotGroupMgrByDevId(devId);
        replica.getReplicas().stream().filter(poRep -> !VerifyUtil.isEmpty((Object)poRep)).forEach(poRep -> {
            Set infos = poRep.getStorageInfos();
            HashMap snapGroupByCGId = new HashMap();
            infos.forEach(info -> {
                String snapCGId = ((LocalStorageReplica)info).getConsistentGroupId();
                HashSet<RelicaStorageInfo> snaps = (HashSet<RelicaStorageInfo>)snapGroupByCGId.get(snapCGId);
                if (VerifyUtil.isEmpty((Collection)snaps)) {
                    snaps = new HashSet<RelicaStorageInfo>();
                }
                snaps.add((RelicaStorageInfo)info);
                snapGroupByCGId.put(snapCGId, snaps);
            });
            snapGroupByCGId.entrySet().forEach(en -> {
                String id = (String)en.getKey();
                try {
                    SnapshotConsistentGroup snapshotConsistentGroup = manager.query(devId, id);
                    if (null != snapshotConsistentGroup) {
                        manager.delete(devId, id);
                    }
                }
                catch (LegoCheckedException e) {
                    if (Long.valueOf("1073748837").equals(e.getErrorCode())) {
                        logger.error((Object)"replica is not exists.", (Throwable)e);
                    }
                    logger.error((Object)"delete replica on storage failed", (Throwable)e);
                    throw e;
                }
            });
        });
    }

    private void deleteSingleSnapshotReplica(ProtectGroupReplica replica, boolean isNeedSendAlarm) {
        replica.getReplicas().stream().filter(item -> !VerifyUtil.isEmpty((Object)item)).forEach(item -> {
            Set storageReplicaList = item.getStorageInfos();
            storageReplicaList.stream().filter(si -> !VerifyUtil.isEmpty((Object)si)).forEach(si -> {
                if (si instanceof LocalStorageReplica) {
                    this.deleteSnapshot((LocalStorageReplica)si, isNeedSendAlarm);
                }
            });
        });
    }

    private void deleteSingleSnapshotReplicaForVasa(ProtectGroupReplica replica) {
        ArrayList replicas = new ArrayList();
        replica.getReplicas().stream().filter(item -> !VerifyUtil.isEmpty((Object)item)).forEach(item -> {
            Set storageReplicaList = item.getStorageInfos();
            storageReplicaList.stream().filter(si -> !VerifyUtil.isEmpty((Object)si)).forEach(si -> {
                if (si instanceof LocalStorageReplica) {
                    replicas.add((LocalStorageReplica)si);
                }
            });
        });
        List validReplicas = replicas.stream().filter(this::isValidSnapshot).collect(Collectors.toList());
        logger.info((Object)"delete Single SnapshotReplica For Vasa replicas size:%s, validreplicas size: %s", new Object[]{String.valueOf(replicas), String.valueOf(validReplicas)});
        if (!VerifyUtil.isEmpty(replicas) && replicas.size() != validReplicas.size()) {
            return;
        }
        String deviceSn = ((LocalStorageReplica)validReplicas.get(0)).getSrcStorageProviderSN();
        List snapshotList = validReplicas.stream().map(this::getSnapshot).collect(Collectors.toList());
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(deviceSn);
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        if (VerifyUtil.isEmpty((String)deviceSn) || VerifyUtil.isEmpty(snapshotList)) {
            logger.error((Object)"delete Single SnapshotReplica For Vasa  error param");
            return;
        }
        proxy.deleteSnapshot(deviceSn, snapshotList);
    }

    private ArraySnapshot getSnapshot(LocalStorageReplica replica) {
        ArraySnapshot as = new ArraySnapshot();
        as.setId(replica.getStorageId());
        as.setSnapshotName(replica.getSnapshotName());
        return as;
    }

    private boolean isValidSnapshot(LocalStorageReplica localStorageReplica) {
        String snapshotName = localStorageReplica.getSnapshotName();
        if ("NONE".equals(localStorageReplica.getStorageId())) {
            logger.info((Object)("deleteSnapshotOnStorage success: " + snapshotName), 90160758784001L);
            return false;
        }
        logger.debug((Object)"delete snapshot. devSn:[%s], snapshotId:[%s]", new Object[]{localStorageReplica.getSrcStorageProviderSN(), localStorageReplica.getStorageId()});
        ArraySnapshot as = new ArraySnapshot();
        as.setId(localStorageReplica.getStorageId());
        as.setSnapshotName(snapshotName);
        List<Snapshot> snapshotList = this.querySnapshot(localStorageReplica);
        if (VerifyUtil.isEmpty(snapshotList)) {
            logger.warn((Object)("can not query snapshot. the snapshotList is empty!" + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + as.getSnapshotName() + ",Id:" + as.getSnapshotId()));
            return false;
        }
        Snapshot snapshotFromDevice = snapshotList.get(0);
        if (!(VerifyUtil.isEmpty((String)snapshotName) || VerifyUtil.isEmpty((String)snapshotFromDevice.getSnapshotName()) || snapshotName.equals(snapshotFromDevice.getSnapshotName()))) {
            logger.warn((Object)("the snapshot name is not equals with the snapshot name from device." + localStorageReplica.getSrcStorageProviderSN() + ",snapshot name:" + as.getSnapshotName() + ",Id:" + as.getSnapshotId() + ", snapshot name from device:" + snapshotFromDevice.getSnapshotName()));
            return false;
        }
        return true;
    }

    private void deleteSnapshot(LocalStorageReplica localStorageReplica, boolean isNeedSendAlarm) {
        ArraySnapshot as = new ArraySnapshot();
        as.setId(localStorageReplica.getStorageId());
        as.setSnapshotName(localStorageReplica.getSnapshotName());
        try {
            boolean isValidSnapshot = this.isValidSnapshot(localStorageReplica);
            if (!isValidSnapshot) {
                logger.error((Object)"delete snapshot error. devSn:[%s], snapshotId:[%s]", new Object[]{localStorageReplica.getSrcStorageProviderSN(), localStorageReplica.getStorageId()});
                return;
            }
            OperationResult or = this.deleteSnapshot(localStorageReplica, (Snapshot)as);
            if (or.isSuccess()) {
                return;
            }
            this.dealDeleteReplicaException(localStorageReplica, (Exception)((Object)new LegoCheckedException(Long.parseLong(or.getErrorCode()))), isNeedSendAlarm);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("deleteSnapshotOnStorage error: " + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + as.getSnapshotName() + ",Id:" + as.getSnapshotId() + "," + ExceptionUtil.getErrorMessage((Throwable)e) + ", errorcode:" + e.getErrorCode()));
            if (e.getErrorCode() == 1077937880L || e.getErrorCode() == 50337543L) {
                return;
            }
            this.dealDeleteReplicaException(localStorageReplica, (Exception)((Object)e), isNeedSendAlarm);
        }
        catch (Exception e) {
            logger.error((Object)("deleteSnapshotOnStorage error: " + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + as.getSnapshotName() + ",Id:" + as.getSnapshotId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.dealDeleteReplicaException(localStorageReplica, e, isNeedSendAlarm);
        }
    }

    private void dealDeleteReplicaException(LocalStorageReplica localStorageReplica, Exception e, boolean isNeedSendAlarm) {
        logger.error((Object)"Delete replica error.SnapID: %s, error msg", new Object[]{localStorageReplica.getStorageId(), ExceptionUtil.getErrorMessage((Throwable)e)});
        if (isNeedSendAlarm) {
            String protectGroupName = Optional.of(localStorageReplica).map(RelicaStorageInfo::getPoReplica).map(ProtectObjectReplica::getPgReplica).map(ProtectGroupReplica::getPg).map(DRMObject::getName).orElse("");
            String snapshotName = localStorageReplica.getSnapshotName();
            String id = localStorageReplica.getStorageId();
            String ipAddress = this.getIpAddress(localStorageReplica.getStorageProviderSN());
            String[] params = new String[]{snapshotName, id, ipAddress, protectGroupName};
            AlarmReporter.sendAlarm((String)"0x3230044", null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])params);
        } else {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Delete Snapshot error.", (long)1073948679L, null, (Log)logger);
        }
    }

    public void deleteRelicaStorageInfo(RelicaStorageInfo relicaStorageInfo, boolean isNeedSendAlarm) {
        if (relicaStorageInfo instanceof LocalStorageReplica) {
            LocalStorageReplica localStorageReplica = (LocalStorageReplica)relicaStorageInfo;
            this.deleteSnapshot(localStorageReplica, isNeedSendAlarm);
        }
    }

    public int getFactoryType() {
        return 3;
    }
}

