/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.realtime;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.impl.AbstractReplicaRealTimeBuilder;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySnapshotBuilder;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class ArraySnapShotRealTimeBuilder
extends AbstractReplicaRealTimeBuilder {
    private static final Log logger = LogFactory.getInstance(ArraySnapShotRealTimeBuilder.class);

    public ProtectGroupReplica buildReplica(ProtectGroup protectGroup, int protectLocation) {
        logger.info((Object)("begin build snap shot real time replica, pgName:" + protectGroup.getName() + " location " + protectLocation));
        IProtectObjectProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        String srcDevSN = this.getSrcDevSN(protectGroup);
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName("SNAPSHOT-" + protectGroup.getName() + "-" + Calendar.getInstance().getTimeInMillis());
        protectGroupReplica.setType(this.getReplicaType(protectGroup, protectLocation));
        protectGroupReplica.setIndex(1);
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setProtectLocation(protectLocation);
        protectGroupReplica.setRecoverySite(this.getSiteByArraySn(srcDevSN));
        protectGroupReplica.setProductArray(srcDevSN);
        protectGroupReplica.setRecoveryArray(srcDevSN);
        HashMap<String, LocalStorageReplica> context = new HashMap<String, LocalStorageReplica>();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica protectObjectReplica = new ProtectObjectReplica();
            protectObjectReplica.setId(UUIDGenerator.getUUID());
            protectObjectReplica.setProtectObject(protectObject);
            protectObjectReplica.setPoId(protectObject.getUuid());
            protectObjectReplica.setPgReplica(protectGroupReplica);
            this.setAntiBlackmailResourceId(protectObjectReplica, protectObject);
            this.generateProtectObjectStorageInfo(protectObject, protectObjectReplica, context);
            provider.backUpPoMetadata(protectObjectReplica);
            protectGroupReplica.getReplicas().add(protectObjectReplica);
        }
        protectGroupReplica.getProps().put("isNeedSecureSnapshot", String.valueOf(protectGroup.isNeedSecureSnapshot()));
        return protectGroupReplica;
    }

    protected void generateProtectObjectStorageInfo(ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, Map<String, LocalStorageReplica> context) {
        for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObject.getUsedStorageResourceSet()) {
            if (!context.containsKey(protectObjectStorageInfo.getResourceId())) {
                String snapshotName = PolicyTemplateTools.getInstance().generateSnapshotName(protectObjectStorageInfo.getResourceId());
                String snapshotId = "NONE";
                LocalStorageReplica localStorageReplica = this.generateLocalStorageReplica(protectObjectReplica, protectObjectStorageInfo, snapshotId, snapshotName);
                context.put(protectObjectStorageInfo.getResourceId(), localStorageReplica);
                continue;
            }
            LocalStorageReplica exsistLocalStorageReplica = context.get(protectObjectStorageInfo.getResourceId());
            this.cloneLocalStorageReplicaSameSource(protectObjectReplica, exsistLocalStorageReplica);
        }
    }

    public PolicyTemplateType.POLICY_TEMPLATE_E getType() {
        return PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_SNAPSHOT;
    }

    public void callBackReplica(ProtectGroupReplica replica) {
        new ArraySnapshotBuilder().deleteSnapshotsOnPgr(replica);
    }

    protected LocalStorageReplica generateLocalStorageReplica(ProtectObjectReplica protectObjectReplica, ProtectObjectStorageInfo protectObjectStorageInfo, String snapshotId, String snapshotNm) {
        logger.debug((Object)("snapshotId:" + snapshotId + ", snapshotNm:" + snapshotNm));
        LocalStorageReplica localStorageReplica = new LocalStorageReplica();
        localStorageReplica.setId(UUIDGenerator.getUUID());
        localStorageReplica.setSnapshotName(snapshotNm);
        localStorageReplica.setSrcStorageId(protectObjectStorageInfo.getResourceId());
        localStorageReplica.setSrcStorageProviderSN(protectObjectStorageInfo.getResourceProviderSN());
        localStorageReplica.setStorageId(snapshotId);
        localStorageReplica.setStorageProviderSN(protectObjectStorageInfo.getResourceProviderSN());
        localStorageReplica.setPoReplica(protectObjectReplica);
        localStorageReplica.setProtectObjectStorageWwn(protectObjectStorageInfo.getLunWWN());
        protectObjectReplica.getStorageInfos().add(localStorageReplica);
        return localStorageReplica;
    }

    protected void cloneLocalStorageReplicaSameSource(ProtectObjectReplica protectObjectReplica, LocalStorageReplica exsistLocalStorageReplica) {
        LocalStorageReplica newLocalStorageReplica = new LocalStorageReplica();
        newLocalStorageReplica.setId(UUIDGenerator.getUUID());
        newLocalStorageReplica.setSnapshotName(exsistLocalStorageReplica.getSnapshotName());
        newLocalStorageReplica.setSrcStorageId(exsistLocalStorageReplica.getSrcStorageId());
        newLocalStorageReplica.setSrcStorageProviderSN(exsistLocalStorageReplica.getSrcStorageProviderSN());
        newLocalStorageReplica.setStorageId(exsistLocalStorageReplica.getStorageId());
        newLocalStorageReplica.setStorageProviderSN(exsistLocalStorageReplica.getStorageProviderSN());
        newLocalStorageReplica.setProtectObjectStorageWwn(exsistLocalStorageReplica.getProtectObjectStorageWwn());
        newLocalStorageReplica.setPoReplica(protectObjectReplica);
        protectObjectReplica.getStorageInfos().add(newLocalStorageReplica);
    }

    private void setAntiBlackmailResourceId(ProtectObjectReplica protectObjectReplica, ProtectObject protectObject) {
        if (protectObject.hasProperty("antiBlackmailResourceUuid")) {
            protectObjectReplica.setPlaceholderProtectObjectId(protectObject.getProperty("antiBlackmailResourceUuid"));
        }
    }
}

