/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.realtime;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.storage.protection.replica.builder.NasSnapshotBuilder;
import com.huawei.ism.drm.storage.protection.replica.realtime.ArraySnapShotRealTimeBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NasSnapShotRealTimeBuilder
extends ArraySnapShotRealTimeBuilder {
    protected static final String UNDERLINE = "_";
    private static Log logger = LogFactory.getInstance(NasSnapShotRealTimeBuilder.class);

    @Override
    protected void generateProtectObjectStorageInfo(ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, Map<String, LocalStorageReplica> context) {
        for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObject.getUsedStorageResourceSet()) {
            IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            ArrayList<String> resIds = new ArrayList<String>();
            resIds.add(protectObjectStorageInfo.getResourceId());
            List nasFiles = srService.getStorageResources(protectObjectStorageInfo.getResourceProviderSN(), resIds, NasFileSystem.class);
            if (VerifyUtil.isEmpty((Collection)nasFiles)) {
                logger.error((Object)("nasFiles is empty!resIds:" + protectObjectStorageInfo.getResourceId() + ", ProviderSN:" + protectObjectStorageInfo.getResourceProviderSN()));
                throw new LegoCheckedException(-1L);
            }
            String nasId = ((NasFileSystem)nasFiles.get(0)).getResourceId();
            if (!context.containsKey(nasId)) {
                String snapshotName = this.generateSnapshotName(protectObjectReplica.getPgReplica().getId(), protectObject.getName(), nasId);
                String snapshotId = "NONE";
                LocalStorageReplica localStorageReplica = this.generateLocalStorageReplica(protectObjectReplica, protectObjectStorageInfo, snapshotId, snapshotName);
                context.put(nasId, localStorageReplica);
                continue;
            }
            LocalStorageReplica exsistLocalStorageReplica = context.get(nasId);
            this.cloneLocalStorageReplicaSameSource(protectObjectReplica, exsistLocalStorageReplica);
        }
    }

    protected int getReplicationType() {
        logger.debug((Object)"getReplicationType: DrmConstant.PROTECT_TYPE_NAS_SNAPSHOT");
        return 8;
    }

    public int getReplicaType(ProtectGroup protectGroup, int protectLocation) {
        return this.getReplicationType();
    }

    @Override
    public PolicyTemplateType.POLICY_TEMPLATE_E getType() {
        logger.debug((Object)"type:PolicyTemplateType.NAS_SNAPSHOT");
        return PolicyTemplateType.POLICY_TEMPLATE_E.NAS_SNAPSHOT;
    }

    @Override
    public void callBackReplica(ProtectGroupReplica replica) {
        new NasSnapshotBuilder().deleteSnapshotsOnPgr(replica);
    }

    protected String generateSnapshotName(String replicaId, String fileSystemName, String nasId) {
        String tmpName = "RD_" + nasId + UNDERLINE + System.currentTimeMillis();
        return tmpName.length() > 31 ? tmpName.substring(0, 31) : tmpName;
    }
}

