/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.AbstractHyperMetroFilter;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayAsynReplicationHyperMetroFilter
extends AbstractHyperMetroFilter {
    private static final String HYPER_METRO_OTHER_RESOURCES = "HYPER_METRO_OTHER_RESOURCES";
    private static final int STANDBY_ENUM = 110;
    private Log logger = LogFactory.getInstance(ArrayAsynReplicationHyperMetroFilter.class);
    private ArraySyncReplicationFilter replicationFilter;

    protected ArraySyncReplicationFilter getReplicationFilter() {
        return this.replicationFilter;
    }

    public void setReplicationFilter(ArraySyncReplicationFilter replicationFilter) {
        this.replicationFilter = replicationFilter;
    }

    public boolean isMatch(List<ProtectObject> protectObjects) {
        return this.isMatch(protectObjects, new PolicyTemplate());
    }

    /*
     * Exception decompiling
     */
    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void cascadeFilterOperation(PolicyTemplateContext context) {
    }

    private void check(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            this.logger.warn((Object)"the parameter protectObjects is empty!");
            throw new LegoCheckedException(1073948191L);
        }
    }

    private PolicyTemplateContext init(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        PolicyTemplateContext context = new PolicyTemplateContext();
        context.addObject("PO_LIST", protectObjects);
        context.addObject("POLICY_TEMPLATE_KEY", policyTemplate);
        return context;
    }

    private void matchHyperMetroPolicy(PolicyTemplateContext context, Set<String> allWwnSet) {
        long startTime = System.currentTimeMillis();
        if (this.isNas(context)) {
            this.checkAsyncHyperMetro(context, allWwnSet);
        } else {
            this.isMatchDoubleActivePolicy(context, allWwnSet);
        }
        this.logger.debug((Object)("End to match double active policy. cost time:" + (System.currentTimeMillis() - startTime)));
    }

    private void checkSite(PolicyTemplateContext context) {
        Object localObj = context.getObject("LOCAL_HYPER_METRA_SITE");
        Set hyperMetroSiteSet = (Set)context.getObject("DEVICE_SITE_SET");
        if (localObj == null) {
            this.logger.error((Object)"localSite or remoteSite is null!");
            throw new LegoCheckedException(1073948191L);
        }
        Site locaSite = (Site)localObj;
        if (hyperMetroSiteSet.contains(locaSite.getSiteId())) {
            this.logger.error((Object)("the number of the sites is not three! siteSet:" + this.getSetStr(hyperMetroSiteSet)));
            throw new LegoCheckedException(1073948211L);
        }
    }

    private Set<String> getAllWwn(PolicyTemplateContext context) {
        List<ReplicationPair> pairs;
        List<ProtectObject> protectObjectList = this.getProtectObjectList(context);
        HashSet<String> lunWwnSet = new HashSet<String>();
        String resourceProviderSN = null;
        ArrayList<String> lunIdList = new ArrayList<String>();
        ArrayList<Lun> lunList = new ArrayList<Lun>();
        for (ProtectObject po : protectObjectList) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
                this.logger.error((Object)"usedStorageResourceSet is empty!");
                throw new LegoCheckedException(1073948191L);
            }
            for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
                resourceProviderSN = poStorageInfo.getResourceProviderSN();
                String resourceId = poStorageInfo.getResourceId();
                lunIdList.add(resourceId);
                Lun lun = new Lun();
                lun.setName(poStorageInfo.getLunWWN());
                lun.setLunId(resourceId);
                lun.setDevSn(resourceProviderSN);
                lun.setWwn(poStorageInfo.getLunWWN());
                lunList.add(lun);
            }
        }
        String errorMsg = " deviceSn:" + resourceProviderSN + ", resourceIds:" + this.getListStr(lunIdList);
        int lunSize = lunList.size();
        Lun[] lunArray = new Lun[lunSize];
        lunList.toArray(lunArray);
        long startTime = System.currentTimeMillis();
        if (this.isNas(context)) {
            ArrayList<NasFileSystem> nasFileSystemList = new ArrayList<NasFileSystem>();
            for (Lun lun : lunList) {
                NasFileSystem nas = new NasFileSystem();
                nas.setName(lun.getName());
                nas.setResourceId(lun.getResourceId());
                nas.setDevSn(lun.getDevSn());
                nas.setResourceIndentifier(lun.getWwn());
                nasFileSystemList.add(nas);
            }
            pairs = this.getReplicationPairsByNas(nasFileSystemList);
        } else {
            pairs = this.getReplicationPairsByLun(lunArray);
        }
        this.logger.debug((Object)("End to get pairs by lun. cost time:" + (System.currentTimeMillis() - startTime)));
        this.checkPair(errorMsg, pairs);
        context.addObject("DR_RING_ALL_RELATED_PAIR_LIST", pairs);
        this.appendTargetLunWwn(lunWwnSet, errorMsg, pairs, context);
        context.addObject("LOCAL_HYPER_METRA_SITE", this.getSiteFromSn(resourceProviderSN));
        return lunWwnSet;
    }

    protected List<ReplicationPair> getReplicationPairsByLun(Lun ... lunArray) {
        return this.getReplicationFilter().getPairsByLun(lunArray);
    }

    protected List<ReplicationPair> getReplicationPairsByNas(List<NasFileSystem> nasFileSystems) {
        return this.getReplicationFilter().getPairByNasList(nasFileSystems);
    }

    protected void appendTargetLunWwn(Set<String> lunWwnSet, String errorMsg, List<ReplicationPair> pairs, PolicyTemplateContext context) {
        String tgtDevSN = null;
        HashSet<String> tgtLunIdSet = new HashSet<String>();
        for (ReplicationPair replicationPair : pairs) {
            if (VerifyUtil.isEmpty((Collection)replicationPair.getRepTgtLuns())) {
                this.logger.error((Object)("there is no tgtLun. replicationPairId:" + replicationPair.getId() + "," + errorMsg));
                throw new LegoCheckedException(1073948191L);
            }
            for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
                if (replicationTargetLun.getPairStatus() == 110) continue;
                if (tgtDevSN != null && !tgtDevSN.equals(replicationTargetLun.getTgtDevSN())) {
                    this.logger.error((Object)("Device SN is not same as last, last:" + tgtDevSN + ". replicationPairId:" + replicationPair.getId() + ", TargetLUN devID:" + replicationTargetLun.getTgtDevSN() + ", TargetLUN lunID" + replicationTargetLun.getTgtLunId()));
                    throw new LegoCheckedException(1073948191L);
                }
                tgtDevSN = replicationTargetLun.getTgtDevSN();
                String tgtLunId = replicationTargetLun.getTgtLunId();
                tgtLunIdSet.add(tgtLunId);
            }
        }
        this.fillStorageResourceWwnSet(lunWwnSet, context, tgtDevSN, tgtLunIdSet);
        if (context.getObject("REMOTE_HYPER_METRA_SITE") == null) {
            context.addObject("REMOTE_HYPER_METRA_SITE", this.getSiteFromSn(tgtDevSN));
        }
        if (context.getObject("REMOTE_DEVICESN") == null) {
            context.addObject("REMOTE_DEVICESN", tgtDevSN);
        }
    }

    protected void fillStorageResourceWwnSet(Set<String> lunWwnSet, PolicyTemplateContext context, String tgtDevSN, Set<String> tgtLunIdSet) {
        long startTime = System.currentTimeMillis();
        if (this.isNas(context)) {
            this.dealTgtNas(context, lunWwnSet, tgtLunIdSet, tgtDevSN);
        } else {
            List<Lun> targetLunList = this.getTargetLun(tgtDevSN, new ArrayList<String>(tgtLunIdSet));
            this.logger.debug((Object)"End to get target Lun. cost time: %s", new Object[]{String.valueOf(System.currentTimeMillis() - startTime)});
            if (VerifyUtil.isEmpty(targetLunList)) {
                String setStr = this.getSetStr(tgtLunIdSet);
                this.logger.error((Object)"targetLunList is empty!tgtLunIdSet: %s", new Object[]{setStr});
                throw new LegoCheckedException(1073948685L, new String[]{setStr, tgtDevSN});
            }
            if (targetLunList.size() != tgtLunIdSet.size()) {
                this.dealNotExistedLunIds(targetLunList, tgtLunIdSet);
                this.logger.warn((Object)"targetLun is null!");
                throw new LegoCheckedException(1073948685L, new String[]{this.getSetStr(tgtLunIdSet), tgtDevSN});
            }
            for (Lun targetLun : targetLunList) {
                lunWwnSet.add(targetLun.getWwn());
            }
        }
    }

    private void dealNotExistedLunIds(List<Lun> targetLunList, Set<String> tgtLunIdSet) {
        ArrayList<String> existedLunIdList = new ArrayList<String>();
        for (Lun lun : targetLunList) {
            existedLunIdList.add(lun.getLunId());
        }
        tgtLunIdSet.removeAll(existedLunIdList);
    }

    private void dealNotExistedNasIds(List<NasFileSystem> targetLunList, Set<String> tgtLunIdSet) {
        ArrayList<String> existedLunIdList = new ArrayList<String>();
        for (NasFileSystem nas : targetLunList) {
            existedLunIdList.add(nas.getResourceId());
        }
        tgtLunIdSet.removeAll(existedLunIdList);
    }

    private void checkPair(String errorMsg, List<ReplicationPair> pairs) {
        if (VerifyUtil.isEmpty(pairs)) {
            this.logger.info((Object)("lun's ReplicationPair is empty.msg:" + errorMsg));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private List<Lun> getTargetLun(String deviceSn, List<String> lunIdList) {
        Site site = this.getReplicationFilter().getSiteByDeviceSN(deviceSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            this.logger.error((Object)"Do getPairsByLun error, site is null, deviceSN:%s", new Object[]{deviceSn});
            return null;
        }
        return this.getLunFromLocal(deviceSn, lunIdList);
    }

    private String getListStr(List<String> strList) {
        if (VerifyUtil.isEmpty(strList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : strList) {
            sb.append(str).append(";");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    protected void matchAsyncReplicationPolicy(List<ProtectObject> protectObjects) {
        long startTime = System.currentTimeMillis();
        this.getReplicationFilter().isMatch(protectObjects);
        this.logger.debug((Object)"end to match async replication policy..cost time: %s", new Object[]{String.valueOf(System.currentTimeMillis() - startTime)});
    }

    private List<Lun> getLunFromLocal(String devSn, List<String> lunIdList) {
        List lunList = null;
        try {
            lunList = this.getStorageService().queryLunByDevSnAndLunIds(devSn, lunIdList);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query lun error. deviceSN:" + devSn + ", resourceIds:" + lunIdList), (long)1073948705L, (String[])new String[0], (Log)this.logger);
        }
        return lunList;
    }

    @Override
    protected Set<String> getHyperMetroDeviceSN(PolicyTemplateContext context, List<Lun> resources) {
        HashSet<String> devSnSet = new HashSet<String>();
        String remoteDeviceSN = (String)context.getObject("REMOTE_DEVICESN");
        HashSet<Lun> targetLunSet = new HashSet<Lun>();
        for (Lun res : resources) {
            String devSn = res.getDevSn();
            if (VerifyUtil.isEmpty((String)devSn)) {
                this.logger.error((Object)("devSn is empty! storageResource:" + res.getName() + ", id:" + res.getResourceId() + ",devSnSet:" + this.getSetStr(devSnSet)));
                throw new LegoCheckedException(1073948191L);
            }
            devSnSet.add(devSn);
            if (null == remoteDeviceSN) {
                this.logger.error((Object)"remoteDeviceSN is null!");
                throw new LegoCheckedException(1073948191L);
            }
            if (remoteDeviceSN.equals(devSn)) continue;
            targetLunSet.add(res);
        }
        context.addObject(HYPER_METRO_OTHER_RESOURCES, targetLunSet);
        return devSnSet;
    }

    public int getType() {
        return 20;
    }

    private void dealTgtNas(PolicyTemplateContext context, Set<String> lunWwnSet, Set<String> tgtLunIdSet, String tgtDevSN) {
        List nasList = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(tgtDevSN, new ArrayList<String>(tgtLunIdSet), NasFileSystem.class);
        if (VerifyUtil.isEmpty((Collection)nasList)) {
            this.logger.error((Object)("targetLunList is empty!tgtLunIdSet:" + this.getSetStr(tgtLunIdSet)));
            throw new LegoCheckedException(1073948685L, new String[]{this.getSetStr(tgtLunIdSet), tgtDevSN});
        }
        if (nasList.size() != tgtLunIdSet.size()) {
            this.dealNotExistedNasIds(nasList, tgtLunIdSet);
            this.logger.warn((Object)"targetLun is null!");
            throw new LegoCheckedException(1073948685L, new String[]{this.getSetStr(tgtLunIdSet), tgtDevSN});
        }
        for (NasFileSystem nas : nasList) {
            lunWwnSet.add(nas.getResourceId());
        }
        if (context.getObject("HYPERMETRO_VSTOREID") == null) {
            context.addObject("HYPERMETRO_VSTOREID", ((NasFileSystem)nasList.iterator().next()).getVstoreId());
        }
    }

    public Map<String, Object> getFilterContext() {
        return this.replicationFilter.getFilterContext();
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        return this.getReplicationProtectLocationPaths(protectObjects);
    }
}

