/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayAsyncReplicationFilter
extends ArraySyncReplicationFilter {
    private static final Log logger = LogFactory.getInstance(ArraySyncReplicationFilter.class);
    private ThreadLocal<Set<String>> tgtDevs = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public Set<String> getTgtDevs() {
        return this.tgtDevs.get();
    }

    @Override
    public int getReplicationType() {
        return 2;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        this.getTgtDevs().clear();
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " Match"));
        Boolean flag = false;
        try {
            String arraySn = this.checkSameSrcDevice(protectObjects);
            Site site = this.getSiteFromSn(arraySn);
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.warn((Object)("can't get site by deviceSN:" + arraySn), 90160758786989L);
                throw new LegoCheckedException(1073948449L);
            }
            this.getFilterContext().clear();
            Map<Integer, List<ProtectObject>> classifiedPoList = this.classifyPoList(protectObjects);
            this.checkSupport(classifiedPoList);
            for (List<ProtectObject> poList : classifiedPoList.values()) {
                flag = this.isMatchByLocation(this.getReplicationType(), DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), poList, this.getType());
                if (flag.booleanValue()) continue;
                boolean bl = flag;
                return bl;
            }
            flag = true;
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)"array async replication filter failed!", 90160758786989L);
            throw e;
        }
        finally {
            logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch " + flag), 90160758786989L);
            this.getTgtDevs().clear();
        }
        return flag;
    }

    private void checkSupport(Map<Integer, List<ProtectObject>> classifiedPoList) {
        int size = classifiedPoList.size();
        if (size == 0 || size > 2) {
            logger.error((Object)"classifiedPoList size is not legal!", 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
        for (Integer resourceType : classifiedPoList.keySet()) {
            if (resourceType.intValue() == DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue() || resourceType.intValue() == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) continue;
            logger.error((Object)"resource type is not legal!", 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private Map<Integer, List<ProtectObject>> classifyPoList(List<ProtectObject> protectObjects) {
        HashMap<Integer, List<ProtectObject>> classifiedPoList = new HashMap<Integer, List<ProtectObject>>();
        for (ProtectObject po : protectObjects) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            int resourceType = this.getResourcetype(usedStorageResourceSet);
            List poList = (List)classifiedPoList.get(resourceType);
            if (poList == null) {
                ArrayList<ProtectObject> newPoList = new ArrayList<ProtectObject>();
                newPoList.add(po);
                classifiedPoList.put(resourceType, newPoList);
                continue;
            }
            poList.add(po);
        }
        return classifiedPoList;
    }

    @Override
    protected void checkAllTargetLunBelongToSameDevice() {
        super.checkAllTargetLunBelongToSameDevice();
        Collection<List<String>> values = this.getLunTgtDevs().values();
        if (VerifyUtil.isEmpty(values)) {
            logger.error((Object)"values is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        List<String> targetDevSnList = values.iterator().next();
        if (null == targetDevSnList) {
            return;
        }
        if (VerifyUtil.isEmpty(this.getTgtDevs())) {
            for (String tgt : targetDevSnList) {
                if (this.getTgtDevs().contains(tgt)) continue;
                this.getTgtDevs().add(tgt);
            }
        } else {
            for (String tgt : targetDevSnList) {
                if (this.getTgtDevs().contains(tgt)) continue;
                this.haveSameTgt();
                throw new LegoCheckedException(1073948463L);
            }
        }
    }

    private void haveSameTgt() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String lun2DeviceSn : this.getTgtDevs()) {
            stringBuffer.append("tgt lun id :" + lun2DeviceSn + " :");
            stringBuffer.append(".####");
        }
        logger.error((Object)stringBuffer.toString(), 1073948463L);
    }
}

