/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.AbstractHyperMetroFilter;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArrayHyperMetroFilter
extends AbstractHyperMetroFilter {
    private static final String VAULT_SRC_DEV = "VAULT_SRC_DEV";
    private static final String VSTORE_PAIR = "VSTORE_PAIR";
    private Log logger = LogFactory.getInstance(ArrayHyperMetroFilter.class);

    public int getType() {
        return 15;
    }

    public boolean isMatch(List<ProtectObject> protectObjects) {
        return this.isMatch(protectObjects, new PolicyTemplateContext());
    }

    public boolean checkPolicyTemplate(PolicyTemplate policyTemplate) {
        return false;
    }

    protected boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        this.logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        boolean flag = false;
        if (VerifyUtil.isEmpty(protectObjects)) {
            this.logger.warn((Object)"the parameter protectObjects is empty!", 90160758786989L);
            this.logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch " + flag), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        context.addObject("PO_LIST", protectObjects);
        try {
            this.checkMultiCgMatch(protectObjects);
            this.isMatchDoubleActivePolicy(context, this.getAllResourceIds(protectObjects));
            this.checkHyperMetroPoSite(context);
            this.cascadeFilterOperation(protectObjects, context);
            flag = true;
        }
        catch (LegoCheckedException e) {
            this.logger.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " failed! Template Type:" + this.getType()), 90160758786989L);
            throw e;
        }
        finally {
            this.logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch " + flag), 90160758786989L);
        }
        return flag;
    }

    protected void checkHyperMetroPoSite(PolicyTemplateContext context) {
        Set siteIdSet = (Set)context.getObject("DEVICE_SITE_SET");
        List<ProtectObject> poList = this.getProtectObjectList(context);
        HashSet<String> poSiteIdSet = new HashSet<String>();
        HashMap<String, String> siteMap = new HashMap<String, String>();
        HashMap<String, DrResource> drResourceMap = new HashMap<String, DrResource>();
        for (ProtectObject po : poList) {
            String siteId = (String)siteMap.get(po.getProviderSN());
            if (VerifyUtil.isEmpty((String)siteId)) {
                Site poSite = this.getSiteFromSn(po.getProviderSN());
                siteId = poSite.getSiteId();
                siteMap.put(po.getProviderSN(), siteId);
            }
            poSiteIdSet.add(siteId);
            DrResource drResource = (DrResource)drResourceMap.get(po.getProviderSN());
            if (drResource == null) {
                drResource = this.getResourceService().getDrResourceBySn(po.getProviderSN());
                drResourceMap.put(po.getProviderSN(), drResource);
            }
            if (drResource == null) {
                this.logger.error((Object)("drResource is null! siteIdSet:" + this.getSetStr(siteIdSet) + ", poSiteIdSet:" + this.getSetStr(poSiteIdSet) + ", ProviderSN:" + po.getProviderSN()));
                throw new LegoCheckedException(1073948191L);
            }
            Set childResources = drResource.getChildResources();
            if (VerifyUtil.isEmpty((Collection)childResources)) continue;
            for (DrResource childRes : childResources) {
                poSiteIdSet.add(childRes.getSiteId());
            }
        }
        for (String poSiteId : poSiteIdSet) {
            if (null != siteIdSet && siteIdSet.contains(poSiteId)) continue;
            this.logger.error((Object)("The site of sites is not two! siteIdSet:" + this.getSetStr(siteIdSet) + ", poSiteIdSet:" + this.getSetStr(poSiteIdSet)), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    protected boolean checkFreshHyperMetroHealth(List<ProtectObject> protectObjects, PolicyTemplateContext context, String devSn) {
        Integer activeOrPassive;
        VstoreHyperMetroPair vstoreHyperMetroPair;
        String vstorePairId = (String)((ProtectObject)CommonUtil.getFirstElement(protectObjects)).getProtectGroup().getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        List hyperMetroPairList = router.getHyperMetroPairsByVstore(devSn, (vstoreHyperMetroPair = router.getVstoreHyperMetroPairByVstorePairId(devSn, vstorePairId)).getLocalVstoreId());
        if (VerifyUtil.isEmpty((Collection)hyperMetroPairList)) {
            this.logger.info((Object)"the hyperMetropairList is empty");
            return false;
        }
        if (this.isHyperMetroNormal(vstoreHyperMetroPair, hyperMetroPairList)) {
            this.logger.info((Object)"the isHyperMetroNormal hyper state is normal");
            return false;
        }
        String active = vstoreHyperMetroPair.getActiveOrPassive();
        if (VerifyUtil.isEmpty((String)active)) {
            HyperMetroDomain hyperMetroDomain = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getHyperMetroDomainById(vstoreHyperMetroPair.getDomainId(), false);
            active = hyperMetroDomain.getServiceStatus();
        }
        if ((activeOrPassive = NumberUtil.convertToInteger((Object)active)).equals(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue())) {
            this.logger.info((Object)("This devSn VstorePair is not activeOrPassive:" + devSn + " ,pairId:" + vstorePairId));
            return false;
        }
        context.addObject(VAULT_SRC_DEV, devSn);
        context.addObject(VSTORE_PAIR, vstoreHyperMetroPair);
        return true;
    }

    protected boolean isHyperMetroNormal(VstoreHyperMetroPair vstoreHyperMetroPair, List<HyperMetroPair> hyperMetroPairs) {
        if (!String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(vstoreHyperMetroPair.getHealthStatus())) {
            return false;
        }
        for (HyperMetroPair hyperMetroPair : hyperMetroPairs) {
            if (String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(hyperMetroPair.getHealthState())) continue;
            return false;
        }
        return true;
    }

    protected boolean freshMatch(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        try {
            context.addObject("PO_LIST", protectObjects);
            String vaultDevSn = (String)context.getObject(VAULT_SRC_DEV);
            VstoreHyperMetroPair vstoreHyperMetroPair = (VstoreHyperMetroPair)context.getObject(VSTORE_PAIR);
            this.checkFreshNasHyperPair(context, protectObjects, vaultDevSn, vstoreHyperMetroPair);
            this.checkHyperMetroPoSite(context);
            this.cascadeFilterOperation(protectObjects, context);
            return true;
        }
        catch (LegoCheckedException e) {
            this.logger.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " failed! fresh Template Type:" + this.getType()), 90160758786989L);
            throw e;
        }
    }

    private void checkFreshNasHyperPair(PolicyTemplateContext context, List<ProtectObject> protectObjects, String devSN, VstoreHyperMetroPair vstoreHyperMetroPair) {
        String vstoreId = vstoreHyperMetroPair.getLocalVstoreId();
        List<HyperMetroPair> pairList = this.getNasHyperMetroPairs(devSN, vstoreHyperMetroPair, vstoreId);
        List vstoreNasList = StorageResourceServiceRouter.getInstance().getFileSystemByVstore(devSN, vstoreId);
        HashSet<String> vstoreNasIds = new HashSet<String>();
        for (NasFileSystem nasFileSystem : vstoreNasList) {
            vstoreNasIds.add(nasFileSystem.getResourceId());
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(pairList) || pairList.size() != vstoreNasList.size()) {
            this.logger.error((Object)("pairList is null or the number of resource ids is not equals of the number of pairs!" + this.getPairListStr(pairList)), 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> allPoNasIds = this.getAllResourceIds(protectObjects);
        HashSet<String> allPoIds = new HashSet<String>();
        boolean isVaultLocal = this.checkReplicaDevSn(protectObjects, devSN);
        for (HyperMetroPair pair : pairList) {
            if (!vstoreNasIds.contains(pair.getLocalObjId())) {
                this.logger.error((Object)("The pair don't exist Nas id :" + pair.getLocalObjId()));
                throw new LegoCheckedException(1073948191L);
            }
            if (isVaultLocal || !allPoNasIds.contains(pair.getRemoteObjId())) continue;
            allPoIds.add(pair.getLocalObjId());
        }
        context.addObject("PAIR_LIST", pairList);
        this.getAllDevSn(context, isVaultLocal ? allPoNasIds : allPoIds, vstoreHyperMetroPair, vstoreNasList);
        this.checkHyperMetroSite(context);
    }

    protected boolean checkReplicaDevSn(List<ProtectObject> protectObjects, String vaultDevSn) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(protectObjects)) {
            this.logger.error((Object)"getAllPoSrcNasIds  check protectObjects  is empty:", 90160758786897L);
            throw new LegoCheckedException(1073948453L);
        }
        Set storageInfos = ((ProtectObject)CommonUtil.getFirstElement(protectObjects)).getUsedStorageResourceSet();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)storageInfos)) {
            this.logger.error((Object)"getAllPoSrcNasIds check protectObject storageInfo is empty", 90160758786897L);
            throw new LegoCheckedException(1073948453L);
        }
        String poDevSn = ((ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)storageInfos)).getResourceProviderSN();
        return vaultDevSn.equals(poDevSn);
    }
}

