/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayHyperMetroFilter;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayHyperMetroSnapShotFilter
extends ArrayHyperMetroFilter {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroSnapShotFilter.class);

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        return super.isMatch(protectObjects);
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects) || VerifyUtil.isEmpty((Collection)protectObjects.iterator().next().getUsedStorageResourceSet())) {
            logger.error((Object)"protectObjects is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<ProtectLocationPath> results = new ArrayList<ProtectLocationPath>();
        ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)protectObjects.iterator().next().getUsedStorageResourceSet().iterator().next();
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{info.getLunWWN()});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            logger.error((Object)("resources is empty or the size is not two!" + info.getLunWWN()), 90160758786897L);
            return null;
        }
        int index = 0;
        for (StorageResource res : resources) {
            ProtectLocationPath path = new ProtectLocationPath();
            Site site = this.getSiteFromSn(res.getDevSn());
            path.setProtectedSiteId(site.getSiteId());
            path.setProtectedSiteName(site.getName());
            path.setRecoverySiteId(site.getSiteId());
            path.setRecoverySiteName(site.getName());
            path.setProtectedStorageSN(res.getDevSn());
            path.setRecoveryStorageSN(res.getDevSn());
            if (0 == index) {
                path.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue());
                results.add(path);
                ++index;
                continue;
            }
            path.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue());
            results.add(path);
            break;
        }
        return results;
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public boolean checkPolicyTemplate(PolicyTemplate policyTemplate) {
        return null != policyTemplate && !VerifyUtil.isEmpty((Collection)policyTemplate.getSchedules());
    }
}

