/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ArraySanAirGapSnapshotFilter
extends ArraySyncReplicationFilter {
    private static final Log logger = LogFactory.getInstance(ArraySanAirGapSnapshotFilter.class);
    public static final String FILTER_CTX_AIR_GAP_DEV_SN = "airGapDevSn";
    public static final String FILTER_CTX_SITE_PROVIDER_CONTEXT = "SITE_PROVIDER_CONTEXT";
    public static final String KEY_PAIR_LIST = "pairList";
    public static final String FILTER_CTX_SITE_INFO_LIST = "siteInfoList";
    public static final int RESUME_MANUAL_POLICY = 2;
    public static final int MANUAL_SYNC_TYPE = 1;

    @Override
    public int getType() {
        return 44;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            logger.error((Object)"the parameter protectObjects is empty.90160758786989");
            throw new LegoCheckedException(1073948191L);
        }
        String airGapDevSn = this.getAirGapDeviceSn(protectObjects);
        this.checkResource(airGapDevSn, true);
        this.getFilterContext().put(FILTER_CTX_AIR_GAP_DEV_SN, airGapDevSn);
        Set<String> airGapSiteWwnSet = this.getSiteWwnSetByPo(protectObjects);
        this.checkAndSetAirGapSite(airGapDevSn, airGapSiteWwnSet);
        return true;
    }

    protected void checkAndSetAirGapSite(String devSn, Set<String> siteWwnSet) {
        List<Lun> curSiteLunList = this.getAirGapLunByWwn(siteWwnSet);
        if (this.checkLunVstoreId(curSiteLunList)) {
            logger.error((Object)"Lun list has different vStoreId, error!");
            throw new LegoCheckedException(1073948191L);
        }
        List lunIdList = curSiteLunList.stream().map(Lun::getLunId).collect(Collectors.toList());
        List pairs = this.getStorageService().getReplicationPairsByResourceIds(devSn, lunIdList, false, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        HashMap srcDevLunIdMap = new HashMap();
        pairs.forEach(pair -> {
            Set lunIdSet = srcDevLunIdMap.computeIfAbsent(pair.getSrcDevSN(), set -> new HashSet());
            lunIdSet.add(pair.getSrcLunId());
        });
        if (srcDevLunIdMap.keySet().size() != 1) {
            logger.error((Object)"Storage resource is illegal. devSn: %s", new Object[]{devSn, 90160758786989L});
            throw new LegoCheckedException(1073948191L);
        }
        String srcDevSn = (String)srcDevLunIdMap.keySet().stream().findFirst().get();
        this.checkPairModeAndResumePolicy(pairs, devSn);
        this.checkResource(srcDevSn, false);
        ExecutionContext context = new ExecutionContext();
        context.setAttribute(KEY_PAIR_LIST, (Object)pairs);
        this.getFilterContext().put(FILTER_CTX_SITE_PROVIDER_CONTEXT, context);
        HashSet<String> devSnSetAirGap = new HashSet<String>();
        devSnSetAirGap.add(devSn);
        Site site = this.getSiteFromSn(devSn);
        HashSet<String> siteIdSetAirGap = new HashSet<String>();
        siteIdSetAirGap.add(site.getSiteId());
        List<SiteInfo> siteInfoList = Collections.singletonList(new SiteInfo(siteIdSetAirGap, devSnSetAirGap));
        this.getFilterContext().put(FILTER_CTX_SITE_INFO_LIST, siteInfoList);
    }

    private boolean checkLunVstoreId(List<Lun> curSiteLunList) {
        String vStoreFlag = curSiteLunList.get(0).getVstoreId();
        return curSiteLunList.stream().anyMatch(lun -> !Objects.equals(vStoreFlag, lun.getVstoreId()));
    }

    private void checkPairModeAndResumePolicy(List<ReplicationPair> pairs, String devSn) {
        Optional opt = pairs.stream().findFirst();
        if (!opt.isPresent()) {
            logger.error((Object)"get pair list error!");
            throw new LegoCheckedException(1073948191L);
        }
        HashSet<String> cgIdSet = new HashSet<String>();
        ArrayList<ReplicationPair> toBeCheckedPairList = new ArrayList<ReplicationPair>();
        for (ReplicationPair pair : pairs) {
            Integer mode = pair.getReplicationMode();
            if (VerifyUtil.isEmpty((Object)mode) || mode != 2) {
                logger.error((Object)"Pair mode is not matched.");
                throw new LegoCheckedException(1073948191L);
            }
            if (!VerifyUtil.isEmpty((String)pair.getConsistentGroupId())) {
                cgIdSet.add(pair.getConsistentGroupId());
                continue;
            }
            toBeCheckedPairList.add(pair);
        }
        if (!VerifyUtil.isEmpty(cgIdSet) && !this.checkCgGroup(devSn, cgIdSet)) {
            logger.error((Object)"CgGroup resume policy has illegal, error!");
            throw new LegoCheckedException(1073948212L);
        }
        if (!VerifyUtil.isEmpty(toBeCheckedPairList) && this.checkPairSyncTypeAndResumePolicy(toBeCheckedPairList)) {
            logger.error((Object)"Pairs resume policy is not manual, error!");
            throw new LegoCheckedException(1073948212L);
        }
    }

    private boolean checkCgGroup(String devSn, Set<String> cgIdSet) {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        for (String cgId : cgIdSet) {
            ReplicationGroup replicationGroup = sraProxy.getReplicationGroup(devSn, cgId);
            if (replicationGroup.getResumePolicy() == 2 && replicationGroup.getSyncType() == 1 && replicationGroup.getReplicationMode() == 2) continue;
            return false;
        }
        return true;
    }

    protected boolean checkPairSyncTypeAndResumePolicy(List<ReplicationPair> pairs) {
        for (ReplicationPair pair : pairs) {
            if (!ArraySanAirGapSnapshotFilter.checkSinglePair(pair)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkSinglePair(ReplicationPair pair) {
        List targetLuns = pair.getRepTgtLuns();
        for (ReplicationTargetLun tgtLun : targetLuns) {
            if (tgtLun.getResumePolicy() == 2 && tgtLun.getSyncType() == 1) continue;
            return true;
        }
        return false;
    }

    protected void checkResource(String devSn, boolean isAirGapSite) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getBundleService((String)"DRM_Base", (String)IResourceService.class.getName());
        DrResource resource = resourceService.getDrResourceBySn(devSn);
        if (isAirGapSite && !resource.getIsAirGapResource().booleanValue()) {
            logger.error((Object)"Storage resource is not AirGap resource. devSn: %s", new Object[]{devSn, 90160758786989L});
            throw new LegoCheckedException(1073948191L);
        }
        if (!isAirGapSite && resource != null && resource.getIsAirGapResource().booleanValue()) {
            logger.error((Object)"Storage resource should not be AirGap resource. devSn: %s", new Object[]{devSn, 90160758786989L});
            throw new LegoCheckedException(1073948191L);
        }
    }

    private Set<String> getSiteWwnSetByPo(List<ProtectObject> protectObjects) {
        HashSet<String> wwnSet = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            Set tmpResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)tmpResourceSet)) {
                throw new LegoCheckedException(1073948453L);
            }
            this.putSiteWwnSet(tmpResourceSet, wwnSet);
        }
        return wwnSet;
    }

    private void putSiteWwnSet(Set<ProtectObjectStorageInfo> storageInfos, Set<String> siteWwnSet) {
        if (this.getResourcetype(storageInfos) != DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()) {
            logger.error((Object)"Error : not lun type.");
            throw new LegoCheckedException(1073948191L);
        }
        for (ProtectObjectStorageInfo info : storageInfos) {
            siteWwnSet.add(info.getLunWWN());
        }
    }

    protected String getAirGapDeviceSn(List<ProtectObject> protectObjectSet) {
        HashSet<String> providerSnSet = new HashSet<String>();
        for (ProtectObject po : protectObjectSet) {
            for (ProtectObjectStorageInfo storageInfo : po.getUsedStorageResourceSet()) {
                providerSnSet.add(storageInfo.getResourceProviderSN());
            }
        }
        if (providerSnSet.size() != 1) {
            logger.error((Object)"The ProtectObject's device not the same as: %s", new Object[]{StringUtil.arrayToString((Object[])providerSnSet.toArray()), 90160758786897L});
            throw new LegoCheckedException(1073948192L);
        }
        return new ArrayList(providerSnSet).stream().sorted().findFirst().orElse(null);
    }

    private List<Lun> getAirGapLunByWwn(Set<String> resourceWwnSet) {
        List storageResourceList = this.getStorageService().getStorageResourceByWwn(resourceWwnSet.toArray(new String[0]));
        ArrayList<Lun> lunList = new ArrayList<Lun>();
        for (StorageResource storageResource : storageResourceList) {
            lunList.add((Lun)storageResource);
        }
        return lunList;
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        ArrayList<ProtectLocationPath> pathList = new ArrayList<ProtectLocationPath>();
        String providerDevSn = (String)this.getFilterContext().get(FILTER_CTX_AIR_GAP_DEV_SN);
        Site site = this.getSiteFromSn(providerDevSn);
        ProtectLocationPath path = new ProtectLocationPath();
        path.setProtectedSiteId(site.getSiteId());
        path.setProtectedSiteName(site.getName());
        path.setRecoverySiteId(site.getSiteId());
        path.setRecoverySiteName(site.getName());
        path.setProtectedStorageSN(providerDevSn);
        path.setRecoveryStorageSN(providerDevSn);
        path.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        pathList.add(path);
        return pathList;
    }
}

