/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.ReplicationSpeedPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ArraySyncReplicationFilter
extends AbstractPolicyTemplateFilter {
    protected static final String DEVICE_SN = "DEVICE_SN";
    protected static final String RESOURCE_ID_SET = "RESOURCE_ID_SET";
    private static final String ERROR_PREFIX = "ERROR:";
    protected static final String PO_STORAGE_INFO_LIST = "PO_STORAGE_INFO_LIST";
    private static Log logger = LogFactory.getInstance(ArraySyncReplicationFilter.class);
    private final List<Integer> normalStatusList = Arrays.asList(ReplicationConstantDefine.PairStatus.NORMAL.getValue(), ReplicationConstantDefine.PairStatus.SYNCHRONIZING.getValue(), ReplicationConstantDefine.PairStatus.WAIT_RECOVER.getValue(), ReplicationConstantDefine.PairStatus.SPLITED.getValue(), XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue(), XveEuumDefineParent.RUNNING_STATUS_E.INITIAL_SYNCHRONIZING.getValue(), XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue(), XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue(), XveEuumDefineParent.RUNNING_STATUS_E.TO_BE_RECOVERD.getValue());
    private ThreadLocal<Map<String, List<String>>> lunTgtDevs = new ThreadLocal<Map<String, List<String>>>(){

        @Override
        protected Map<String, List<String>> initialValue() {
            return new ConcurrentHashMap<String, List<String>>();
        }
    };
    private ThreadLocal<Map<String, String>> lunTgtdevSn = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new ConcurrentHashMap<String, String>();
        }
    };

    public Map<String, String> getLunTgtdevSn() {
        return this.lunTgtdevSn.get();
    }

    public Map<String, List<String>> getLunTgtDevs() {
        return this.lunTgtDevs.get();
    }

    public boolean isMatch(List<ProtectObject> protectObjects) {
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)("can't get site by deviceSN:" + arraySn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        boolean result = this.isMatchByLocation(this.getReplicationType(), DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), protectObjects, this.getType());
        logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch " + result), 90160758786989L);
        return result;
    }

    protected Boolean isMatchByLocation(int type, int locationType, List<ProtectObject> protectObjects, int templateType) {
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        ExecutionContext context = this.init(locationType, protectObjects);
        List allStorageInfo = (List)context.getAttribute(PO_STORAGE_INFO_LIST);
        try {
            if (this.getResourcetype(allStorageInfo) == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
                this.nasFilterRule(type, locationType, templateType, allStorageInfo);
            } else {
                this.arrayFilterRule(type, locationType, protectObjects, templateType, context);
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)"array replication filter failed!", 90160758786989L);
            throw e;
        }
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        return true;
    }

    protected ExecutionContext init(int locationType, List<ProtectObject> protectObjects) {
        ExecutionContext context = new ExecutionContext();
        ArrayList<ProtectObjectStorageInfo> poStorageInfoList = new ArrayList<ProtectObjectStorageInfo>();
        HashSet<String> resourceIdSet = new HashSet<String>();
        String devSn = null;
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
                if (poStorageInfoList.contains(poStorageInfo)) continue;
                poStorageInfoList.add(poStorageInfo);
                devSn = this.addResourceId(resourceIdSet, poStorageInfo, locationType);
            }
        }
        context.setAttribute(PO_STORAGE_INFO_LIST, poStorageInfoList);
        context.setAttribute(DEVICE_SN, devSn);
        context.setAttribute(RESOURCE_ID_SET, resourceIdSet);
        return context;
    }

    protected String addResourceId(Set<String> resourceIdSet, ProtectObjectStorageInfo poStorageInfo, int locationType) {
        resourceIdSet.add(poStorageInfo.getResourceId());
        return poStorageInfo.getResourceProviderSN();
    }

    protected void arrayFilterRule(int type, int locationType, List<ProtectObject> protectObjects, int templateType, ExecutionContext context) {
        String devSn = (String)context.getAttribute(DEVICE_SN, String.class);
        Set resourceIdSet = (Set)context.getAttribute(RESOURCE_ID_SET);
        logger.info((Object)("resourceIdSet:" + resourceIdSet));
        List<Lun> lunList = this.queryLuns(devSn, resourceIdSet);
        Map<String, List<ReplicationPair>> devicesnPairMap = this.getClassifiedPairMap(resourceIdSet, lunList);
        this.filter3DcCascadePairMap(this.existProtectGroupReplica(protectObjects), type, locationType, templateType, devicesnPairMap);
        this.checkReplicationRelation(type, templateType, devicesnPairMap);
        String proSite = this.checkSite(devSn);
        this.saveProSite(locationType, proSite);
        this.getFilterContext().put("PRODUCT_DEVSN", devSn);
        this.checkConcurrentSameDev(templateType);
        this.checkConcurrent3DC(locationType);
        if (VerifyUtil.isEmpty(this.getLunTgtDevs())) {
            logger.warn((Object)"lunTgtDevs is empty.", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        this.degradeMethod(locationType);
        Object policyTemplateContext = this.getFilterContext().get("temp_policy_template_context");
        if (DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue() == locationType && null != policyTemplateContext && policyTemplateContext instanceof PolicyTemplateContext) {
            ((PolicyTemplateContext)PolicyTemplateContext.class.cast(policyTemplateContext)).addObject("DR_RING_SITE_A_SYNC_PAIR_MAP", devicesnPairMap);
        }
    }

    protected boolean existProtectGroupReplica(List<ProtectObject> protectObjects) {
        if (null != protectObjects && !protectObjects.isEmpty()) {
            ProtectObject protectObject = protectObjects.iterator().next();
            if (null == protectObject || null == protectObject.getProtectGroup()) {
                return false;
            }
            ProtectGroup protectGroup = protectObject.getProtectGroup();
            if (null == protectGroup.getUuid()) {
                return false;
            }
            IReplicaService repService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
            List pgReplicas = repService.queryProtectGroupReplicaByGroup(protectGroup.getUuid(), null, false);
            return !VerifyUtil.isEmpty((Collection)pgReplicas);
        }
        return false;
    }

    private void checkReplicationRelation(int type, int templateType, Map<String, List<ReplicationPair>> devicesnPairMap) {
        for (List<ReplicationPair> pairs : devicesnPairMap.values()) {
            Iterator<ReplicationPair> iterator = pairs.iterator();
            if (!iterator.hasNext()) {
                logger.error((Object)("pair is empty!type:" + type + ", templateType:" + templateType));
                throw new LegoCheckedException(1073948191L);
            }
            ReplicationPair pair = iterator.next();
            Lun lun = new Lun();
            lun.setLunId(pair.getSrcLunId());
            lun.setDevSn(pair.getDevSn());
            this.isCreatedReplication(type, lun, pairs, templateType);
        }
    }

    protected Map<String, List<ReplicationPair>> getClassifiedPairMap(Set<String> resourceIdSet, List<Lun> lunList) {
        Lun[] lunArray = new Lun[lunList.size()];
        lunList.toArray(lunArray);
        long startTime01 = System.currentTimeMillis();
        List<ReplicationPair> pairList = this.getPairsByLun(lunArray);
        logger.debug((Object)("End to get getPairsByLun. cost time:" + (System.currentTimeMillis() - startTime01)));
        Map<String, List<ReplicationPair>> devicesnPairMap = this.classifyPair(pairList);
        this.checkPairNum(resourceIdSet, lunList, devicesnPairMap);
        return devicesnPairMap;
    }

    protected List<Lun> queryLuns(String devSn, Set<String> resourceIdSet) {
        long startTime = System.currentTimeMillis();
        List lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSn, new ArrayList<String>(resourceIdSet), Lun.class);
        logger.debug((Object)("End to get target Lun. cost time:" + (System.currentTimeMillis() - startTime)));
        this.isLunExistInDB(devSn, resourceIdSet, lunList);
        return lunList;
    }

    protected void checkPairNum(Set<String> resourceIdSet, List<Lun> lunList, Map<String, List<ReplicationPair>> devicesnPairMap) {
        if (devicesnPairMap.size() != lunList.size()) {
            logger.error((Object)("Some luns not exist replication pair!lun size:" + lunList.size() + ",devicesnPairMap size:" + devicesnPairMap.size() + ". lunIds:" + resourceIdSet + ", devicesnPairMap lunIds:" + devicesnPairMap.keySet()));
            throw new LegoCheckedException(1073948175L);
        }
    }

    protected String checkSite(String devSn) {
        String proSite = this.getSiteByArraySn(devSn);
        if (VerifyUtil.isEmpty((String)proSite)) {
            logger.warn((Object)("can't get site by deviceSN:" + devSn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        return proSite;
    }

    protected Map<String, List<ReplicationPair>> classifyPair(List<ReplicationPair> pairList) {
        if (VerifyUtil.isEmpty(pairList)) {
            logger.warn((Object)"pairList is empty.");
            throw new LegoCheckedException(1073948175L);
        }
        HashSet<ReplicationPair> replicationPairSet = new HashSet<ReplicationPair>();
        replicationPairSet.addAll(pairList);
        HashMap<String, List<ReplicationPair>> devicesnPairMap = new HashMap<String, List<ReplicationPair>>();
        for (ReplicationPair pair : replicationPairSet) {
            List<ReplicationPair> pairs;
            String srcLunId = pair.getSrcLunId();
            if (!devicesnPairMap.containsKey(srcLunId)) {
                pairs = new ArrayList<ReplicationPair>();
                pairs.add(pair);
                devicesnPairMap.put(srcLunId, pairs);
                continue;
            }
            pairs = (List)devicesnPairMap.get(srcLunId);
            pairs.add(pair);
        }
        return devicesnPairMap;
    }

    private void isLunExistInDB(String devSn, Set<String> resourceIdSet, List<Lun> lunList) {
        if (VerifyUtil.isEmpty(lunList)) {
            logger.error((Object)("targetLunList is empty!tgtLunIdSet:" + this.getSetStr(resourceIdSet)));
            throw new LegoCheckedException(1073948685L, new String[]{this.getSetStr(resourceIdSet), devSn});
        }
        if (lunList.size() != resourceIdSet.size()) {
            this.dealNotExistedLunIds(lunList, resourceIdSet);
            logger.error((Object)"some of the lun is not in the database!");
            throw new LegoCheckedException(1073948685L, new String[]{this.getSetStr(resourceIdSet), devSn});
        }
    }

    private void dealNotExistedLunIds(List<Lun> targetLunList, Set<String> tgtLunIdSet) {
        ArrayList<String> existedLunIdList = new ArrayList<String>();
        for (Lun lun : targetLunList) {
            existedLunIdList.add(lun.getLunId());
        }
        tgtLunIdSet.removeAll(existedLunIdList);
    }

    private void nasFilterRule(int type, int locationType, int templateType, List<ProtectObjectStorageInfo> allStorageInfo) {
        ArrayList<ReplicationPair> allPairs = new ArrayList<ReplicationPair>();
        for (ProtectObjectStorageInfo posi : allStorageInfo) {
            NasFileSystem nasMo = this.getNasMo(posi);
            if (null == nasMo) {
                logger.warn((Object)("can't get nas info(" + posi.getResourceProviderSN() + "_" + posi.getResourceId() + ")."), 90160758786989L);
                throw new LegoCheckedException(1073948685L, new String[]{posi.getResourceId(), posi.getResourceProviderSN()});
            }
            String proSite = this.getSiteByArraySn(nasMo.getDevSn());
            if (VerifyUtil.isEmpty((String)proSite)) {
                logger.warn((Object)("can't get site by deviceSN:" + nasMo.getDevSn()), 90160758786989L);
                throw new LegoCheckedException(1073948449L);
            }
            this.getFilterContext().put("PRODUCT_DEVSN", nasMo.getDevSn());
            this.saveProSite(locationType, proSite);
            List<ReplicationPair> pairs = this.getPairsByNas(nasMo);
            if (VerifyUtil.isEmpty(pairs)) {
                logger.warn((Object)("master nas(" + nasMo.getMoId() + ")'s ReplicationPair is empty."), 90160758786989L);
                throw new LegoCheckedException(1073948175L);
            }
            allPairs.addAll(pairs);
            this.isCreatedReplication(type, nasMo, pairs, templateType);
        }
        this.checkVstorePair(allPairs, templateType);
        this.checkConcurrentSameDev(templateType);
        this.checkConcurrent3DC(locationType);
        if (VerifyUtil.isEmpty(this.getLunTgtDevs())) {
            logger.warn((Object)"lunTgtDevs is empty.", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        this.degradeMethod(locationType);
    }

    private void degradeMethod(int locationType) {
        this.isErrorCodeExisted();
        this.checkAllTargetLunBelongToSameDevice();
        this.setRecoverySite(locationType);
        for (String key : this.getLunTgtDevs().keySet()) {
            if (!VerifyUtil.isEmpty((Collection)this.getLunTgtDevs().get(key))) continue;
            logger.warn((Object)("the lunid is:" + key + " have not replication targetDevice"), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void isErrorCodeExisted() {
        for (String lunId : this.getLunTgtDevs().keySet()) {
            for (String info : this.getLunTgtDevs().get(lunId)) {
                try {
                    if (VerifyUtil.isEmpty((String)info) || !info.startsWith(ERROR_PREFIX)) continue;
                    long errorCode = Long.parseLong(info.substring(ERROR_PREFIX.length()));
                    throw new LegoCheckedException(errorCode);
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)"lunTgtDevs not errorcode.", 90160758786989L);
                }
            }
        }
    }

    private void setRecoverySite(int locationType) {
        Collection<List<String>> values = this.getLunTgtDevs().values();
        if (VerifyUtil.isEmpty(values)) {
            logger.error((Object)"values is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        List<String> devices = values.iterator().next();
        if (VerifyUtil.isEmpty(devices)) {
            logger.warn((Object)"lunTgtDevs devices is empty.", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        for (String sn : values.iterator().next()) {
            if (VerifyUtil.isEmpty((String)this.getSiteByArraySn(sn))) {
                logger.warn((Object)("Target device not regist, device is:" + sn), 90160758786989L);
                throw new LegoCheckedException(1073948449L);
            }
            this.saveRecovSite(locationType, sn);
            this.getFilterContext().put("TARGET_DEVSN", sn);
        }
    }

    protected void checkAllTargetLunBelongToSameDevice() {
        ArrayList<String> tgtDevs = new ArrayList<String>();
        for (String lunId : this.getLunTgtDevs().keySet()) {
            if (VerifyUtil.isEmpty(tgtDevs)) {
                for (String info : this.getLunTgtDevs().get(lunId)) {
                    tgtDevs.add(info);
                }
                continue;
            }
            boolean haveSameTgt = false;
            for (String info : this.getLunTgtDevs().get(lunId)) {
                if (!tgtDevs.contains(info)) continue;
                haveSameTgt = true;
            }
            if (haveSameTgt) continue;
            this.haveSameTgt();
            throw new LegoCheckedException(1073948463L);
        }
    }

    private void haveSameTgt() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, List<String>> lun2DeviceSn : this.getLunTgtDevs().entrySet()) {
            stringBuffer.append("lun id :" + lun2DeviceSn.getKey() + ":");
            for (String deviceSn : lun2DeviceSn.getValue()) {
                stringBuffer.append("device :" + deviceSn + ";");
            }
            stringBuffer.append(".####");
        }
        logger.error((Object)stringBuffer.toString(), 1073948463L);
    }

    protected void saveProSite(int type, String proSite) {
        logger.debug((Object)"Do saveProSite");
    }

    protected void saveRecovSite(int type, String sn) {
        logger.debug((Object)"Do saveRecovSite");
    }

    private void checkConcurrentSameDev(int tempType) {
        if (tempType == 5) {
            HashSet<String> devs = new HashSet<String>();
            for (String key : this.getLunTgtdevSn().keySet()) {
                devs.add(this.getLunTgtdevSn().get(key));
            }
            if (devs.size() != 1) {
                logger.warn((Object)"lunTgtDevs is not the same!.", 90160758786989L);
                throw new LegoCheckedException(1073948191L);
            }
        }
    }

    private void checkConcurrent3DC(int locationType) {
        if (locationType == DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue() && !VerifyUtil.isEmpty(this.getLunTgtDevs())) {
            boolean isTwoTgt = false;
            for (String key : this.getLunTgtDevs().keySet()) {
                List<String> tgtDevices = this.getLunTgtDevs().get(key);
                if (2 != tgtDevices.size()) {
                    isTwoTgt = false;
                    break;
                }
                isTwoTgt = true;
            }
            this.getFilterContext().put("CONCURRENT_3DC", isTwoTgt);
            if (isTwoTgt) {
                Collection<List<String>> values = this.getLunTgtDevs().values();
                List<String> devList = values.iterator().next();
                if (VerifyUtil.isEmpty(values) || VerifyUtil.isEmpty(devList) || devList.size() < 2) {
                    logger.error((Object)"getLunTgtDevs values size is smaller than two.", 90160758786989L);
                    throw new LegoCheckedException(1073947393L);
                }
                this.getFilterContext().put("SITE_B_3DC", this.getSiteByArraySn(devList.get(0)));
                this.getFilterContext().put("SITE_C_3DC", this.getSiteByArraySn(devList.get(1)));
            }
        }
    }

    protected int getResourcetype(Collection<ProtectObjectStorageInfo> allStorageInfo) {
        int type;
        block0: {
            type = DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
            Iterator<ProtectObjectStorageInfo> iterator = allStorageInfo.iterator();
            if (!iterator.hasNext()) break block0;
            ProtectObjectStorageInfo posi = iterator.next();
            type = posi.getResourceType();
        }
        return type;
    }

    protected Lun getLunMo(int locationType, ProtectObjectStorageInfo protectObjectStorageInfo) {
        if (null == protectObjectStorageInfo) {
            return null;
        }
        ArrayList<String> lunIds = new ArrayList<String>();
        lunIds.add(protectObjectStorageInfo.getResourceId());
        List lunList = null;
        try {
            lunList = this.getStorageService().queryLunByDevSnAndLunIds(protectObjectStorageInfo.getResourceProviderSN(), lunIds);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query lun error: " + protectObjectStorageInfo.getResourceProviderSN()), (long)1073948705L, (String[])new String[0], (Log)logger);
        }
        if (!VerifyUtil.isEmpty((Collection)lunList)) {
            return (Lun)lunList.get(0);
        }
        return null;
    }

    protected Lun getLunFromLocalOrRemote(ProtectObjectStorageInfo protectObjectStorageInfo) {
        if (VerifyUtil.isEmpty(this.getFilterContext().get(this.getDevAndLun(protectObjectStorageInfo.getResourceProviderSN(), protectObjectStorageInfo.getResourceId())))) {
            logger.error((Object)("Cascade3DC getLunMo getFilterContext key is null:" + this.getDevAndLun(protectObjectStorageInfo.getResourceProviderSN(), protectObjectStorageInfo.getResourceId())), 90160758787071L);
            return null;
        }
        String tgtLunInfo = String.valueOf(this.getFilterContext().get(this.getDevAndLun(protectObjectStorageInfo.getResourceProviderSN(), protectObjectStorageInfo.getResourceId())));
        Object[] infos = tgtLunInfo.split(":");
        if (VerifyUtil.isEmpty((Object[])infos) || infos.length < 2) {
            logger.error((Object)("Cascade3DC getLunMo tgtLunInfo is null, tgtLunInfo is:" + tgtLunInfo), 90160758787071L);
            return null;
        }
        Site site = this.getSiteByDeviceSN((String)infos[0]);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("Cascade3DC getLunMo getSiteByDeviceSN is null, deviceSN is:" + (String)infos[0]), 90160758787071L);
            return null;
        }
        Lun lunMo = this.getStorageService().getLunBySnAndLunId((String)infos[0], (String)infos[1]);
        if (null == lunMo) {
            logger.error((Object)("Cascade3DC can not get lunMo info(" + (String)infos[0] + "_" + (String)infos[1] + ")."), 90160758786989L);
        }
        return lunMo;
    }

    protected NasFileSystem getNasMo(ProtectObjectStorageInfo protectObjectStorageInfo) {
        if (null == protectObjectStorageInfo) {
            return null;
        }
        ArrayList<String> nasIds = new ArrayList<String>();
        nasIds.add(protectObjectStorageInfo.getResourceId());
        List nasList = null;
        try {
            nasList = this.getStorageResourceService().getStorageResources(protectObjectStorageInfo.getResourceProviderSN(), nasIds, NasFileSystem.class);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query nas error: " + protectObjectStorageInfo.getResourceProviderSN()), (long)1073948705L, (String[])new String[0], (Log)logger);
        }
        if (!VerifyUtil.isEmpty((Collection)nasList)) {
            return (NasFileSystem)nasList.get(0);
        }
        return null;
    }

    public int getType() {
        return 0;
    }

    public int getReplicationType() {
        return 1;
    }

    protected void isCreatedReplication(int type, NasFileSystem nasMo, List<ReplicationPair> pairs, int templateType) {
        if (null == pairs) {
            throw new LegoCheckedException(1073947393L);
        }
        List<ReplicationPair> pairsList = this.orderReplicationPairs(pairs);
        if (!this.getLunTgtDevs().keySet().contains(nasMo.getResourceId())) {
            ArrayList<String> syncRep = new ArrayList<String>();
            this.getLunTgtDevs().put(nasMo.getResourceId(), new ArrayList());
            boolean typeFlag = false;
            for (ReplicationPair replicationPair : pairsList) {
                if (pairsList.size() > 1) {
                    type = this.setReplicationType(pairsList, replicationPair, type, templateType, nasMo);
                }
                if (this.checkType(type, replicationPair)) {
                    typeFlag = true;
                    this.degradeCreateReplication(nasMo, replicationPair);
                }
                if (pairsList.size() < 2 || replicationPair.getReplicationMode() != 2 || templateType != 1) continue;
                syncRep.add(replicationPair.getTgtDevName());
            }
            if (!typeFlag) {
                this.getLunTgtDevs().get(nasMo.getResourceId()).add("ERROR:1073948191");
            }
            if (syncRep.size() >= 2) {
                logger.error((Object)("The Nas(" + nasMo.getResourceId() + ") all targetNas'replicationMode is AsyncRep"), 90160758786989L);
                throw new LegoCheckedException(1073948191L);
            }
        }
    }

    protected void isCreatedReplication(int type, Lun lun, List<ReplicationPair> pairs, int templateType) {
        if (null == pairs) {
            throw new LegoCheckedException(1073947393L);
        }
        boolean isDRRing = true;
        List<ReplicationPair> pairsList = this.orderReplicationPairs(pairs);
        if (!this.getLunTgtDevs().keySet().contains(lun.getLunId())) {
            ArrayList<String> syncRep = new ArrayList<String>();
            this.getLunTgtDevs().put(lun.getLunId(), new ArrayList());
            boolean typeFlag = false;
            for (ReplicationPair replicationPair : pairsList) {
                String drRingId = replicationPair.getDrRingId();
                if (VerifyUtil.isEmpty((String)drRingId) || drRingId.startsWith("--")) {
                    isDRRing = false;
                }
                if (pairsList.size() > 1) {
                    type = this.setReplicationType(pairsList, replicationPair, type, templateType, lun);
                }
                if (this.checkType(type, replicationPair)) {
                    typeFlag = true;
                    this.degradeCreateReplication(lun, replicationPair, true);
                }
                if (pairsList.size() < 2 || replicationPair.getReplicationMode() != 2 || templateType != 1) continue;
                syncRep.add(replicationPair.getTgtDevName());
            }
            if (!typeFlag) {
                this.getLunTgtDevs().get(lun.getLunId()).add("ERROR:1073948191");
            }
            if (syncRep.size() >= 2 && !isDRRing) {
                logger.error((Object)("The Lun(" + lun.getLunId() + ") all targetLun'replicationMode is AsyncRep"), 90160758786989L);
                throw new LegoCheckedException(1073948191L);
            }
        }
    }

    private int setReplicationType(List<ReplicationPair> pairsList, ReplicationPair replicationPair, int type, int templateType, NasFileSystem nasMo) {
        if (pairsList.get(0).getReplicationMode().intValue() != pairsList.get(1).getReplicationMode().intValue() && 5 == templateType && replicationPair.getReplicationMode().intValue() == pairsList.get(1).getReplicationMode().intValue()) {
            for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
                this.getLunTgtdevSn().put(nasMo.getResourceId(), replicationTargetLun.getTgtDevSN());
            }
            type = 2;
        }
        return type;
    }

    private int setReplicationType(List<ReplicationPair> pairsList, ReplicationPair replicationPair, int type, int templateType, Lun lun) {
        if (pairsList.get(0).getReplicationMode().intValue() != pairsList.get(1).getReplicationMode().intValue() && 5 == templateType && replicationPair.getReplicationMode().intValue() == pairsList.get(1).getReplicationMode().intValue()) {
            for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
                this.getLunTgtdevSn().put(lun.getLunId(), replicationTargetLun.getTgtDevSN());
            }
            type = 2;
        }
        return type;
    }

    private void degradeCreateReplication(NasFileSystem nasMo, ReplicationPair replicationPair) {
        List<String> devList = this.getLunTgtDevs().get(nasMo.getResourceId());
        if (VerifyUtil.isEmpty((Collection)replicationPair.getRepTgtLuns())) {
            this.isDevListNull(devList);
            devList.add("ERROR:1073948461");
        }
        for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
            this.isDevListNull(devList);
            if (this.normalStatusList.contains(replicationTargetLun.getPairStatus())) {
                devList.remove(replicationTargetLun.getTgtDevSN());
                devList.add(replicationTargetLun.getTgtDevSN());
                this.getFilterContext().put(this.getDevAndLun(replicationPair.getSrcDevSN(), replicationPair.getSrcLunId()), this.getDevAndLun(replicationTargetLun.getTgtDevSN(), replicationTargetLun.getTgtLunId()));
                continue;
            }
            devList.add("ERROR:1073948462");
        }
    }

    protected void degradeCreateReplication(Lun lun, ReplicationPair replicationPair, boolean checkPairStauts) {
        if (null == replicationPair || null == lun) {
            return;
        }
        List<String> devList = this.getLunTgtDevs().get(lun.getLunId());
        if (VerifyUtil.isEmpty((Collection)replicationPair.getRepTgtLuns())) {
            this.isDevListNull(devList);
            devList.add("ERROR:1073948461");
        }
        for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
            this.isDevListNull(devList);
            if (this.normalStatusList.contains(replicationTargetLun.getPairStatus()) || !checkPairStauts) {
                devList.remove(replicationTargetLun.getTgtDevSN());
                devList.add(replicationTargetLun.getTgtDevSN());
                String devAndLun = this.getDevAndLun(replicationPair.getSrcDevSN(), replicationPair.getSrcLunId());
                String devAndLun2 = this.getDevAndLun(replicationTargetLun.getTgtDevSN(), replicationTargetLun.getTgtLunId());
                logger.info((Object)("getDevAndLun:" + devAndLun + ", devAndLun2:" + devAndLun2));
                this.getFilterContext().put(devAndLun, devAndLun2);
                continue;
            }
            devList.add("ERROR:1073948462");
        }
    }

    private void isDevListNull(List<String> devList) {
        if (null == devList) {
            logger.error((Object)"devList is null.");
            throw new LegoCheckedException(1073948191L);
        }
    }

    protected boolean checkType(int type, ReplicationPair replicationPair) {
        return type == replicationPair.getReplicationMode();
    }

    protected void removeFilterKey(List<String> newTargetDeviceSN) {
        if (null == newTargetDeviceSN) {
            return;
        }
        ArrayList<String> remove = new ArrayList<String>();
        for (String dev : newTargetDeviceSN) {
            for (String key : this.getFilterContext().keySet()) {
                if (String.valueOf(this.getFilterContext().get(key)).contains(dev)) continue;
                remove.add(key);
            }
        }
        for (String key : remove) {
            this.getFilterContext().remove(key);
        }
    }

    protected Lun checkLunExsist(String lunId, String deviceId) {
        Lun lunMo = this.getStorageService().getLunBySnAndLunId(deviceId, lunId);
        if (null == lunMo) {
            logger.error((Object)("can't get lun info(" + deviceId + "_" + lunId + ")."), 90160758786989L);
        }
        return lunMo;
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            logger.error((Object)("deviceSN is empty!deviceSN:" + deviceSN));
            return null;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        return null;
    }

    private String getStringFromCollection(Collection<String> collection, String seperator) {
        if (VerifyUtil.isEmpty(collection) || VerifyUtil.isEmpty((String)seperator)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : collection) {
            sb.append(str);
            sb.append(seperator);
        }
        if (sb.length() == 0) {
            return "";
        }
        String result = sb.substring(0, sb.length() - 1);
        return result;
    }

    public Collection<ReplicationPair> getPairsByLun(Collection<Lun> luns) {
        if (luns == null || luns.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getPairsByLun(luns.toArray(new Lun[luns.size()]));
    }

    protected List<ReplicationPair> getPairByNasList(List<NasFileSystem> nasFileSystems) {
        if (VerifyUtil.isEmpty(nasFileSystems)) {
            return Collections.emptyList();
        }
        String devSn = "";
        ArrayList<String> nasIdList = new ArrayList<String>();
        for (NasFileSystem nas : nasFileSystems) {
            devSn = nas.getDevSn();
            nasIdList.add(nas.getResourceId());
        }
        Site site = this.getSiteByDeviceSN(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairByNas error, site is null, deviceSN:" + devSn));
            return Collections.emptyList();
        }
        return this.getPairsByResourceIds(devSn, nasIdList, site, DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue());
    }

    protected List<ReplicationPair> getPairsByLun(Lun ... luns) {
        if (VerifyUtil.isEmpty((Object[])luns)) {
            logger.error((Object)"lunMo is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        String devSn = "";
        ArrayList<String> lunIdList = new ArrayList<String>();
        for (Lun lun : luns) {
            devSn = lun.getDevSn();
            lunIdList.add(lun.getLunId());
        }
        Site site = this.getSiteByDeviceSN(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByLun error, site is null, deviceSN:" + devSn));
            return null;
        }
        return this.getPairsByResourceIds(devSn, lunIdList, site, DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue());
    }

    protected List<ReplicationPair> getPairsByResourceIds(String devSn, List<String> resIdList, Site site, Integer resourceType) {
        return this.getReplicationPairsByResources(devSn, resIdList, site, resourceType);
    }

    protected List<ReplicationPair> getPairsByNas(NasFileSystem nasMo) {
        if (null == nasMo) {
            return Collections.emptyList();
        }
        Site site = this.getSiteByDeviceSN(nasMo.getDevSn());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByNas error, site is null, deviceSN:" + nasMo.getDevSn()), 90160758787071L);
            return Collections.emptyList();
        }
        ArrayList<String> nasIds = new ArrayList<String>();
        nasIds.add(nasMo.getResourceId());
        return this.queryValidReplicationPairsBy(nasMo.getDevSn(), nasIds, true, DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue());
    }

    protected String getSiteByArraySn(String deviceSN) {
        Site site = this.getSiteByDeviceSN(deviceSN);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getSiteByArraySn error, site is null, deviceSN:" + deviceSN), 90160758787071L);
            return null;
        }
        return site.getSiteId();
    }

    private List<ReplicationPair> orderReplicationPairs(List<ReplicationPair> pairs) {
        if (!VerifyUtil.isEmpty(pairs)) {
            for (int i = 0; i < pairs.size(); ++i) {
                for (int j = 0; j <= i; ++j) {
                    if (pairs.get(j).getReplicationMode() <= pairs.get(i).getReplicationMode()) continue;
                    ReplicationPair temp = pairs.get(i);
                    pairs.set(i, pairs.get(j));
                    pairs.set(j, temp);
                }
            }
        }
        return pairs;
    }

    protected ProtectLocationPath constructSitePath(int location, String fromId, String toId) {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        ProtectLocationPath protectLocation = new ProtectLocationPath();
        protectLocation.setProtectLocation(location);
        if (location == DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue()) {
            Object acPairMap = DRRingCommUtil.getObjectFromTemplateContext(this.getFilterContext(), "DR_RING_SITE_A_SYNC_PAIR_MAP");
            Object bcPairMap = DRRingCommUtil.getObjectFromTemplateContext(this.getFilterContext(), "DR_RING_SITE_B_ASYNC_PAIR_MAP");
            Map acPairs = (Map)acPairMap;
            Map bcPairs = (Map)bcPairMap;
            String productSn = DRRingCommUtil.getSnByPair(true, acPairs);
            String secondDevSn = DRRingCommUtil.getSnByPair(false, acPairs);
            String thirdDevSn = DRRingCommUtil.getSnByPair(false, bcPairs);
            if (null == productSn || null == secondDevSn || null == thirdDevSn) {
                throw new LegoCheckedException(0x300001L);
            }
            String siteA = (String)this.getFilterContext().get("SITE_A_3DC");
            String siteB = (String)this.getFilterContext().get("SITE_B_3DC");
            String siteC = (String)this.getFilterContext().get("SITE_C_3DC");
            protectLocation.setProtectedSiteName(siteService.getSiteById(siteA).getName() + ":" + siteService.getSiteById(siteB).getName());
            protectLocation.setProtectedSiteId(siteA + ":" + siteB);
            protectLocation.setProtectedStorageSN(productSn + ":" + secondDevSn);
            protectLocation.setRecoverySiteName(siteService.getSiteById(siteC).getName());
            protectLocation.setRecoverySiteId(siteC);
            protectLocation.setRecoveryStorageSN(thirdDevSn);
            return protectLocation;
        }
        protectLocation.setProtectedSiteId(fromId);
        protectLocation.setRecoverySiteId(toId);
        protectLocation.setProtectedSiteName(siteService.getSiteById(fromId).getName());
        protectLocation.setRecoverySiteName(siteService.getSiteById(toId).getName());
        return protectLocation;
    }

    protected ProtectLocationPath constructSitePath(int location, String fromSiteDevSn, String toSiteDevSn, String replicationMode) {
        String fromId = this.getSiteByDeviceSN(fromSiteDevSn).getSiteId();
        String toId = this.getSiteByDeviceSN(toSiteDevSn).getSiteId();
        ProtectLocationPath path = this.constructSitePath(location, fromId, toId);
        path.setReplicationMode(replicationMode);
        path.setProtectedStorageSN(fromSiteDevSn);
        path.setRecoveryStorageSN(toSiteDevSn);
        return path;
    }

    public List<Integer> getNormalStatusList() {
        return this.normalStatusList;
    }

    private void checkVstorePair(List<ReplicationPair> allPairs, int templateType) {
        String vstorePiarId = allPairs.iterator().next().getVstorePairId();
        if (20 == templateType && (VerifyUtil.isEmpty((String)vstorePiarId) || vstorePiarId.startsWith("--"))) {
            throw new LegoCheckedException(1073948191L);
        }
        for (ReplicationPair pair : allPairs) {
            if (VerifyUtil.isEmpty((String)vstorePiarId) && !VerifyUtil.isEmpty((String)pair.getVstorePairId())) {
                throw new LegoCheckedException(1073948191L);
            }
            if (VerifyUtil.isEmpty((String)vstorePiarId) || vstorePiarId.equals(pair.getVstorePairId())) continue;
            logger.error((Object)"replicaiton pair not match vstore pair.", 90160758787071L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private List<ReplicationPair> getReplicationPairsByResources(String devSn, List<String> resIdList, Site site, Integer resourceType) {
        String resIds = this.getStringFromCollection(resIdList, ";");
        logger.debug((Object)("resIds:" + resIds));
        return this.getStorageService().getReplicationPairsByResourceIds(devSn, resIdList, resourceType);
    }

    protected List<ReplicationPair> getReplicationPairsByResources(String devSn, List<String> resIdList, Integer resourceType) {
        String resIds = this.getStringFromCollection(resIdList, ";");
        logger.debug((Object)("resIds:" + resIds));
        return this.getStorageService().getReplicationPairsByResourceIds(devSn, resIdList, resourceType);
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        return this.getReplicationProtectLocationPaths(protectObjects);
    }

    protected Map<String, List<ReplicationPair>> getStandbyPair(String masterSn, String slaveSn, List<ProtectObject> protectObjects, Set<String> resourceIds) {
        ExecutionContext context = this.init(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), protectObjects);
        List allStorageInfo = (List)context.getAttribute(PO_STORAGE_INFO_LIST);
        if (this.getResourcetype(allStorageInfo) == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            return Collections.emptyMap();
        }
        try {
            List<Lun> lunList = this.queryLuns(masterSn, resourceIds);
            Map<String, List<ReplicationPair>> devicesnPairMap = this.getClassifiedPairMap(resourceIds, lunList);
            return this.filterStandbyBySite(masterSn, slaveSn, devicesnPairMap);
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)"array replication filter failed!", 90160758786989L);
            throw e;
        }
    }

    protected Map<String, List<ReplicationPair>> filterStandbyBySite(String masterSn, String slaveSn, Map<String, List<ReplicationPair>> deviceSnPairMap) {
        return null;
    }

    protected boolean getAndCheckIsRing(Map<String, List<ReplicationPair>> abPairMap, Map<String, List<ReplicationPair>> bcPairMap, Map<String, List<ReplicationPair>> acPairMap, Set<String> usedDRRings) {
        if (null == abPairMap || null == bcPairMap || null == acPairMap) {
            logger.error((Object)"abPairMap or bcPairMap or acPairMap is null");
            return false;
        }
        if (abPairMap.size() != bcPairMap.size() || bcPairMap.size() != acPairMap.size()) {
            logger.error((Object)("abPairMap size is " + abPairMap.size() + ", bcPairMap size is " + bcPairMap.size() + ", acPairMap size is " + acPairMap.size()));
            return false;
        }
        for (List<ReplicationPair> pairs : abPairMap.values()) {
            for (ReplicationPair abPair : pairs) {
                String drRingId = abPair.getDrRingId();
                usedDRRings.add(drRingId);
                List<ReplicationPair> acPairs = acPairMap.get(abPair.getSrcLunId());
                if (acPairs.size() != 1) {
                    logger.error((Object)("ac Pair size not 1. src Lun id : " + abPair.getSrcLunId()));
                    return false;
                }
                ReplicationPair acPair = (ReplicationPair)CommonUtil.getFirstElement(acPairs);
                if (null == acPair || null == drRingId) {
                    logger.error((Object)("ac Pair or DRRingId is null, src lun id : " + abPair.getSrcLunId()));
                    return false;
                }
                for (ReplicationTargetLun tgtLun : abPair.getRepTgtLuns()) {
                    List<ReplicationPair> bcPairs = bcPairMap.get(tgtLun.getTgtLunId());
                    if (bcPairs.size() == 1 && drRingId.equals(((ReplicationPair)CommonUtil.getFirstElement(bcPairs)).getDrRingId()) && drRingId.equals(acPair.getDrRingId())) continue;
                    logger.error((Object)"bc pair isn't one or DRRingId not match.");
                    return false;
                }
            }
        }
        return true;
    }

    protected void fillStandbySpeedPolicy(Schedule schedule, ProtectGroupReplica protectGroupReplica, ProtectGroupReplica protectGroupReplicaAB) {
        schedule.setSourceSiteId(protectGroupReplica.getPg().getProductSiteId() + ":" + protectGroupReplicaAB.getRecoverySite());
        List speedPolicies = schedule.getReplicationSpeedPolicies();
        if (VerifyUtil.isEmpty((Collection)speedPolicies)) {
            logger.info((Object)"speedPolicies is null or empty");
            return;
        }
        ArrayList<ReplicationSpeedPolicy> newspeedPolicies = new ArrayList<ReplicationSpeedPolicy>();
        for (ReplicationSpeedPolicy replicationSpeedPolicy : speedPolicies) {
            newspeedPolicies.add(replicationSpeedPolicy);
            ReplicationSpeedPolicy newspeedPolicy = new ReplicationSpeedPolicy();
            newspeedPolicy.setEndTime(replicationSpeedPolicy.getEndTime());
            newspeedPolicy.setStartTime(replicationSpeedPolicy.getStartTime());
            newspeedPolicy.setSyncRateLevel(replicationSpeedPolicy.getSyncRateLevel());
            if (protectGroupReplicaAB.getProductArray().equals(replicationSpeedPolicy.getStorageSn())) {
                newspeedPolicy.setStorageSn(protectGroupReplicaAB.getRecoveryArray());
            } else {
                newspeedPolicy.setStorageSn(protectGroupReplicaAB.getProductArray());
            }
            newspeedPolicies.add(newspeedPolicy);
        }
        schedule.setReplicationSpeedPolicies(newspeedPolicies);
    }

    protected void deleteStandbySpeedPolicy(Schedule schedule, ProtectGroupReplica protectGroupReplica, ProtectGroupReplica protectGroupReplicaAB) {
        if (protectGroupReplica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue()) {
            schedule.setSourceSiteId(protectGroupReplica.getPg().getProductSiteId());
        } else {
            schedule.setSourceSiteId(protectGroupReplicaAB.getRecoverySite());
        }
        List speedPolicies = schedule.getReplicationSpeedPolicies();
        if (VerifyUtil.isEmpty((Collection)speedPolicies)) {
            logger.info((Object)"speedPolicies is null or empty");
            return;
        }
        ArrayList<ReplicationSpeedPolicy> newspeedPolicies = new ArrayList<ReplicationSpeedPolicy>();
        for (ReplicationSpeedPolicy replicationSpeedPolicy : speedPolicies) {
            if (!protectGroupReplica.getProductArray().equals(replicationSpeedPolicy.getStorageSn())) continue;
            newspeedPolicies.add(replicationSpeedPolicy);
        }
        schedule.setReplicationSpeedPolicies(newspeedPolicies);
    }
}

