/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplicationAlarmInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySyncReplicationBuilder;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;

public class DRRingCommUtil {
    public static final String NO_DRRING = "--";
    public static final String SYNCRATETASK = "SyncRateTask";
    public static final String COLON = ":";
    private static final Log logger = LogFactory.getInstance(DRRingCommUtil.class);

    public static Object getObjectFromTemplateContext(Map<String, Object> filterContext, String templateKey) {
        if (null == filterContext) {
            return null;
        }
        Object policyTemplateContext = filterContext.get("temp_policy_template_context");
        if (null != policyTemplateContext && policyTemplateContext instanceof PolicyTemplateContext) {
            return ((PolicyTemplateContext)PolicyTemplateContext.class.cast(policyTemplateContext)).getObject(templateKey);
        }
        return null;
    }

    public static boolean addObjectToTemplateContext(Map<String, Object> filterContext, String templateKey, Object templateValue) {
        if (null == filterContext || null == templateKey) {
            return false;
        }
        Object policyTemplateContext = filterContext.get("temp_policy_template_context");
        if (null != policyTemplateContext && policyTemplateContext instanceof PolicyTemplateContext) {
            ((PolicyTemplateContext)PolicyTemplateContext.class.cast(policyTemplateContext)).addObject(templateKey, templateValue);
            return true;
        }
        return false;
    }

    public static boolean isCorrectStandby(String masterSn, String slaveSn, ReplicationPair pair) {
        if (null == masterSn || null == slaveSn || null == pair) {
            logger.error((Object)"error param.");
            return false;
        }
        List tgtLuns = pair.getRepTgtLuns();
        if (VerifyUtil.isEmpty((Collection)tgtLuns) || tgtLuns.isEmpty()) {
            logger.error((Object)"tgtLun is empty.");
            return false;
        }
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            boolean matchSn;
            int pairStatus = tgtLun.getPairStatus();
            boolean isStandbyPair = XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue() == pairStatus && pair.getReplicationMode() == 2 && XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue() == CommUtil.convertToInteger((Object)pair.getHealthState()).intValue();
            boolean bl = matchSn = masterSn.equals(pair.getDevSn()) && slaveSn.equals(tgtLun.getTgtDevSN());
            if (!isStandbyPair || !matchSn) continue;
            return true;
        }
        return false;
    }

    public static String getSnByPair(boolean isMaster, Map<String, List<ReplicationPair>> pairMap) {
        if (null == pairMap) {
            return null;
        }
        for (List<ReplicationPair> pairs : pairMap.values()) {
            for (ReplicationPair replicationPair : pairs) {
                if (isMaster && null != replicationPair.getDevSn()) {
                    return replicationPair.getDevSn();
                }
                List replicationTargetLuns = replicationPair.getRepTgtLuns();
                for (ReplicationTargetLun replicationTargetLun : replicationTargetLuns) {
                    if (null == replicationTargetLun.getTgtDevSN()) continue;
                    return replicationTargetLun.getTgtDevSN();
                }
            }
        }
        return null;
    }

    public static ProtectGroupReplica getPgReplica(int protectLocation, Set<ProtectGroupReplica> pgReplica) {
        if (null == pgReplica) {
            throw new LegoCheckedException(1073947393L);
        }
        for (ProtectGroupReplica protectGroupReplica : pgReplica) {
            if (protectGroupReplica.getProtectLocation() != protectLocation) continue;
            return protectGroupReplica;
        }
        throw new LegoCheckedException(1073947393L);
    }

    public static Map<String, List<ReplicationPair>> filterStandbyPair(Map<String, List<ReplicationPair>> pairMap) {
        if (null == pairMap) {
            throw new LegoCheckedException(1073947393L);
        }
        for (List<ReplicationPair> pairList : pairMap.values()) {
            Iterator<ReplicationPair> iterators = pairList.iterator();
            while (iterators.hasNext()) {
                ReplicationPair replicationPair = iterators.next();
                for (ReplicationTargetLun tgtLun : replicationPair.getRepTgtLuns()) {
                    if (XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue() != tgtLun.getPairStatus().intValue()) continue;
                    iterators.remove();
                }
            }
        }
        return pairMap;
    }

    public static void initAllLunByPgReplica(ProtectGroupReplica syncReplic, Set<Lun> syncMasterLun, Set<Lun> syncSlaveLun) {
        if (null == syncReplic || null == syncMasterLun || null == syncSlaveLun) {
            logger.error((Object)"syncReplic or syncMasterLun or syncMasterLun is null.");
            return;
        }
        for (ProtectObjectReplica poReplica : syncReplic.getReplicas()) {
            for (RelicaStorageInfo relicaStorageInfo : poReplica.getStorageInfos()) {
                if (!(relicaStorageInfo instanceof RemoteStorageReplica)) continue;
                RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)RemoteStorageReplica.class.cast(relicaStorageInfo);
                Lun masterLun = new Lun();
                masterLun.setUuid(remoteStorageReplica.getSrcStorageId());
                masterLun.setDevSn(remoteStorageReplica.getSrcStorageProviderSN());
                masterLun.setLunId(remoteStorageReplica.getSrcStorageId());
                syncMasterLun.add(masterLun);
                Lun slaveLun = new Lun();
                slaveLun.setUuid(remoteStorageReplica.getStorageId());
                slaveLun.setDevSn(remoteStorageReplica.getStorageProviderSN());
                slaveLun.setLunId(remoteStorageReplica.getStorageId());
                syncSlaveLun.add(slaveLun);
            }
        }
    }

    public static boolean hasDRRingId(Map<String, List<ReplicationPair>> pairMap) {
        if (VerifyUtil.isEmpty(pairMap)) {
            return false;
        }
        for (List<ReplicationPair> pairs : pairMap.values()) {
            if (VerifyUtil.isEmpty(pairs)) continue;
            for (ReplicationPair replicationPair : pairs) {
                if (VerifyUtil.isEmpty((String)replicationPair.getDrRingId())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ProtectGroupSyncRatePolicy> getProtectGroupSyncRatePolicies(JobExecutionContext jobExecutionContext) {
        Trigger quartzTrigger = jobExecutionContext.getTrigger();
        JobDataMap quartzJobDataMap = quartzTrigger.getJobDataMap();
        char protectLocation = quartzTrigger.getJobKey().getName().charAt(quartzTrigger.getJobKey().getName().length() - 1);
        Object syncRateObj = quartzJobDataMap.get((Object)(SYNCRATETASK + protectLocation));
        if (syncRateObj == null || !List.class.isInstance(syncRateObj)) {
            logger.error((Object)("pgSyncRatePolicys is null! protectLocation:" + protectLocation));
            throw new LegoCheckedException(1073947394L);
        }
        return (List)syncRateObj;
    }

    public static Collection<ProtectGroupReplicationAlarmInfo> calculateProtectGroupStatus(ProtectGroup protectGroup, ArraySyncReplicationBuilder builder) {
        HashSet<ProtectGroupReplicationAlarmInfo> pgReplicationAlarmInfos = new HashSet<ProtectGroupReplicationAlarmInfo>();
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (!pgReplica.isStorageReplicationReplica()) continue;
            pgReplicationAlarmInfos.add(builder.calculateProtectGroupReplicaStatus(pgReplica));
        }
        return pgReplicationAlarmInfos;
    }

    public static Collection<String> convertDRRingIdsToDRRingUuids(Collection<String> drRingIds, Collection<String> storageSNList) {
        if (storageSNList == null) {
            return Collections.emptyList();
        }
        HashSet<String> results = new HashSet<String>();
        for (String storage : storageSNList) {
            results.addAll(DRRingCommUtil.convertDRRingIdsToDRRingUuids(drRingIds, storage));
        }
        return results;
    }

    private static Collection<String> convertDRRingIdsToDRRingUuids(Collection<String> drRingIds, String storageSN) {
        if (drRingIds == null) {
            return Collections.emptyList();
        }
        HashSet<String> results = new HashSet<String>();
        for (String drRingId : drRingIds) {
            results.add(DRRingCommUtil.convertDRRingIdToDRRingUuid(storageSN, drRingId));
        }
        return results;
    }

    public static String convertDRRingIdToDRRingUuid(String sn, String id) {
        return new XveUUID(sn, XveMOType.HYPER_DR_RING, id).toString();
    }
}

