/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.base;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.CheckRollbackProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public abstract class BaseHyperVaultRollbackProcessor
extends BaseRecoveryProcessor {
    public static final String REMOTE_RECOVERY_TASK_KEY = "remoteRecoveryTasks";
    private static final Log LOGGER = LogFactory.getInstance(BaseHyperVaultRollbackProcessor.class);
    private static final long serialVersionUID = 423162030540235228L;

    protected boolean execute(RecoveryProcessorContext context) {
        Collection<RecoveryTask> remoteRecoveryTasks = this.getRemoteRecoveryTasks(context);
        context.setAttribute(REMOTE_RECOVERY_TASK_KEY, remoteRecoveryTasks);
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (!VerifyUtil.isEmpty((Object)replica)) {
            String replicaName = replica.getName();
            this.updateProcessDetail("ism.drm.recovery.replication.rollback.operation", new String[]{replicaName});
        }
        this.setSubProcessors(replica);
        boolean execResult = this.serialExcuteChildProc(context);
        if (!execResult) {
            Optional opt = context.getProtectPortTask();
            AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
            opt.ifPresent(task -> portUtil.consumeFailedAirGapTask(task, DrmEnumDefine.ExecTypeEnum.MANUAL.getType()));
        }
        return execResult;
    }

    protected Collection<RecoveryTask> getRemoteRecoveryTasks(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        return RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getRecoveryTasks(recoveryPlan);
    }

    protected abstract void setSubProcessors(ProtectGroupReplica var1);

    protected void setLocalSubProcessors() {
    }

    protected void setRemoteSubProcessors() {
        LinkedHashSet<RecoveryProcessor> subProcessors = new LinkedHashSet<RecoveryProcessor>();
        this.setSplitSubProcessor(subProcessors, false, false);
        this.setRefactorSubProcessor(subProcessors, false);
        this.setRollbackSubProcessor(subProcessors);
        this.setCheckRollbackProcessor(subProcessors);
        this.setSyncSubProcessor(subProcessors);
        this.setSplitSubProcessor(subProcessors, false, false);
        this.setRefactorSubProcessor(subProcessors, true);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected abstract void setSyncSubProcessor(Set<RecoveryProcessor> var1);

    protected abstract void setRefactorSubProcessor(Set<RecoveryProcessor> var1, boolean var2);

    protected void setCheckRollbackProcessor(Set<RecoveryProcessor> subProcessors) {
        CheckRollbackProcessor checkRollbackProcessor = new CheckRollbackProcessor();
        checkRollbackProcessor.setParentProc((RecoveryProcessor)this);
        checkRollbackProcessor.setProcType(this.getProcType());
        checkRollbackProcessor.setIsNeedSave(false);
        subProcessors.add((RecoveryProcessor)checkRollbackProcessor);
    }

    protected abstract void setRollbackSubProcessor(Set<RecoveryProcessor> var1);

    protected abstract void setSplitSubProcessor(Set<RecoveryProcessor> var1, boolean var2, boolean var3);

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == procStatus.getValue()) {
            return true;
        }
        this.getLogger().debug((Object)"The status is failed");
        return false;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

