/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.ActiveSnapshotProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateNasSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BackupTargetDataProcessor
extends BaseRecoveryProcessor {
    public static final String BACKUP_SNAPSHOT_KEY = "backupSnapshotInfoKey";
    private static final long serialVersionUID = 6233320096774809463L;
    private static final String SNAPSHOT_ID = "SnapshotId";
    private static final String LUN_ID = "LunId";
    private static final String LUN_NAME = "LunName";
    private static final String RESOURCE_ID = "ResourceId";
    private static final String RESOURCE_NAME = "ResourceName";
    private static final String DEVICE_ID = "DeviceId";
    private static final String SNAPSHOT_NAME = "SnapshotName";
    private static final String RESOURCE_TYPE = "ResourceType";
    private static final Log logger = LogFactory.getInstance(BackupTargetDataProcessor.class);
    private String snapShotInfos;

    public String getSnapShotInfos() {
        return this.snapShotInfos;
    }

    public void setSnapShotInfos(String snapShotInfos) {
        this.snapShotInfos = snapShotInfos;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)this.getRecoveryTasksKey());
        String disasterSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID"));
        HashSet<RecoveryProcessor> createSnapshotSubProcessors = new HashSet<RecoveryProcessor>();
        HashSet<RecoveryProcessor> createNasSnapshotSubProcessors = new HashSet<RecoveryProcessor>();
        this.updateSubProcessors(RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disasterSiteId), createSnapshotSubProcessors, createNasSnapshotSubProcessors);
        if (VerifyUtil.isEmpty(createSnapshotSubProcessors)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(createSnapshotSubProcessors));
        recoveryTemplate.process(context);
        HashSet<RecoveryProcessor> successProcessors = new HashSet<RecoveryProcessor>();
        JSONArray resultArray = new JSONArray();
        boolean result = this.getLunSubProcessorsResult(createSnapshotSubProcessors, successProcessors, resultArray);
        if (!result) {
            try {
                this.deleteFailedSnapShot(context, successProcessors);
            }
            catch (Exception e) {
                logger.error((Object)("deleteFailedSnapShot failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            this.updateProcessDetail("lego.err.1073948759", new String[0]);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.setContextProcessStatusFailed();
            return true;
        }
        this.activceSnapshot(context, createSnapshotSubProcessors);
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() == this.getProcStatus()) {
            try {
                this.deleteFailedSnapShot(context, createSnapshotSubProcessors);
            }
            catch (Exception e) {
                logger.error((Object)("deleteFailedSnapShot failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.setContextProcessStatusFailed();
            }
        } else if (!VerifyUtil.isEmpty(createNasSnapshotSubProcessors)) {
            RecoveryProcessConcurrentExecutor recoveryNasTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(createNasSnapshotSubProcessors));
            recoveryNasTemplate.process(context);
            result = this.getNasSubProcessorsResult(createNasSnapshotSubProcessors, successProcessors, resultArray);
            if (!result) {
                try {
                    this.deleteFailedSnapShot(context, successProcessors);
                }
                catch (Exception e) {
                    logger.error((Object)("deleteFailedSnapShot failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                this.updateProcessDetail("lego.err.1073948759", new String[0]);
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.setContextProcessStatusFailed();
                return true;
            }
            DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(createNasSnapshotSubProcessors);
            this.setProcStatus(procStatus.getValue());
        }
        return true;
    }

    private void activceSnapshot(RecoveryProcessorContext context, Set<RecoveryProcessor> createSnapshotSubProcessors) {
        ActiveSnapshotProcessor activeSnapProc = new ActiveSnapshotProcessor();
        activeSnapProc.setProcName(activeSnapProc.getName());
        activeSnapProc.setProcType(this.getProcType());
        activeSnapProc.setPlanId(this.getPlanId());
        activeSnapProc.setProcessId(this.getProcessId());
        activeSnapProc.setParentProc((RecoveryProcessor)this);
        activeSnapProc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        activeSnapProc.setIsNeedSave(false);
        activeSnapProc.setIsNeedCreateDetail(false);
        activeSnapProc.setCreateSnapshotSubProcessors(createSnapshotSubProcessors);
        activeSnapProc.process(context);
        for (RecoveryProcessor process : createSnapshotSubProcessors) {
            this.reCalcCreateSnapshotResult(context, (CreateSnapshotSubProcessor)process, activeSnapProc);
        }
        this.reCalcProcessResult(activeSnapProc);
    }

    private boolean getLunSubProcessorsResult(Set<RecoveryProcessor> createSnapshotSubProcessors, Set<RecoveryProcessor> successProcessors, JSONArray resultArray) {
        boolean result = true;
        for (RecoveryProcessor process : createSnapshotSubProcessors) {
            if (process.getProcStatus() != DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue()) {
                result = false;
                continue;
            }
            CreateSnapshotSubProcessor processor = (CreateSnapshotSubProcessor)process;
            if (!VerifyUtil.isEmpty((String)processor.getSnapshotId())) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)SNAPSHOT_ID, (Object)processor.getSnapshotId());
                jsonObject.put((Object)LUN_ID, (Object)processor.getLunId());
                jsonObject.put((Object)LUN_NAME, (Object)processor.getLunName());
                jsonObject.put((Object)DEVICE_ID, (Object)processor.getDeviceId());
                jsonObject.put((Object)SNAPSHOT_NAME, (Object)processor.getSnapshotName());
                jsonObject.put((Object)RESOURCE_TYPE, (Object)DrmEnumDefine.RESOURCE_TYPE_E.LUN.toString());
                resultArray.add((Object)jsonObject);
            }
            successProcessors.add(process);
        }
        if (this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.VM_ROLLBACK.getValue()) {
            String snapShotInfosJson = this.getSnapShotInfos();
            JSONArray newArray = JSONArray.fromObject((Object)snapShotInfosJson);
            newArray.addAll((Collection)resultArray);
            this.setSnapShotInfos(newArray.toString());
        } else {
            this.setSnapShotInfos(resultArray.toString());
        }
        this.getContextRef().setAttribute(BACKUP_SNAPSHOT_KEY, (Object)resultArray.toString());
        return result;
    }

    private boolean getNasSubProcessorsResult(Set<RecoveryProcessor> createNasSnapshotSubProcessors, Set<RecoveryProcessor> successProcessors, JSONArray resultArray) {
        boolean result = true;
        for (RecoveryProcessor process : createNasSnapshotSubProcessors) {
            CreateNasSnapshotSubProcessor processor;
            if (process.getProcStatus() != DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue()) {
                result = false;
            } else {
                successProcessors.add(process);
            }
            if (VerifyUtil.isEmpty((String)(processor = (CreateNasSnapshotSubProcessor)process).getSnapshotId())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)SNAPSHOT_ID, (Object)processor.getSnapshotId());
            jsonObject.put((Object)RESOURCE_ID, (Object)processor.getResourceId());
            jsonObject.put((Object)RESOURCE_NAME, (Object)processor.getResourceName());
            jsonObject.put((Object)DEVICE_ID, (Object)processor.getDeviceId());
            jsonObject.put((Object)SNAPSHOT_NAME, (Object)processor.getSnapshotName());
            jsonObject.put((Object)RESOURCE_TYPE, (Object)DrmEnumDefine.RESOURCE_TYPE_E.NAS.toString());
            resultArray.add((Object)jsonObject);
        }
        this.setSnapShotInfos(resultArray.toString());
        return result;
    }

    private boolean reCalcProcessResult(ActiveSnapshotProcessor activeSnapProc) {
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(activeSnapProc.getProcStatus());
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.setContextProcessStatusFailed();
        }
        return true;
    }

    private boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks, Set<RecoveryProcessor> createSnapshotSubProcessors, Set<RecoveryProcessor> createNasSnapshotSubProcessors) {
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map lunAndHostMap = recoveryTask.getLunAndHostMap();
            Map resourceAndTypeMap = recoveryTask.getResourceAndTypeMap();
            if (VerifyUtil.isEmpty((Map)lunAndHostMap) || VerifyUtil.isEmpty((Map)resourceAndTypeMap)) continue;
            Set entrySet = lunAndHostMap.entrySet();
            for (Map.Entry entry : entrySet) {
                BaseRecoveryProcessor processor;
                String lunAndHostMapKey = (String)entry.getKey();
                String lunId = RecoveryProcessUtil.getLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                String srcLunId = RecoveryProcessUtil.getSrcLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                String hostOrGroupIds = RecoveryProcessUtil.getHostOrGroupIds((List)((List)entry.getValue()));
                Integer appType = (Integer)resourceAndTypeMap.get(entry.getKey());
                if (DrmEnumDefine.APP_TYPE.NAS_FILESYSTEM.getValue() == appType.intValue()) {
                    processor = this.generateNasSnapshotSubProcessor(recoveryTask, hostOrGroupIds, lunId, srcLunId);
                    createNasSnapshotSubProcessors.add((RecoveryProcessor)processor);
                    continue;
                }
                processor = this.generateSnapshotSubProcessor(recoveryTask, hostOrGroupIds, lunId, srcLunId);
                createSnapshotSubProcessors.add((RecoveryProcessor)processor);
            }
        }
        return true;
    }

    private CreateSnapshotSubProcessor generateSnapshotSubProcessor(RecoveryTask recoveryTask, String hostOrGroupIds, String lunId, String srcLunId) {
        CreateSnapshotSubProcessor processor = new CreateSnapshotSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setReplicationId(recoveryTask.getProtectId());
        processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
        processor.setDeviceId(recoveryTask.getTgtDevcieId());
        processor.setRelationType(recoveryTask.getProtectType());
        processor.setLunId(lunId);
        processor.setSrcLunId(srcLunId);
        processor.setHostOrGroupIds(hostOrGroupIds);
        processor.setIsNeedSave(false);
        processor.setIsNeedCreateDetail(false);
        processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        processor.setSnapshotName(DrmStorageUtil.generateRecoverySnapshotName((String)lunId));
        return processor;
    }

    private CreateNasSnapshotSubProcessor generateNasSnapshotSubProcessor(RecoveryTask recoveryTask, String hostOrGroupIds, String lunId, String srcLunId) {
        CreateNasSnapshotSubProcessor processor = new CreateNasSnapshotSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
        processor.setDeviceId(recoveryTask.getTgtDevcieId());
        processor.setResourceId(lunId);
        processor.setSrcResourceId(srcLunId);
        processor.setHostOrGroupIds(hostOrGroupIds);
        processor.setIsNeedSave(false);
        processor.setIsNeedCreateDetail(false);
        processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        processor.setSnapshotName(DrmStorageUtil.generateRecoverySnapshotName((String)lunId));
        return processor;
    }

    private void deleteFailedSnapShot(RecoveryProcessorContext context, Set<RecoveryProcessor> recoveryProcesses) {
        Set<RecoveryProcessor> deleteSubProcessors = this.getDeleteSubProcessors(recoveryProcesses);
        if (null == deleteSubProcessors) {
            logger.error((Object)"deleteSubProcessors is null!");
            return;
        }
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(deleteSubProcessors));
        if (!VerifyUtil.isEmpty((Object)recoveryTemplate)) {
            recoveryTemplate.process(context);
        }
    }

    private Set<RecoveryProcessor> getDeleteSubProcessors(Set<RecoveryProcessor> recoveryProcesses) {
        if (null == recoveryProcesses || recoveryProcesses.isEmpty()) {
            return null;
        }
        HashSet<RecoveryProcessor> subProcessor = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor process : recoveryProcesses) {
            CreateSnapshotSubProcessor createSnapshotProcessor = (CreateSnapshotSubProcessor)process;
            String snapshotId = createSnapshotProcessor.getSnapshotId();
            if (null == snapshotId || snapshotId.isEmpty()) continue;
            DeleteSnapshotSubProcessor processor = new DeleteSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setLunId(createSnapshotProcessor.getLunId());
            processor.setLunName(createSnapshotProcessor.getLunName());
            processor.setDeviceId(createSnapshotProcessor.getDeviceId());
            processor.setSnapshotId(createSnapshotProcessor.getSnapshotId());
            processor.setSnapshotName(createSnapshotProcessor.getSnapshotName());
            processor.setIsNeedSave(false);
            processor.setIsNeedCreateDetail(false);
            subProcessor.add((RecoveryProcessor)processor);
        }
        return subProcessor;
    }

    private void reCalcCreateSnapshotResult(RecoveryProcessorContext context, CreateSnapshotSubProcessor createSnapSubProcessor, ActiveSnapshotProcessor activeSnapProcessor) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        String key = RecoveryProcessUtil.generateLunAndHostMapKey((String)createSnapSubProcessor.getReplicationId(), (String)createSnapSubProcessor.getSrcDeviceId(), (String)createSnapSubProcessor.getSrcLunId(), (String)createSnapSubProcessor.getDeviceId(), (String)createSnapSubProcessor.getLunId());
        String pgId = activeSnapProcessor.getProtectGroupId(key, recoveryTasks);
        pgId = RecoveryProcessUtil.getProtectGroupIdFromWrapper((String)pgId);
        RecoveryProcessResult processResult = context.getProcessResult();
        String activeKey = RecoveryProcessResult.getActiveSnapshotProcResultKey((String)createSnapSubProcessor.getDeviceId(), (String)pgId);
        boolean result = processResult.getValue(activeKey);
        processResult.addProcessResult(createSnapSubProcessor.getDeviceId(), result);
    }

    public void updateDescription() {
        int poType = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(this.getPlanId()).getProtectGroup().getPoType();
        if (this.getProcType() == 1 && poType == 9) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.BackupTargetDataProcessor.filesystem.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.BackupTargetDataProcessor.des");
        }
    }
}

