/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.ForceSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CheckDataConsistencyProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(CheckDataConsistencyProcessor.class);
    private static final long serialVersionUID = 4151868799955996095L;
    private ConcurrentHashMap<String, List<ReplicationTargetLun>> cgTgtLunsMap = null;
    private List<RecoveryProcessor> swapSubProcessors = new ArrayList<RecoveryProcessor>();

    public CheckDataConsistencyProcessor() {
        this.cgTgtLunsMap = new ConcurrentHashMap();
    }

    public boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)this.getRecoveryTasksKey());
        String disasterSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID"));
        this.rebuildSubProcessors(RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disasterSiteId));
        this.swapSubProcessors.addAll(this.getSwapSubProcessors(context));
        List<? extends IProcessor> groupedProcessors = this.groupingSubProcessors(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(groupedProcessors);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        CheckDataConsistencySubProcessor preProcessor = (CheckDataConsistencySubProcessor)oldProcess;
        CheckDataConsistencySubProcessor newProcessor = (CheckDataConsistencySubProcessor)newProcess;
        return preProcessor.getLunId().equals(newProcessor.getLunId()) && preProcessor.getDeviceId().equals(newProcessor.getDeviceId());
    }

    List<ReplicationTargetLun> getTargetLunsByCgId(String cgId) {
        return this.cgTgtLunsMap.get(cgId);
    }

    void putTargetLuns(String cgId, List<ReplicationTargetLun> targetLuns) {
        this.cgTgtLunsMap.put(cgId, targetLuns);
    }

    List<RecoveryProcessor> getSwapSubProcessors() {
        return this.swapSubProcessors;
    }

    private boolean rebuildSubProcessors(Set<RecoveryTask> recoveryTasks) {
        HashSet<CheckDataConsistencySubProcessor> checkDataConsistencySubProcessors = new HashSet<CheckDataConsistencySubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map lunAndHostMap = recoveryTask.getLunAndHostMap();
            if (null == lunAndHostMap || lunAndHostMap.isEmpty()) continue;
            Set entrySet = lunAndHostMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String lunAndHostMapKey = (String)entry.getKey();
                String lunId = RecoveryProcessUtil.getLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                CheckDataConsistencySubProcessor processor = new CheckDataConsistencySubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setReplicationId(recoveryTask.getProtectId());
                processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
                processor.setDeviceId(recoveryTask.getTgtDevcieId());
                processor.setRelationType(recoveryTask.getProtectType());
                processor.setLunId(lunId);
                processor.setReplicationName(recoveryTask.getProtectName());
                processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
                checkDataConsistencySubProcessors.add(processor);
            }
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(checkDataConsistencySubProcessors);
        } else {
            this.updateSubProcessors(checkDataConsistencySubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private List<RecoveryProcessor> getSwapSubProcessors(RecoveryProcessorContext context) {
        Class cls = null;
        cls = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() ? SwapReplicationSubProcessor.class : ForceSwapReplicationSubProcessor.class;
        List recoveryProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType()), cls);
        return recoveryProcessors;
    }

    private List<? extends IProcessor> groupingSubProcessors(Set<RecoveryProcessor> subProcessors) {
        if (VerifyUtil.isEmpty(subProcessors)) {
            logger.error((Object)"The sub processors is empty.", 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        HashMap<String, ArrayList<CheckDataConsistencySubProcessor>> groupedProcessors = new HashMap<String, ArrayList<CheckDataConsistencySubProcessor>>();
        for (RecoveryProcessor processor : subProcessors) {
            CheckDataConsistencySubProcessor subProcessor = (CheckDataConsistencySubProcessor)processor;
            boolean isConsistentGroup = ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)subProcessor.getRelationType());
            String groupingKey = subProcessor.getReplicationId() + ":" + isConsistentGroup;
            ArrayList<CheckDataConsistencySubProcessor> groupedSubProcessors = (ArrayList<CheckDataConsistencySubProcessor>)groupedProcessors.get(groupingKey);
            if (null == groupedSubProcessors) {
                groupedSubProcessors = new ArrayList<CheckDataConsistencySubProcessor>();
                groupedProcessors.put(groupingKey, groupedSubProcessors);
            }
            groupedSubProcessors.add(subProcessor);
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        ArrayList<IProcessor> recoveryProcessors = new ArrayList<IProcessor>();
        Set entrySet = groupedProcessors.entrySet();
        for (Map.Entry entry : entrySet) {
            Iterator iterator;
            if (null == entry.getValue() || !(iterator = ((List)entry.getValue()).iterator()).hasNext()) continue;
            IProcessor executor = (IProcessor)iterator.next();
            if (1 < ((List)entry.getValue()).size()) {
                executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((List)((List)entry.getValue()), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)execType);
            }
            recoveryProcessors.add(executor);
        }
        if (recoveryProcessors.isEmpty()) {
            StringBuilder strBuffer = new StringBuilder();
            for (RecoveryProcessor processor : subProcessors) {
                CheckDataConsistencySubProcessor preSubProcessor = (CheckDataConsistencySubProcessor)processor;
                boolean isConsistentGroup = ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)preSubProcessor.getRelationType());
                strBuffer.append("RepId:" + preSubProcessor.getReplicationId() + ",");
                strBuffer.append("IsCG:" + isConsistentGroup + ",");
                strBuffer.append("SrcDevId:" + preSubProcessor.getSrcDeviceId() + ",");
                strBuffer.append("DevId:" + preSubProcessor.getDeviceId() + ";");
            }
            logger.error((Object)("Grouping checking data consistency processors failed. Msg:" + strBuffer.toString()));
        }
        return recoveryProcessors;
    }

    public void updateDescription() {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.des");
        } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.dr.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.test.des");
        }
    }
}

