/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreReplicationPairManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairManager;
import com.huawei.ism.drm.storage.recovery.process.BaseSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckDataConsistencySubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7921173469153533993L;
    private static Log logger = LogFactory.getInstance(CheckDataConsistencySubProcessor.class);
    private String replicationId;
    private String replicationName;
    private String srcDeviceId;
    private Integer relationType;
    private String deviceId;
    private String lunId;
    private String lunName;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getReplicationName() {
        return this.replicationName;
    }

    public void setReplicationName(String replicationName) {
        this.replicationName = replicationName;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public Integer getRelationType() {
        return this.relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getDeviceId(), this.getLunId()});
        if (!this.isNeedRecheck()) {
            this.updateProcessDetail("ism.drm.recovery.replication.already.swapped", new String[]{null == this.replicationName ? this.replicationId : this.replicationName});
            return true;
        }
        ReplicationTargetLun repTargetLun = null;
        try {
            repTargetLun = this.queryReplicationTargetLun(this.deviceId, this.replicationId, this.lunId, this.relationType);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Query replication target lun failed.", (Throwable)e, 90160758784001L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        String[] params = new String[]{this.lunId, this.deviceId, this.replicationId};
        if (null == repTargetLun) {
            this.updateProcessDetail("lego.err.1073948708", params);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        if (this.isContinueByPairStatus(repTargetLun)) {
            return true;
        }
        int dataStatus = repTargetLun.getDataStatus();
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(1);
        status.add(2);
        status.add(XveEuumDefineParent.RUNNING_STATUS_E.CONSISTENT.getValue());
        status.add(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZED.getValue());
        if (!status.contains(dataStatus)) {
            this.updateProcessDetail("lego.err.1073948709", params);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private boolean isContinueByPairStatus(ReplicationTargetLun repTargetLun) {
        int pairStatus = repTargetLun.getPairStatus();
        if (2 == pairStatus || XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() == pairStatus) {
            if (this.isFailoverInVasa()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            this.updateProcessDetail("lego.err.1073948727", new String[]{this.replicationId});
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.equals((Object)type)) {
            ArrayList<Integer> unNormalPairStatus = new ArrayList<Integer>();
            unNormalPairStatus.add(5);
            unNormalPairStatus.add(6);
            unNormalPairStatus.add(XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue());
            unNormalPairStatus.add(XveEuumDefineParent.RUNNING_STATUS_E.INTERRUPTED.getValue());
            if (unNormalPairStatus.contains(pairStatus)) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
        }
        return false;
    }

    private boolean isFailoverInVasa() {
        Boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        return isVasa != false && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.equals((Object)type);
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getDataConsistencyCheckingResultKey((String)this.deviceId, (String)this.lunId);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private ReplicationTargetLun queryReplicationTargetLun(String deviceIdParam, String replicationIdParam, String lunIdParam, int relationTypeParam) {
        boolean isConsistentGroup = ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)relationTypeParam);
        boolean isVstorePair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)relationTypeParam);
        List targetLuns = null;
        if (isConsistentGroup || isVstorePair) {
            targetLuns = ((CheckDataConsistencyProcessor)this.getParentProc()).getTargetLunsByCgId(replicationIdParam);
        }
        if (VerifyUtil.isEmpty(targetLuns)) {
            if (isVstorePair) {
                IStorageVstoreReplicationPairManager vstoreReplicationPairManager = StorageVstoreReplicationPairManagerProxy.getInstance().getMgrByDevId(deviceIdParam);
                targetLuns = vstoreReplicationPairManager.querySyncStatusByVstorePair(deviceIdParam, replicationIdParam, false);
            } else {
                targetLuns = StorageReplicationManagerProxy.getInstance().querySyncStatus(deviceIdParam, deviceIdParam, replicationIdParam, isConsistentGroup);
            }
            if ((isConsistentGroup || isVstorePair) && !VerifyUtil.isEmpty((Collection)targetLuns)) {
                ((CheckDataConsistencyProcessor)this.getParentProc()).putTargetLuns(replicationIdParam, targetLuns);
            }
        }
        ReplicationTargetLun repTargetLun = this.getRepRartetLun(lunIdParam, targetLuns);
        return repTargetLun;
    }

    private ReplicationTargetLun getRepRartetLun(String lunIdParam, List<ReplicationTargetLun> targetLuns) {
        ReplicationTargetLun repTargetLun = null;
        if (VerifyUtil.isEmpty(targetLuns)) {
            return null;
        }
        for (ReplicationTargetLun targetLun : targetLuns) {
            if (!targetLun.getTgtLunId().equals(lunIdParam)) continue;
            repTargetLun = targetLun;
            break;
        }
        return repTargetLun;
    }

    private boolean isNeedRecheck() {
        boolean isSwapped;
        boolean isNeedRecheck = true;
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus() && (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) && (isSwapped = this.isSwappedSuccess())) {
            isNeedRecheck = false;
        }
        return isNeedRecheck;
    }

    private boolean isSwappedSuccess() {
        CheckDataConsistencyProcessor checkDataConsistencyProcessor = (CheckDataConsistencyProcessor)this.getParentProc();
        List<RecoveryProcessor> recoveryProcessors = checkDataConsistencyProcessor.getSwapSubProcessors();
        if (VerifyUtil.isEmpty(recoveryProcessors)) {
            return false;
        }
        boolean result = false;
        for (RecoveryProcessor process : recoveryProcessors) {
            String curSwapKey;
            BaseSwapReplicationSubProcessor processor = (BaseSwapReplicationSubProcessor)process;
            String swapKey = RecoveryProcessResult.getSwapProcessResultKey((String)processor.getReplicationId(), (String)processor.getSrcDeviceId(), (String)processor.getTgtDeviceId(), (int)processor.getRelationType());
            if (!swapKey.equals(curSwapKey = RecoveryProcessResult.getSwapProcessResultKey((String)this.replicationId, (String)this.srcDeviceId, (String)this.deviceId, (int)this.relationType)) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != processor.getProcStatus()) continue;
            result = true;
            break;
        }
        return result;
    }
}

