/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class CheckRollbackSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8882528752975196418L;
    private static final Log logger = LogFactory.getInstance(CheckRollbackSnapshotSubProcessor.class);
    private static final int RETRY_TIMES = 5760;
    private static final long SLEEP_TIME = 15000L;
    private static final int DEFAULT_PROCESS = -1;
    private static final String ROLLBACK_SNAPSHOT_RESULT_KEY = "rollbackSnapshotResultKey";
    private static final String ROLLBACK_SUCCESS_STATUS = "0";
    private String deviceId;
    private String lunId;
    private String lunName;
    private String snapshotId;
    private String snapshotName;
    private Integer protectType;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public Integer getProtectType() {
        return this.protectType;
    }

    public void setProtectType(Integer protectType) {
        this.protectType = protectType;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getSnapshotName()});
        String rollbackSnapshotResultKey = RecoveryProcessResult.getRollbackSnapshotResultKey((String)this.deviceId, (String)this.getLunId(), (String)this.getSnapshotId());
        context.setAttribute(ROLLBACK_SNAPSHOT_RESULT_KEY, (Object)rollbackSnapshotResultKey);
        boolean rollbackSnapshotResult = context.getProcessResult().getProcessResult(rollbackSnapshotResultKey);
        if (!rollbackSnapshotResult) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("ism.drm.recovery.mount.skip.error", new String[]{this.getSnapshotName()});
            return true;
        }
        if (this.monitorSnapshotRollback(context)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail("ism.drm.recovery.snapshot.rollback.timeout", new String[]{this.getSnapshotName()});
        return false;
    }

    protected String generateResultKey() {
        return RecoveryProcessResult.getCheckRollbackSnapshotResultKey((String)this.deviceId, (String)this.getLunId(), (String)this.getSnapshotId());
    }

    private boolean monitorSnapshotRollback(RecoveryProcessorContext context) {
        for (int i = 0; i < 5760; ++i) {
            Snapshot snapshot;
            try {
                snapshot = this.getMonitoredSnapshot(context);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Get HyperCDP or snapshot error for: %s, %d", (Throwable)e, new Object[]{this.getRollbackSnapshotResultKey(context), this.getProtectType()});
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948680", null);
                return true;
            }
            if (VerifyUtil.isEmpty((Object)snapshot)) {
                throw new LegoCheckedException(1073947394L);
            }
            if (this.checkRollbackProgress(snapshot, context)) {
                CommUtil.pauseThread((long)2000L);
                logger.info((Object)"Snapshot(%s)'s rollback process is :%s, RetryTimes:%s", new Object[]{this.getSnapshotId(), snapshot.getRestoreProgress(), i});
                return true;
            }
            CommUtil.pauseThread((long)15000L);
        }
        return false;
    }

    private Snapshot getMonitoredSnapshot(RecoveryProcessorContext context) {
        Snapshot snapshot;
        int poType = this.getPoType(context);
        if (poType == 14) {
            StorageFileSystemSnapshotManagerProxy storageManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance();
            IStorageFileSystemSnapshotManager proxy = storageManagerProxy.getStorageFileSystemSnapshotManager(this.deviceId);
            snapshot = proxy.querySpecificSnapshot(this.deviceId, this.getLunId(), this.getSnapshotId());
        } else if (this.getProtectType().intValue() == ReplicationConstantDefine.LocalTaskType.HYPERCDP.getValue()) {
            IStorageHyperCDPManager hyperCDPManager = StorageHyperCDPManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.deviceId);
            snapshot = hyperCDPManager.getHyperCDPById(this.deviceId, this.getSnapshotId());
        } else {
            Snapshot paramSnapshot = new Snapshot();
            paramSnapshot.setId(this.getSnapshotId());
            List snapshots = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.deviceId).getSnapshot(this.deviceId, paramSnapshot);
            if (VerifyUtil.isEmpty((Collection)snapshots)) {
                logger.error((Object)"Get snapshot error for: %s", new Object[]{this.getRollbackSnapshotResultKey(context)});
                throw new LegoCheckedException(1073947394L);
            }
            snapshot = (Snapshot)CommonUtil.getFirstElement((Collection)snapshots);
        }
        return snapshot;
    }

    private boolean checkRollbackProgress(Snapshot snapshot, RecoveryProcessorContext context) {
        int pgTemplateType = this.getPgTemplateType(context);
        if (PolicyTemplateType.isNasAirGapNetworking((int)pgTemplateType)) {
            return this.checkNasSnapshotRollbackProgress(snapshot, context);
        }
        return this.checkLunSnapshotRollbackProgress(snapshot);
    }

    private boolean checkLunSnapshotRollbackProgress(Snapshot snapshot) {
        boolean progress = null != snapshot.getRestoreProgress() && (snapshot.getRestoreProgress() >= 100 || snapshot.getRestoreProgress() == -1);
        boolean activeStatus = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.ACTIVATED.getValue()).equals(snapshot.getRunningState());
        return progress && activeStatus;
    }

    private boolean checkNasSnapshotRollbackProgress(Snapshot snapshot, RecoveryProcessorContext context) {
        boolean isCompleted;
        int progress = Optional.ofNullable(snapshot.getRestoreProgress()).orElse(0);
        boolean bl = isCompleted = progress >= 100 || progress == 0;
        if (!isCompleted) {
            return false;
        }
        long utcTimeStamp = snapshot.getUtcTimeStamp();
        long rollbackEndTime = snapshot.getRollbackEndTime();
        long lastRollBackEndTime = (Long)context.getSnapshotLastRollBackTimeMap().get(this.snapshotId);
        String rollbackStatus = snapshot.getRollbackStatus();
        return rollbackEndTime > utcTimeStamp && rollbackEndTime > lastRollBackEndTime && ROLLBACK_SUCCESS_STATUS.equals(rollbackStatus);
    }

    private String getRollbackSnapshotResultKey(RecoveryProcessorContext context) {
        Object rollbackSnapshotResultKey = context.getAttribute(ROLLBACK_SNAPSHOT_RESULT_KEY);
        if (rollbackSnapshotResultKey instanceof String) {
            return (String)rollbackSnapshotResultKey;
        }
        return "";
    }

    private int getPoType(RecoveryProcessorContext context) {
        Integer poType = Optional.ofNullable(context.getProtectGroup()).map(ProtectGroup::getPoType).orElse(null);
        if (VerifyUtil.isEmpty((Object)poType)) {
            logger.error((Object)"The protection object type in the protection group is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        return poType;
    }

    private int getPgTemplateType(RecoveryProcessorContext context) {
        Integer templateType = Optional.ofNullable(context.getProtectGroup()).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).orElse(null);
        if (VerifyUtil.isEmpty((Object)templateType)) {
            logger.error((Object)"The protection object type in the protection group is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        return templateType;
    }
}

