/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.CreateNasSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteNasSnapshotSubProcessor;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateNasSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6513486070335875829L;
    private static final Log logger = LogFactory.getInstance(CreateNasSnapshotProcessor.class);
    private static final String SNAPSHOT_ID = "SnapshotId";
    private static final String SNAPSHOT_NAME = "SnapshotName";
    private static final String RESOURCE_ID = "ResourceId";
    private static final String RESOURCE_NAME = "ResourceName";
    private static final String DEVICE_ID = "DeviceId";
    private String snapShotInfos;

    public String getSnapShotInfos() {
        return this.snapShotInfos;
    }

    public void setSnapShotInfos(String snapShotInfos) {
        this.snapShotInfos = snapShotInfos;
    }

    public boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        String disasterSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID"));
        HashSet<RecoveryProcessor> createNasSnapshotSubProcessor = new HashSet<RecoveryProcessor>();
        this.updateSubProcessors(RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disasterSiteId), createNasSnapshotSubProcessor);
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(createNasSnapshotSubProcessor));
        recoveryTemplate.process(context);
        boolean result = true;
        HashSet<RecoveryProcessor> successProcessors = new HashSet<RecoveryProcessor>();
        JSONArray resultArray = new JSONArray();
        for (RecoveryProcessor process : createNasSnapshotSubProcessor) {
            CreateNasSnapshotSubProcessor processor;
            if (process.getProcStatus() != DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue()) {
                result = false;
            } else {
                successProcessors.add(process);
            }
            if (VerifyUtil.isEmpty((String)(processor = (CreateNasSnapshotSubProcessor)process).getSnapshotId())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)SNAPSHOT_ID, (Object)processor.getSnapshotId());
            jsonObject.put((Object)RESOURCE_ID, (Object)processor.getResourceId());
            jsonObject.put((Object)RESOURCE_NAME, (Object)processor.getResourceName());
            jsonObject.put((Object)DEVICE_ID, (Object)processor.getDeviceId());
            jsonObject.put((Object)SNAPSHOT_NAME, (Object)processor.getSnapshotName());
            resultArray.add((Object)jsonObject);
        }
        this.setSnapShotInfos(resultArray.toString());
        if (!result) {
            this.deleteFailedSnapShot(context, type, successProcessors);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(createNasSnapshotSubProcessor);
        this.setProcStatus(procStatus.getValue());
        return true;
    }

    private void deleteFailedSnapShot(RecoveryProcessorContext context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, Set<RecoveryProcessor> recoveryProcesses) {
        try {
            Set<RecoveryProcessor> subProcessors = this.getDeleteSubProcessors(recoveryProcesses);
            RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
            if (!VerifyUtil.isEmpty((Object)recoveryTemplate)) {
                recoveryTemplate.process(context);
            }
        }
        catch (Exception e) {
            logger.error((Object)("deleteFailedSnapShot failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private Set<RecoveryProcessor> getDeleteSubProcessors(Set<RecoveryProcessor> recoveryProcesses) {
        if (null == recoveryProcesses || recoveryProcesses.isEmpty()) {
            return null;
        }
        HashSet<RecoveryProcessor> subProcessor = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor process : recoveryProcesses) {
            CreateNasSnapshotSubProcessor createSnapshotProcessor = (CreateNasSnapshotSubProcessor)process;
            String snapshotId = createSnapshotProcessor.getSnapshotId();
            if (null == snapshotId || snapshotId.isEmpty()) continue;
            DeleteNasSnapshotSubProcessor processor = new DeleteNasSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setResourceId(createSnapshotProcessor.getResourceId());
            processor.setResourceName(createSnapshotProcessor.getResourceName());
            processor.setDeviceId(createSnapshotProcessor.getDeviceId());
            processor.setSnapshotId(createSnapshotProcessor.getSnapshotId());
            processor.setSnapshotName(createSnapshotProcessor.getSnapshotName());
            processor.setIsNeedSave(false);
            processor.setIsNeedCreateDetail(false);
            subProcessor.add((RecoveryProcessor)processor);
        }
        return subProcessor;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        CreateSnapshotSubProcessor preProcessor = (CreateSnapshotSubProcessor)oldProcess;
        CreateSnapshotSubProcessor newProcessor = (CreateSnapshotSubProcessor)newProcess;
        return preProcessor.getLunId().equals(newProcessor.getLunId()) && preProcessor.getDeviceId().equals(newProcessor.getDeviceId());
    }

    protected void updateProcessorData(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return;
        }
        CreateSnapshotSubProcessor preProcessor = (CreateSnapshotSubProcessor)oldProcess;
        CreateSnapshotSubProcessor newProcessor = (CreateSnapshotSubProcessor)newProcess;
        preProcessor.setHostOrGroupIds(newProcessor.getHostOrGroupIds());
    }

    private boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks, Set<RecoveryProcessor> createNasSnapshotSubProcessor) {
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map lunAndHostMap = recoveryTask.getLunAndHostMap();
            if (null == lunAndHostMap || lunAndHostMap.isEmpty()) continue;
            Set entrySet = lunAndHostMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String lunAndHostMapKey = (String)entry.getKey();
                String lunId = RecoveryProcessUtil.getLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                String srcLunId = RecoveryProcessUtil.getSrcLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                CreateNasSnapshotSubProcessor processor = new CreateNasSnapshotSubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
                processor.setDeviceId(recoveryTask.getTgtDevcieId());
                processor.setResourceId(lunId);
                processor.setSrcResourceId(srcLunId);
                processor.setHostOrGroupIds(RecoveryProcessUtil.getHostOrGroupIds((List)((List)entry.getValue())));
                processor.setIsNeedSave(false);
                processor.setIsNeedCreateDetail(false);
                processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
                processor.setSnapshotName(DrmStorageUtil.generateRecoverySnapshotName((String)lunId));
                createNasSnapshotSubProcessor.add((RecoveryProcessor)processor);
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

