/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotGroupManager;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;

public class CreateSnapshotCgCopySubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6601077027821310024L;
    private String deviceId;
    private String srcCgGroupID;
    private int protectType;
    private String cgGroupID;

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        IStorageSnapshotGroupManager storageSnapshotGroupManager = StorageSnapshotGroupManagerProxy.getInstance().getStorageSnapshotGroupMgrByDevId(this.getDeviceId());
        String cgName = "CopyFrom_" + this.getSrcCgGroupID() + "_" + System.currentTimeMillis();
        this.updateProcessNameParams(new String[]{this.getSrcCgGroupID(), cgName});
        if (this.protectType == ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue()) {
            SnapshotConsistentGroup snapshotConsistentGroup = storageSnapshotGroupManager.copy(this.getDeviceId(), cgName, this.getSrcCgGroupID());
            this.setCgGroupID(snapshotConsistentGroup.getId());
        } else if (this.protectType == ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue()) {
            SnapshotConsistentGroup snapshotConsistentGroup = storageSnapshotGroupManager.copyFromHyperCDP(this.getDeviceId(), cgName, this.getSrcCgGroupID());
            this.setCgGroupID(snapshotConsistentGroup.getId());
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSrcCgGroupID() {
        return this.srcCgGroupID;
    }

    public void setSrcCgGroupID(String srcCgGroupID) {
        this.srcCgGroupID = srcCgGroupID;
    }

    public int getProtectType() {
        return this.protectType;
    }

    public void setProtectType(int protectType) {
        this.protectType = protectType;
    }

    public String getCgGroupID() {
        return this.cgGroupID;
    }

    public void setCgGroupID(String cgGroupID) {
        this.cgGroupID = cgGroupID;
    }
}

