/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotHandler;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class CreateSnapshotCopySubProcessor
extends BaseRecoveryProcessor
implements ICreateSnapshotHandler {
    private static final long serialVersionUID = -6601077027821310024L;
    private static final Log logger = LogFactory.getInstance(CreateSnapshotCopySubProcessor.class);
    private String deviceId;
    private String snapshotId = null;
    private String lunId = null;
    private String snapshotWWN = null;
    private String snapshotName = null;
    private String srcSnapshotId = null;
    private String hostOrGroupIds;

    @Override
    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setSnapshotWWN(String snapshotWWN) {
        this.snapshotWWN = snapshotWWN;
    }

    @Override
    public String getSnapshotWWN() {
        return this.snapshotWWN;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public void setHostOrGroupIds(String hostOrGroupIds) {
        this.hostOrGroupIds = hostOrGroupIds;
    }

    public String getHostOrGroupIds() {
        return this.hostOrGroupIds;
    }

    public String getSrcSnapshotId() {
        return this.srcSnapshotId;
    }

    public void setSrcSnapshotId(String srcSnapshotId) {
        this.srcSnapshotId = srcSnapshotId;
    }

    public boolean execute(RecoveryProcessorContext context) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        if (null == this.getSnapshotName()) {
            this.setSnapshotName(this.generateSnapshotName());
        }
        this.updateProcessNameParams(new String[]{this.getSrcSnapshotId(), this.getSnapshotName()});
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        Snapshot paramSnapshot = new Snapshot();
        if (!VerifyUtil.isEmpty((String)this.getSnapshotId())) {
            paramSnapshot.setId(this.getSnapshotId());
        }
        paramSnapshot.setSnapshotName(this.getSnapshotName());
        if (VerifyUtil.isEmpty((String)this.getSnapshotId()) || !proxy.isSnapshotExist(this.getDeviceId(), paramSnapshot)) {
            try {
                long startTime = System.currentTimeMillis();
                Snapshot newSnapshot = proxy.copySnapshot(this.getDeviceId(), this.getSrcSnapshotId(), this.getSnapshotName(), false);
                logger.debug((Object)("copySnapshot cost time:" + (System.currentTimeMillis() - startTime)));
                if (null == newSnapshot) {
                    logger.error((Object)("Creating snapshot failed. DevSN:" + this.getDeviceId() + ",Name:" + this.getSnapshotName() + ",LunId:" + this.getSrcSnapshotId()), 90160758784001L);
                    throw new LegoCheckedException(1073948680L);
                }
                this.setSnapshotId(String.valueOf(newSnapshot.getSnapshotId()));
                this.setSnapshotWWN(newSnapshot.getWwn());
                context.setAttribute(RecoveryProcessResult.getCopySnapshotProcResultkey((String)this.getDeviceId(), (String)this.getLunId()), (Object)newSnapshot.getWwn());
                if (this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() && FusionStorageUnit.class.getName().equals(deviceType)) {
                    logger.info((Object)("create fsb copy snapshot id: " + newSnapshot.getSnapshotId() + ", wwn: " + newSnapshot.getWwn() + ", SrcResourceId: " + newSnapshot.getSrcResourceId()));
                    RecoveryProcessUtil.addContextParam((RecoveryProcessorContext)context, (String)"SnapshotCopyInfos", (String)(this.getLunId() + "-" + newSnapshot.getSnapshotId() + "-" + newSnapshot.getWwn()));
                } else {
                    List snpList = proxy.getSnapshot(this.getDeviceId(), newSnapshot);
                    if (!snpList.isEmpty()) {
                        Snapshot snp = (Snapshot)snpList.get(0);
                        logger.info((Object)("create copy snapshot id: " + snp.getSnapshotId() + ", wwn: " + snp.getWwn() + ", SrcResourceId: " + snp.getSrcResourceId()));
                        RecoveryProcessUtil.addContextParam((RecoveryProcessorContext)context, (String)"SnapshotCopyInfos", (String)(snp.getSrcResourceId() + "-" + snp.getSnapshotId() + "-" + snp.getWwn()));
                    }
                }
            }
            catch (LegoCheckedException e) {
                this.updateProcessDetail(e.getErrorMessageKey(), new String[]{this.getSnapshotName()});
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                return true;
            }
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getCreateSnapshotProcResultKey((String)this.getDeviceId(), (String)this.getLunId());
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private String generateSnapshotName() {
        StringBuilder builder = new StringBuilder();
        builder.append("DRdata_");
        builder.append(this.getLunId());
        builder.append("_");
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
        String time = df.format(new Date());
        builder.append(time);
        builder.append(UUID.randomUUID().toString(), 0, 2);
        builder.append("_BAK");
        return builder.toString();
    }
}

