/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.ActiveSnapshotProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotController;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateSnapshotProcessor
extends BaseRecoveryProcessor
implements ICreateSnapshotController {
    private static final long serialVersionUID = 4151868799955996095L;
    private static final Log LOGGER = LogFactory.getInstance(CreateSnapshotProcessor.class);

    public void endRecoveryProcessor() {
        this.saveSnapshot(this.getContextRef(), this.getChildProc());
        super.endRecoveryProcessor();
    }

    public boolean execute(RecoveryProcessorContext context) {
        String disasterSiteId;
        Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)this.getRecoveryTasksKey());
        boolean isSuccess = this.rebuildSubProcessors(RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)(disasterSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID")))));
        if (!isSuccess) {
            LOGGER.error((Object)"Rebuild sub processor failed.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        Set createSnapshotSubProcessors = this.getChildProc();
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(createSnapshotSubProcessors));
        recoveryTemplate.process(context);
        ActiveSnapshotProcessor activeSnapProc = new ActiveSnapshotProcessor();
        activeSnapProc.setProcName(activeSnapProc.getName());
        activeSnapProc.setProcType(this.getProcType());
        activeSnapProc.setPlanId(this.getPlanId());
        activeSnapProc.setProcessId(this.getProcessId());
        activeSnapProc.setParentProc((RecoveryProcessor)this);
        activeSnapProc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        activeSnapProc.setCreateSnapshotSubProcessors(createSnapshotSubProcessors);
        activeSnapProc.process(context);
        HashMap<String, String> subProcessors = new HashMap<String, String>();
        context.setAttribute("CreateSnapshotSubProcessors", subProcessors);
        for (RecoveryProcessor process : createSnapshotSubProcessors) {
            CreateSnapshotSubProcessor processor = (CreateSnapshotSubProcessor)process;
            String value = processor.getSnapshotId() + ";" + processor.getSnapshotName() + ";" + processor.getSnapshotWWN() + ";" + processor.getHostOrGroupIds();
            subProcessors.put(processor.generateResultKey(), value);
            this.reCalcCreateSnapshotResult(context, (CreateSnapshotSubProcessor)process, activeSnapProc);
        }
        return this.reCalcProcessResult(activeSnapProc);
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return this.getClass().getName();
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        CreateSnapshotSubProcessor preProcessor = (CreateSnapshotSubProcessor)oldProcess;
        CreateSnapshotSubProcessor newProcessor = (CreateSnapshotSubProcessor)newProcess;
        return preProcessor.getLunId().equals(newProcessor.getLunId()) && preProcessor.getDeviceId().equals(newProcessor.getDeviceId());
    }

    protected void updateProcessorData(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (oldProcess == null || newProcess == null) {
            LOGGER.error((Object)"The oldProcess or newProcess is null.");
            return;
        }
        CreateSnapshotSubProcessor preProcessor = (CreateSnapshotSubProcessor)oldProcess;
        CreateSnapshotSubProcessor newProcessor = (CreateSnapshotSubProcessor)newProcess;
        preProcessor.setHostOrGroupIds(newProcessor.getHostOrGroupIds());
    }

    protected boolean rebuildSubProcessors(Set<RecoveryTask> recoveryTasks) {
        HashSet<CreateSnapshotSubProcessor> createSnapshotSubProcessors = new HashSet<CreateSnapshotSubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map lunAndHostMap = recoveryTask.getLunAndHostMap();
            if (lunAndHostMap == null || lunAndHostMap.isEmpty()) continue;
            Set entrySet = lunAndHostMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String lunAndHostMapKey = (String)entry.getKey();
                String lunId = RecoveryProcessUtil.getLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                String srcLunId = RecoveryProcessUtil.getSrcLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                CreateSnapshotSubProcessor processor = new CreateSnapshotSubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setReplicationId(recoveryTask.getProtectId());
                processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
                processor.setDeviceId(recoveryTask.getTgtDevcieId());
                processor.setRelationType(recoveryTask.getProtectType());
                processor.setLunId(lunId);
                processor.setSrcLunId(srcLunId);
                processor.setHostOrGroupIds(RecoveryProcessUtil.getHostOrGroupIds((List)((List)entry.getValue())));
                processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
                processor.setSnapshotName(DrmStorageUtil.generateRecoverySnapshotName((String)lunId));
                createSnapshotSubProcessors.add(processor);
            }
        }
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            this.setChildProc(createSnapshotSubProcessors);
        } else {
            this.updateSubProcessors(createSnapshotSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private boolean reCalcProcessResult(ActiveSnapshotProcessor activeSnapProc) {
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(activeSnapProc.getProcStatus());
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        return true;
    }

    private void reCalcCreateSnapshotResult(RecoveryProcessorContext context, CreateSnapshotSubProcessor createSnapSubProcessor, ActiveSnapshotProcessor activeSnapProcessor) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        String key = RecoveryProcessUtil.generateLunAndHostMapKey((String)createSnapSubProcessor.getReplicationId(), (String)createSnapSubProcessor.getSrcDeviceId(), (String)createSnapSubProcessor.getSrcLunId(), (String)createSnapSubProcessor.getDeviceId(), (String)createSnapSubProcessor.getLunId());
        String pgId = activeSnapProcessor.getProtectGroupId(key, recoveryTasks);
        pgId = RecoveryProcessUtil.getProtectGroupIdFromWrapper((String)pgId);
        RecoveryProcessResult processResult = context.getProcessResult();
        String activeKey = RecoveryProcessResult.getActiveSnapshotProcResultKey((String)createSnapSubProcessor.getDeviceId(), (String)pgId);
        boolean result = processResult.getValue(activeKey);
        processResult.addProcessResult(createSnapSubProcessor.getDeviceId(), result);
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.CreateSnapshotProcessor.des");
    }
}

