/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotGroupManager;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class DeleteSnapshotCgCopySubProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(DeleteSnapshotCgCopySubProcessor.class);
    private static final long serialVersionUID = -6601077027821310024L;
    private String deviceId;
    private int protectType;
    private String cgGroupID;
    private String srcCgGroupID;

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        this.updateProcessNameParams(new String[]{this.getCgGroupID()});
        IStorageSnapshotGroupManager storageSnapshotGroupManager = StorageSnapshotGroupManagerProxy.getInstance().getStorageSnapshotGroupMgrByDevId(this.getDeviceId());
        SnapshotConsistentGroup snapshotCg = storageSnapshotGroupManager.query(this.getDeviceId(), this.getCgGroupID());
        if (snapshotCg == null) {
            logger.warn((Object)"snapshot cg id does not exist: snapshotCgId=%s", new Object[]{this.getCgGroupID()});
            this.updateProcessDetail("lego.err.1073748837", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        storageSnapshotGroupManager.delete(this.getDeviceId(), this.getCgGroupID());
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public int getProtectType() {
        return this.protectType;
    }

    public void setProtectType(int protectType) {
        this.protectType = protectType;
    }

    public String getCgGroupID() {
        return this.cgGroupID;
    }

    public void setCgGroupID(String cgGroupID) {
        this.cgGroupID = cgGroupID;
    }

    public String getSrcCgGroupID() {
        return this.srcCgGroupID;
    }

    public void setSrcCgGroupID(String srcCgGroupID) {
        this.srcCgGroupID = srcCgGroupID;
    }
}

