/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefreshStorageProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.ism.drm.storage.recovery.process.ReprotectSynchronizeManager;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationSubProcessor;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.util.Pair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReprotectSynchronizeReplicationProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = 6208196909475066092L;
    private static final Log logger = LogFactory.getInstance(ReprotectSynchronizeReplicationProcessor.class);

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        if (pg.getTemplate().getType() == 47 && this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Begin to synchronize reprotect replication.", 90160758786816L);
        Set<RecoveryProcessor> subProcessors = this.createSyncSubProcessorsWithRetry(context);
        if (VerifyUtil.isEmpty(subProcessors)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948762", new String[0]);
            return false;
        }
        this.setHasChildProc(true);
        this.setChildProc(subProcessors);
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        concurrentExecutor.process(context);
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(subProcessors);
        this.setProcStatus(procStatus.getValue());
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != this.getProcStatus()) {
            return false;
        }
        if (!this.afterSync(context)) {
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    protected boolean afterSync(RecoveryProcessorContext context) {
        Set protectGroups = context.getRecoveryPlan().getProtectGroups();
        String[] pgIds = RecoveryProcessUtil.getProtectGroupIds((Set)protectGroups);
        boolean result = RecoveryProcessUtil.changeProtectGroupStatus((String[])pgIds, (DrmEnumDefine.PROTECT_GROUP_STATUS)DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL);
        if (!result) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.-1", new String[0]);
            return false;
        }
        IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
        reprotectService.sendReprotectSuccessMsg(context.getRecoveryPlan());
        return true;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        if (!(oldProcess instanceof SyncReplicationSubProcessor) || !(newProcess instanceof SyncReplicationSubProcessor)) {
            return oldProcess.getClass() == newProcess.getClass();
        }
        SyncReplicationSubProcessor preProcessor = (SyncReplicationSubProcessor)oldProcess;
        SyncReplicationSubProcessor newProcessor = (SyncReplicationSubProcessor)newProcess;
        return preProcessor.getReplicationId().equals(newProcessor.getReplicationId()) && preProcessor.getSrcDeviceId().equals(newProcessor.getSrcDeviceId()) && preProcessor.getTgtDeviceId().equals(newProcessor.getTgtDeviceId()) && preProcessor.getRelationType().equals(newProcessor.getRelationType());
    }

    protected Set<RecoveryProcessor> createSyncSubProcessorsWithRetry(RecoveryProcessorContext context) {
        Set<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (int retryTimes = 2; 0 < retryTimes; --retryTimes) {
            try {
                DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
                subProcessors = new ReprotectSynchronizeManager((RecoveryProcessor)this).createSyncReplicationProcessors(this.getPlanId(), type, this.isNeedReverse(context));
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("Creating sub processors failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            if (!subProcessors.isEmpty()) break;
            RefreshStorageProcessor refreshStorageProcessor = new RefreshStorageProcessor((RecoveryProcessor)this);
            refreshStorageProcessor.setIsNeedCreateDetail(Boolean.valueOf(false));
            refreshStorageProcessor.process(context);
        }
        this.setCurrentSrcAndTgtDev(subProcessors, context);
        return subProcessors;
    }

    private void setCurrentSrcAndTgtDev(Set<RecoveryProcessor> subProcessors, RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty(subProcessors)) {
            return;
        }
        for (RecoveryProcessor subProcessor : subProcessors) {
            if (!(subProcessor instanceof SyncReplicationSubProcessor)) continue;
            SyncReplicationSubProcessor syncReplicationSubProcessor = (SyncReplicationSubProcessor)subProcessor;
            String srcDeviceId = syncReplicationSubProcessor.getSrcDeviceId();
            String tgtDeviceId = syncReplicationSubProcessor.getTgtDeviceId();
            Pair currentSrcAndTgtDeviceSN = RecoveryUtil.getCurrentSrcAndTgtDeviceSN((String)srcDeviceId, (String)tgtDeviceId, (String)syncReplicationSubProcessor.getReplicationId(), (int)syncReplicationSubProcessor.getRelationType(), (RecoveryProcessorContext)context);
            syncReplicationSubProcessor.setCurrentSrcDeviceSN((String)currentSrcAndTgtDeviceSN.getKey());
            syncReplicationSubProcessor.setCurrentTgtDeviceSN((String)currentSrcAndTgtDeviceSN.getValue());
        }
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor.des");
    }

    protected boolean isNeedReverse(RecoveryProcessorContext context) {
        return false;
    }
}

