/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.recovery.process.BaseRollbackProcessor;
import com.huawei.ism.drm.storage.recovery.process.RollbackBackupProcessor;
import com.huawei.ism.drm.storage.recovery.process.RollbackSnapshotProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class RollbackProcessor
extends BaseRollbackProcessor {
    private static final Log logger = LogFactory.getInstance(RollbackProcessor.class);
    private static final long serialVersionUID = 2734714272438060970L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected void handleSubProcessorByReplica(ProtectGroupReplica replica) {
        if (replica.isStorageSnapshotReplica()) {
            logger.debug((Object)"start snapshot rollback process");
            this.updateSubProcessors((RecoveryProcessor)new RollbackSnapshotProcessor());
        } else if (replica.isBackUpReplica()) {
            logger.debug((Object)"start backup rollback process");
            this.updateSubProcessors((RecoveryProcessor)new RollbackBackupProcessor());
        } else {
            logger.error((Object)("not supported replication type. replicaId:" + replica.getId() + " replicaType:" + replica.getType()));
            throw new LegoCheckedException(1073947393L);
        }
    }
}

