/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.recovery.process.SwapHyperMetroPairSubProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class SwapBackHyperMetroPairSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6974596147886692441L;
    private static final Log logger = LogFactory.getInstance(SwapHyperMetroPairSubProcessor.class);
    private String deviceId;
    private String pairId;
    private Integer resourceType;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getPairId() {
        return this.pairId;
    }

    public void setPairId(String pairId) {
        this.pairId = pairId;
    }

    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getPairId()});
        return this.swapBackHyperMetroPair();
    }

    protected String generateResultKey() {
        return this.getSwapBackHyperMetroPairResultKey();
    }

    private boolean swapBackHyperMetroPair() {
        try {
            IStorageHyperMetroManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(this.getDeviceId());
            manager.swap(this.getDeviceId(), this.getPairId(), this.getResourceType(), false);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Swap HyperMetro pair failed. PairId:" + this.getPairId() + " ,DevSN:" + this.getDeviceId()), (Throwable)e, 90160758784001L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Swap HyperMetro pair failed. PairId:" + this.getPairId() + " ,DevSN:" + this.getDeviceId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.updateProcessDetail("lego.err.1073948757", new String[]{this.getPairId()});
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
    }

    private String getSwapBackHyperMetroPairResultKey() {
        StringBuilder builder = new StringBuilder();
        builder.append("SwapBackHyperMetroPair:");
        builder.append("DeviceId=");
        builder.append(this.getDeviceId());
        builder.append(";");
        builder.append("PairId=");
        builder.append(this.getPairId());
        return builder.toString();
    }
}

