/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SwapNasWorkSiteProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 2852529149721999493L;
    private static final Log logger = LogFactory.getInstance(SwapNasWorkSiteProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Enter into SwapNasWorkSiteProcessor");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set pgs = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)pgs);
        String vStorePairId = (String)pg.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        if (VerifyUtil.isEmpty((String)vStorePairId)) {
            logger.error((Object)"vStoreId is null");
            throw new LegoCheckedException(1073947393L);
        }
        String deviceSn = this.randomAProtectObjectStorageInfo(pg).getResourceProviderSN();
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            logger.error((Object)"The device SNs does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(deviceSn, vStorePairId);
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            logger.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        Integer runningStatus = null;
        Integer configStatus = null;
        try {
            runningStatus = Integer.valueOf(vstoreHyperMetroPair.getRunningStatus());
            configStatus = Integer.valueOf(vstoreHyperMetroPair.getConfigStatus());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("VstoreHyperMetroPair runningStatus or configStatus is not ok! runningStatus[" + vstoreHyperMetroPair.getRunningStatus() + "],configStatus[" + vstoreHyperMetroPair.getConfigStatus() + "]."), 1073948223L);
            this.updateProcessDetail("lego.err.1073948223", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() != runningStatus.intValue() || 0 != configStatus) {
            logger.error((Object)("VstoreHyperMetroPair runningStatus or configStatus is not ok! runningStatus[" + runningStatus + "],configStatus[" + configStatus + "]."), 1073948754L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948754", null);
            return false;
        }
        if (!this.checkNasHyperPair(vstoreHyperMetroPair, deviceSn, pg.getPolist())) {
            logger.error((Object)"HyperMetroPair is not ok!");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948191", null);
            return false;
        }
        try {
            ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).swapVstoreHyperMetroPair(deviceSn, vstoreHyperMetroPair.getVstorePairId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("SwapNasWorkSiteProcessor failed: " + (Object)((Object)e)));
            this.updateProcessDetail(e.getErrorMessageKey(), null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private boolean checkNasHyperPair(VstoreHyperMetroPair vstoreHyperMetroPair, String devSN, Set<ProtectObject> protectObjects) {
        logger.info((Object)"checkNasHyperPair");
        String vstoreId = vstoreHyperMetroPair.getLocalVstoreId();
        List<HyperMetroPair> pairList = this.getNasHyperMetroPairs(devSN, vstoreHyperMetroPair, vstoreId);
        List vstoreNasList = StorageResourceServiceRouter.getInstance().getFileSystemByVstore(devSN, vstoreId);
        HashSet<String> vstoreNasIds = new HashSet<String>();
        for (NasFileSystem nasFileSystem : vstoreNasList) {
            vstoreNasIds.add(nasFileSystem.getResourceId());
        }
        if (VerifyUtil.isEmpty(pairList) || pairList.size() != vstoreNasList.size()) {
            logger.error((Object)"pairList is null or the number of resource ids is not equals of the number of pairs!");
            return false;
        }
        for (HyperMetroPair pair : pairList) {
            if (vstoreNasIds.contains(pair.getLocalObjId())) continue;
            logger.error((Object)("The pair don't exist Nas id :" + pair.getLocalObjId()));
            return false;
        }
        Set<String> resourceIds = this.getAllResourceIds(protectObjects);
        for (String nasId : resourceIds) {
            if (vstoreNasIds.contains(nasId)) continue;
            logger.error((Object)("nas system file  in vstore is not equal protectObject files, nasFileId =" + nasId));
            return false;
        }
        return true;
    }

    private Set<String> getAllResourceIds(Set<ProtectObject> protectObjects) {
        logger.debug((Object)"getAllWwn");
        HashSet<String> resourceIds = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                String resourceId = posi.getResourceId();
                if (VerifyUtil.isEmpty((String)resourceId)) {
                    logger.error((Object)("lunWWN or fileSystemId is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                    throw new LegoCheckedException(1073948453L);
                }
                resourceIds.add(resourceId);
            }
        }
        return resourceIds;
    }

    private List<HyperMetroPair> getNasHyperMetroPairs(String devSN, VstoreHyperMetroPair vstoreHyperMetroPair, String vstoreId) {
        List tempList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByVstore(devSN, vstoreId);
        if (VerifyUtil.isEmpty((Collection)tempList)) {
            logger.error((Object)"pairLis is empty", 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<HyperMetroPair> pairList = new ArrayList<HyperMetroPair>();
        String vstorePairId = vstoreHyperMetroPair.getVstorePairId();
        for (HyperMetroPair pair : tempList) {
            if (!vstorePairId.equals(pair.getVstorePairId())) continue;
            pairList.add(pair);
        }
        return pairList;
    }

    private ProtectObjectStorageInfo randomAProtectObjectStorageInfo(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"protectGroup is null");
            throw new LegoCheckedException(1073947393L);
        }
        Set polist = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)polist)) {
            logger.error((Object)("polist is empty! pgName : " + protectGroup.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject po = (ProtectObject)polist.iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty! pgName : " + protectGroup.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName("com.huawei.ism.drm.storage.recovery.process.SwapNasWorkSiteProcessor");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SwapNasWorkSiteProcessor.des");
    }
}

