/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.ReplicationSynchronizedChecker;
import com.huawei.ism.drm.storage.recovery.process.SwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationTask;
import com.huawei.ism.drm.storage.recovery.process.replication.ReplicationOperateSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class SyncReplicationSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 261071631460490535L;
    private static final Log logger = LogFactory.getInstance(SyncReplicationSubProcessor.class);
    private String replicationId;
    private String srcDeviceId;
    private String tgtDeviceId;
    private Integer relationType;
    private String replicationName;
    private String currentSrcDeviceSN = "--";
    private String currentTgtDeviceSN = "--";
    private SyncReplicationSubProcessor associatedSyncSubProcessorForSwap = null;

    public String getReplicationName() {
        return this.replicationName;
    }

    public void setReplicationName(String replicationName) {
        this.replicationName = replicationName;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public String getTgtDeviceId() {
        return this.tgtDeviceId;
    }

    public void setTgtDeviceId(String tgtDeviceId) {
        this.tgtDeviceId = tgtDeviceId;
    }

    public Integer getRelationType() {
        return this.relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public String getCurrentSrcDeviceSN() {
        return this.currentSrcDeviceSN;
    }

    public void setCurrentSrcDeviceSN(String currentSrcDeviceSN) {
        this.currentSrcDeviceSN = currentSrcDeviceSN;
    }

    public String getCurrentTgtDeviceSN() {
        return this.currentTgtDeviceSN;
    }

    public void setCurrentTgtDeviceSN(String currentTgtDeviceSN) {
        this.currentTgtDeviceSN = currentTgtDeviceSN;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.currentSrcDeviceSN, this.currentTgtDeviceSN, this.replicationId});
        if (!this.isNeedResynchronize(context)) {
            this.updateProcessNameParams(new String[]{this.currentSrcDeviceSN, this.currentTgtDeviceSN, this.replicationId});
            String swappedReplicationId = this.replicationId;
            if (null != this.associatedSyncSubProcessorForSwap) {
                swappedReplicationId = this.associatedSyncSubProcessorForSwap.getReplicationId();
            }
            this.updateProcessDetail("ism.drm.recovery.replication.already.swapped", new String[]{swappedReplicationId});
            return true;
        }
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        boolean isVstoreReplicationPair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)this.relationType);
        ReplicationRelation replication = null;
        if (isVstoreReplicationPair) {
            VstoreReplicationPair vstoreReplicationPair = recoveryService.queryVstoreReplicationPair(this.srcDeviceId, this.tgtDeviceId, this.replicationId);
            if (null != vstoreReplicationPair) {
                replication = new ReplicationRelation();
                replication.setRelationType(this.relationType);
                replication.setReplicationName(vstoreReplicationPair.getName());
                replication.setReplicationId(vstoreReplicationPair.getVstorePairId());
                replication.setReplicationMode(Integer.valueOf(2));
            }
        } else {
            replication = recoveryService.queryReplication(this.srcDeviceId, this.tgtDeviceId, this.replicationId, ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)this.relationType));
        }
        if (null == replication) {
            logger.error((Object)("The replication does not exist. DevID:" + this.srcDeviceId + ",RepID:" + this.replicationId), 90160758784000L);
            this.updateProcessNameParams(new String[]{this.currentSrcDeviceSN, this.currentTgtDeviceSN, this.replicationId});
            this.updateProcessDetail("lego.err.1073948677", new String[]{this.replicationId});
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        this.setReplicationName(replication.getReplicationName());
        SyncReplicationTask syncRepTask = new SyncReplicationTask(this);
        syncRepTask.setContext(context);
        syncRepTask.setReplication(replication);
        IRecoveryProcessHandler recoveryProcessHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        ReplicationSynchronizedChecker checker = new ReplicationSynchronizedChecker(recoveryProcessHandler, syncRepTask, this.isNeedWaitSyncResult(context));
        checker.startProcess();
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procResult = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED;
        boolean result = false;
        try {
            result = checker.checkSyncResult();
            if (result) {
                procResult = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Sync replication failed. PairId:" + this.replicationId + " ,SrcDevSN:" + this.srcDeviceId + ", TgtDevSN:" + this.tgtDeviceId + ",Type:" + this.relationType), (Throwable)e, 90160758784001L);
            this.updateProcessDetail(e);
        }
        catch (Exception e) {
            logger.error((Object)("Sync replication failed. PairId:" + this.replicationId + " ,SrcDevSN:" + this.srcDeviceId + ", TgtDevSN:" + this.tgtDeviceId + ",Type:" + this.relationType + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.updateProcessDetail("lego.err.1073948673", new String[0]);
        }
        this.setProcStatus(procResult.getValue());
        return result;
    }

    private boolean isNeedWaitSyncResult(RecoveryProcessorContext context) {
        boolean isWait;
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() != this.getProcType()) {
            logger.debug((Object)"the operation is not reprotect, need wait sync result. ");
            return true;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        if (null == protectGroup) {
            logger.error((Object)"protectGroup is null, need wait sync result.");
            return true;
        }
        PolicyTemplate template = protectGroup.getTemplate();
        if (null == template) {
            logger.error((Object)"PolicyTemplate is null, need wait sync result.");
            return true;
        }
        int type = template.getType();
        if (this.isNeedWaitType(type) && null != this.getNextCascadeProcessor()) {
            logger.debug((Object)"array cascade and next cascade processor is not null, need wait sync result.");
            isWait = true;
        } else {
            isWait = false;
        }
        logger.debug((Object)("is need wait sync result: " + isWait));
        return isWait;
    }

    private boolean isNeedWaitType(int type) {
        return type == 3 || type == 4 || type == 35 || type == 38 || type == 39 || type == 40 || type == 41 || type == 42 || type == 43;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getSyncProcessResultKey((String)this.replicationId, (String)this.srcDeviceId, (String)this.tgtDeviceId, (int)this.relationType);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private boolean isSwappedSuccess(List<RecoveryProcessor> swapSubProcessors, String replicationIdParam, String strDeviceIdParam, String tgtDeviceIdParam, int relationTypeParam) {
        if (VerifyUtil.isEmpty(swapSubProcessors)) {
            return false;
        }
        boolean isSwapped = false;
        for (RecoveryProcessor process : swapSubProcessors) {
            String curSwapKey;
            String swapKey;
            if (process instanceof SwapReplicationSubProcessor) {
                SwapReplicationSubProcessor swapProcessor = (SwapReplicationSubProcessor)process;
                swapKey = RecoveryProcessResult.getSwapProcessResultKey((String)swapProcessor.getReplicationId(), (String)swapProcessor.getSrcDeviceId(), (String)swapProcessor.getTgtDeviceId(), (int)swapProcessor.getRelationType());
            } else if (process instanceof ReplicationOperateSubProcessor) {
                ReplicationOperateSubProcessor operateSubProcessor = (ReplicationOperateSubProcessor)process;
                swapKey = RecoveryProcessResult.getSwapProcessResultKey((String)operateSubProcessor.getReplication(), (String)operateSubProcessor.getSourceDeviceSn(), (String)operateSubProcessor.getTargetDeviceSn(), (int)operateSubProcessor.getRelationType());
            } else {
                logger.error((Object)"Not supported processor: %s", new Object[]{process.getName()});
                throw new LegoCheckedException(1073947393L);
            }
            if (!swapKey.equals(curSwapKey = RecoveryProcessResult.getSwapProcessResultKey((String)replicationIdParam, (String)strDeviceIdParam, (String)tgtDeviceIdParam, (int)relationTypeParam)) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != process.getProcStatus()) continue;
            isSwapped = true;
            break;
        }
        return isSwapped;
    }

    private boolean isNeedResynchronize(RecoveryProcessorContext context) {
        SyncReplicationSubProcessor syncSubProcessor;
        boolean isNeedReSync = true;
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != this.getProcStatus() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() != this.getProcType()) {
            return isNeedReSync;
        }
        List<RecoveryProcessor> swapSubProcessors = this.getSwapRecoveryProcessors(context);
        if (VerifyUtil.isEmpty(swapSubProcessors)) {
            return isNeedReSync;
        }
        boolean isSwapped = false;
        for (syncSubProcessor = this; syncSubProcessor != null && !(isSwapped = this.isSwappedSuccess(swapSubProcessors, syncSubProcessor.getReplicationId(), syncSubProcessor.getSrcDeviceId(), syncSubProcessor.getTgtDeviceId(), syncSubProcessor.getRelationType())) && syncSubProcessor.getNextCascadeProcessor() != null; syncSubProcessor = (SyncReplicationSubProcessor)syncSubProcessor.getNextCascadeProcessor()) {
        }
        if (isSwapped) {
            this.associatedSyncSubProcessorForSwap = syncSubProcessor;
            isNeedReSync = false;
        }
        return isNeedReSync;
    }

    private List<RecoveryProcessor> getSwapRecoveryProcessors(RecoveryProcessorContext context) {
        List recoveryProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType()), SwapReplicationSubProcessor.class);
        if (!VerifyUtil.isEmpty((Collection)recoveryProcessors)) {
            return recoveryProcessors;
        }
        recoveryProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType()), ReplicationOperateSubProcessor.class);
        return recoveryProcessors;
    }
}

