/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.SuspendHyperMetroProcessor;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class SynchronizeAloneHypermetroProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6108106524349615602L;
    private static final Log logger = LogFactory.getInstance(SynchronizeAloneHypermetroProcessor.class);
    private static final String ID = "id";
    private static final String RUNNING_STATUS = "runningStatus";
    private static final String DEV_SN = "devSn";
    private static final String NO_PROCESS_EXCUTE = "ism.drm.recovery.process.no.need";

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Enter into SynchronizeAloneHypermetroProcessor");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED.getValue() == recoveryPlan.getLastTestStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            this.updateProcessDetail(NO_PROCESS_EXCUTE, null);
            return true;
        }
        Set pgs = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)pgs);
        HashMap<String, String> hyperMetroInfo = new HashMap<String, String>();
        boolean isCg = true;
        try {
            isCg = SuspendHyperMetroProcessor.isHyperMetroCg(pg, hyperMetroInfo);
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947393", null);
            return false;
        }
        String runningStatus = (String)hyperMetroInfo.get(RUNNING_STATUS);
        Integer status = null;
        try {
            status = Integer.valueOf(runningStatus);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("The consistent group running status is not ok! running status[" + runningStatus + "]."), 1073948223L);
            this.updateProcessDetail("lego.err.1073948223", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == status.intValue()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        if (XveEuumDefineParent.RUNNING_STATUS_E.PAUSE.getValue() != status.intValue()) {
            logger.error((Object)("The consistent group running status is not ok! running status[" + status + "]."), 1073948754L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948754", null);
            return false;
        }
        try {
            ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).synchronize((String)hyperMetroInfo.get(DEV_SN), (String)hyperMetroInfo.get(ID), isCg, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("SynchronizeAloneHypermetroProcessor failed: " + (Object)((Object)e)));
            this.updateProcessDetail("lego.err.1073948758", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName("com.huawei.ism.drm.storage.recovery.process.SynchronizeHyperMetroProcessor");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeAloneHypermetroProcessor.des");
    }
}

