/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.checker.HyperMetroRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.EndRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.SynchronizeHyperMetroSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SynchronizeHyperMetroProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3826118186983009835L;
    private static final Log logger = LogFactory.getInstance(SynchronizeHyperMetroProcessor.class);
    private String deviceId;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        DrmEnumDefine.APP_TYPE appType = DrmEnumDefine.APP_TYPE.getType((int)pg.getPoType());
        int templateType = pg.getTemplate().getType();
        if (appType == null) {
            return;
        }
        logger.info((Object)("ResetEnableStatus APP_TYPE:" + appType.toString()));
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            this.reset4DCEnableStatus(pg, procType);
            return;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.equals((Object)procType) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.equals((Object)procType)) {
            if (HyperMetroRecoveryProcessChecker.isHyperMetroReplicationMode((int)templateType)) {
                this.setIsEnabled(false);
                this.setIsEditable(false);
            } else if (!RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)pg) && HyperMetroRecoveryProcessChecker.isReplicationHyperMetroMode((int)templateType)) {
                this.setIsEnabled(true);
                this.setIsEditable(false);
            }
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.equals((Object)procType)) {
            this.resetEnableStatusForReprotect(pg);
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.equals((Object)procType)) {
            if (31 == templateType) {
                this.setIsEnabled(true);
                this.setIsEditable(false);
            } else if (32 == templateType) {
                this.setIsEnabled(false);
                this.setIsEditable(false);
            }
        }
    }

    private void reset4DCEnableStatus(ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        this.setIsEditable(!DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.equals((Object)procType));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.equals((Object)procType) && RecoveryTaskUtil.isVault4DCSceneAndRollBack((ProtectGroup)pg, (int)procType.getValue())) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        }
    }

    private void resetEnableStatusForReprotect(ProtectGroup pg) {
        if (RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)pg)) {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        }
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        if (pg == null || pg.getTemplate() == null) {
            logger.info((Object)"Pg and template can not be null!");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        int templateType = pg.getTemplate().getType();
        Set<Integer> allowTypeSet = this.getAllowedTypeSet();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && !allowTypeSet.contains(templateType)) {
            logger.info((Object)"Only reprotect to hyper_async execute!");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType) && this.handle4DCTemplate(context, pg)) {
            return true;
        }
        Map globalSettings = context.getRecoveryPlan().getGlobalSettings();
        String tmpDevSn = (String)context.getObject("hyperMetroDeviceSn", String.class);
        String deviceSn = Optional.ofNullable(tmpDevSn).orElseGet(() -> (String)globalSettings.get("hyperMetroDeviceSn"));
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            logger.error((Object)"Not find deviceSn when sync hyper metro.");
            return false;
        }
        this.setDeviceId(deviceSn);
        Map pairIdMap = (Map)context.getAttribute("pairIdMap");
        if (VerifyUtil.isEmpty((Map)pairIdMap)) {
            String pairMapStr = (String)globalSettings.get("pairIdMap");
            if (VerifyUtil.isEmpty((String)pairMapStr)) {
                logger.error((Object)("HyperMetro has none pair or consistent group! deviceId:" + this.getDeviceId()));
                return false;
            }
            pairIdMap = JSONObject.fromObject((Object)pairMapStr);
        }
        String tmpId = (String)context.getObject("vstoreId", String.class);
        String vstoreId = Optional.ofNullable(tmpId).orElseGet(() -> (String)globalSettings.get("vstoreId"));
        return this.execSyncHyperMetro(context, templateType, pairIdMap, vstoreId);
    }

    private boolean execSyncHyperMetro(RecoveryProcessorContext context, int templateType, Map<String, Boolean> pairIdMap, String vstoreId) {
        boolean isContinue = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.getValue() == this.getProcType() && 28 == templateType;
        this.updateSubProcessors(pairIdMap, vstoreId, isContinue);
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.rollback.snapshot", new String[0]);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        recoveryTemplate.process(context);
        boolean result = this.calcProcessResultBySubProc();
        if (isContinue) {
            if (this.getNextProcessor() instanceof EndRecoveryProcessor) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            }
            return true;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            result = false;
        }
        return result;
    }

    private Set<Integer> getAllowedTypeSet() {
        return new HashSet<Integer>(Arrays.asList(18, 31, 26, 35, 36, 38, 39, 40, 41, 42, 43));
    }

    private boolean handle4DCTemplate(RecoveryProcessorContext context, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)context.getAttribute("hyperMetroDeviceSn")) || VerifyUtil.isEmpty((Object)context.getAttribute("pairIdMap"))) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        if (RecoveryTaskUtil.is4DCVaultSceneAndRollBack((ProtectGroup)pg, (int)this.getProcType())) {
            return false;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
            return this.handleReprotect(context, pg);
        }
        String siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO");
        if (null != siteInfoListStr) {
            List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
            String disSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID"));
            SiteInfo disSiteInfo = siteInfoList.stream().filter(siteInfo -> siteInfo.getSiteIdSet().contains(disSiteId)).findFirst().get();
            if (null != disSiteInfo.getSiteIdSet() && disSiteInfo.getSiteIdSet().size() < 2) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
        } else {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        return false;
    }

    private boolean handleReprotect(RecoveryProcessorContext context, ProtectGroup pg) {
        List recoveryProcesses = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION, SynchronizeHyperMetroSubProcessor.class);
        if (!VerifyUtil.isEmpty((Collection)recoveryProcesses) && ((RecoveryProcessor)recoveryProcesses.stream().findFirst().get()).getProcStatus() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        recoveryProcesses = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY, SynchronizeHyperMetroSubProcessor.class);
        if (!VerifyUtil.isEmpty((Collection)recoveryProcesses) && ((RecoveryProcessor)recoveryProcesses.stream().findFirst().get()).getProcStatus() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        if (!ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)pg)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        return false;
    }

    private boolean updateSubProcessors(Map<String, Boolean> pairIdMap, String vstoreId, boolean isContinue) {
        if (VerifyUtil.isEmpty(pairIdMap)) {
            return true;
        }
        if (null != this.getChildProc()) {
            this.getChildProc().clear();
        }
        HashSet<SynchronizeHyperMetroSubProcessor> subProcessors = new HashSet<SynchronizeHyperMetroSubProcessor>();
        for (Map.Entry<String, Boolean> entry : pairIdMap.entrySet()) {
            String pairId = entry.getKey();
            boolean isConsistentGroup = entry.getValue();
            SynchronizeHyperMetroSubProcessor processor = new SynchronizeHyperMetroSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
            processor.setDeviceId(this.getDeviceId());
            processor.setPairId(pairId);
            processor.setIsConsistentGroup(isConsistentGroup);
            processor.setVstoreId(vstoreId);
            processor.setAllAwaysContinue(isContinue);
            subProcessors.add(processor);
        }
        this.setChildProc(subProcessors);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeHyperMetroProcessor.des");
    }
}

