/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.common;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public abstract class CommonRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7482798635033446468L;
    private static final Log LOGGER = LogFactory.getInstance(CommonRecoveryProcessor.class);
    private final boolean isStrict;
    private final boolean canRedo;

    public CommonRecoveryProcessor() {
        this(true, false);
    }

    public CommonRecoveryProcessor(boolean isStrict, boolean canRedo) {
        this.isStrict = isStrict;
        this.canRedo = canRedo;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (this.getProcStatus() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() && !this.canRedo) {
            return true;
        }
        try {
            this.executeSubProcessors(context);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Process failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            String procDetail = this.getProcDetail(e);
            this.updateProcessDetail(procDetail, new String[0]);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        return this.calcProcessResultBySubProc();
    }

    private String getProcDetail(Throwable throwable) {
        String procDetail = throwable instanceof LegoCheckedException ? "lego.err." + ((LegoCheckedException)throwable).getErrorCode() : (throwable instanceof LegoUncheckedException ? "lego.err." + ((LegoUncheckedException)throwable).getErrorCode() : "lego.err.2099465");
        return procDetail;
    }

    protected void executeSubProcessors(RecoveryProcessorContext context) {
        this.initSubProcessors(context);
        Set processors = this.getChildProc();
        if (processors.isEmpty()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        } else {
            DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
            RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)processors, (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
            recoveryTemplate.process(context);
        }
    }

    private void initSubProcessors(RecoveryProcessorContext context) {
        Set processors = this.getChildProc();
        if (processors == null || processors.isEmpty()) {
            this.initSubProcessors(context, arg_0 -> ((CommonRecoveryProcessor)this).setChildProc(arg_0), true);
        } else {
            this.initSubProcessors(context, arg_0 -> ((CommonRecoveryProcessor)this).updateSubProcessors(arg_0), false);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initSubProcessors(RecoveryProcessorContext context, Consumer<Set<RecoveryProcessor>> consumer, boolean isEmpty) {
        Set<RecoveryProcessor> processors = this.createProcessors(context);
        processors.forEach(this::initProcessorProps);
        consumer.accept(processors);
        this.setHasChildProc(!isEmpty || !processors.isEmpty());
    }

    private void initProcessorProps(RecoveryProcessor processor) {
        processor.setProcName(processor.getName());
        processor.setParentProcId(this.getProcId());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        Map props = processor.getProps();
        this.getProps().forEach((key, value) -> {
            if (!props.containsKey(key)) {
                props.put(key, value);
            }
        });
    }

    protected boolean calcProcessResultBySubProc() {
        boolean result = super.calcProcessResultBySubProc();
        if (this.isStrict && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        return result;
    }

    protected Set<RecoveryProcessor> createProcessors(RecoveryProcessorContext context) {
        return Collections.emptySet();
    }
}

