/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairConfiguration;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.concurrent.Callable;

public class CreateReplicationPairTask
implements Callable<ReplicationPair> {
    private static Log logger = LogFactory.getInstance(CreateReplicationPairTask.class);
    private ReplicationPair pair;
    private ReplicationPairConfiguration config;
    private LegoCheckedException exception;
    private StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();

    public CreateReplicationPairTask(ReplicationPair pair, ReplicationPairConfiguration config) {
        this.pair = pair;
        this.config = config;
    }

    public ReplicationPair getPair() {
        return this.pair;
    }

    public void setPair(ReplicationPair pair) {
        this.pair = pair;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setLegoCheckedException(LegoCheckedException ex) {
        this.exception = ex;
    }

    @Override
    public ReplicationPair call() {
        try {
            return this.doWork();
        }
        catch (LegoCheckedException ex) {
            this.setLegoCheckedException(ex);
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)("create replication pair failed. source LUN id:" + this.pair.getSrcLunId()), (long)1073947727L, (String[])new String[]{this.pair.getSrcDevSN(), this.pair.getTgtDevSN()}, (Log)logger);
            this.setLegoCheckedException(legoCheckedException);
        }
        return null;
    }

    private ReplicationPair doWork() {
        String srcDevSN = this.pair.getSrcDevSN();
        String srcLunId = this.pair.getSrcLunId();
        String tgtDevSN = this.pair.getTgtDevSN();
        String srcLunWWN = this.pair.getSrcLunWWN();
        List pairList = this.sraProxy.queryReplications(srcDevSN, srcLunId, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        if (null != pairList && !pairList.isEmpty()) {
            for (ReplicationPair onePair : pairList) {
                if (!srcLunId.equals(onePair.getSrcLunId()) || !tgtDevSN.equals(onePair.getTgtDevSN())) continue;
                return onePair;
            }
        }
        StorageLunManagerProxy lunManagerProxy = StorageLunManagerProxy.getInstance();
        Lun srcLun = null;
        if (null != srcLunWWN) {
            srcLun = lunManagerProxy.getLunByWWN(srcDevSN, srcLunWWN);
        }
        if (null == srcLun && null != srcLunId) {
            srcLun = lunManagerProxy.getLunById(srcDevSN, srcLunId);
        }
        if (null == srcLun) {
            String errorMsg = "Source LUN is not exists, LUN ID is " + srcLunId + " LUN WWN is :" + srcLunWWN + " Device SN is " + srcDevSN;
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947724L, new String[]{srcLunId}, errorMsg);
        }
        String srcPoolId = srcLun.getStoragePoolId();
        Lun tgtLun = new Lun();
        tgtLun.setDevSn(tgtDevSN);
        tgtLun.setName(srcLun.getName());
        tgtLun.setCapacity(srcLun.getCapacity());
        StoragePair storagePair = this.config.findStoragePair(srcDevSN, tgtDevSN);
        if (storagePair == null) {
            logger.error((Object)("not found storage pair for " + srcDevSN + ':' + tgtDevSN));
            throw new LegoCheckedException(1073947725L, new String[]{srcDevSN, tgtDevSN});
        }
        tgtLun.setStoragePoolId(storagePair.getTgtStoragePool(srcPoolId));
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
        Lun lun = drmStorageService.queryLunByName(tgtLun.getDevSn(), tgtLun.getName());
        if (!VerifyUtil.isEmpty((Object)lun) && !VerifyUtil.isEmpty((String)lun.getName())) {
            this.pair.setSrcLunName(lun.getName());
            throw new LegoCheckedException(1073947467L, new String[]{lun.getName()});
        }
        Lun createdLun = drmStorageService.createLun(tgtLun.getDevSn(), tgtLun);
        this.pair.setLocalResType(Integer.valueOf(11));
        if (createdLun == null) {
            logger.error((Object)"create target lun failed.");
            throw new LegoCheckedException(1073947726L, new String[]{storagePair.getTgtDevSN()});
        }
        ((ReplicationTargetLun)this.pair.getRepTgtLuns().iterator().next()).setTgtLunId(createdLun.getLunId());
        ReplicationPair resultPair = this.sraProxy.createReplicationPair(this.pair);
        return resultPair;
    }
}

