/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;

public class DeleteReplicationPairTask
implements Callable<Boolean> {
    private static Log logger = LogFactory.getInstance(DeleteReplicationPairTask.class);
    private static final long PAIR_NOT_EXIST_ERROR_CODE = 37120003L;
    private ReplicationPair pair;
    private int pgStatus;
    private LegoCheckedException exception;

    public DeleteReplicationPairTask(ReplicationPair pair, int pgStatus) {
        this.pair = pair;
        this.pgStatus = pgStatus;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setException(LegoCheckedException exception) {
        this.exception = exception;
    }

    @Override
    public Boolean call() {
        ReplicationPair pairInDevice;
        String pairId = this.pair.getReplicationId();
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        try {
            pairInDevice = !VerifyUtil.isEmpty((String)pairId) ? sraProxy.getReplicationPair(this.pair.getSrcDevSN(), pairId) : null;
        }
        catch (LegoCheckedException e) {
            if (37120003L == e.getErrorCode()) {
                pairInDevice = null;
            }
            logger.error((Object)"getReplicationPair error:", (Throwable)e);
            this.setException(e);
            throw e;
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)("delete replication pair failed. source LUN id:" + this.pair.getSrcLunId()), (long)1073947728L, (String[])new String[]{this.pair.getSrcDevSN(), this.pair.getSrcLunId(), this.pair.getTgtDevSN(), this.pair.getTgtLunId(), pairId}, (Log)logger);
            logger.error((Object)legoCheckedException.getMessage(), (Throwable)legoCheckedException);
            this.setException(legoCheckedException);
            throw ex;
        }
        this.deleteReplicationPair(sraProxy, pairInDevice);
        return true;
    }

    private void deleteReplicationPair(StorageReplicationManagerProxy sraProxy, ReplicationPair pairInDevice) {
        String srcDevSN = this.pair.getSrcDevSN();
        String tgtDevSN = this.pair.getTgtDevSN();
        String pairId = this.pair.getReplicationId();
        String tgtLunId = this.pair.getTgtLunId();
        try {
            if (null != pairInDevice) {
                String cgId = pairInDevice.getConsistentGroupId();
                if (null != cgId) {
                    sraProxy.splitReplication(srcDevSN, tgtDevSN, cgId, true);
                    ReplicationGroup group = new ReplicationGroup();
                    group.setSrcDevSN(srcDevSN);
                    group.setTgtDevSN(tgtDevSN);
                    group.setReplicationId(cgId);
                    sraProxy.removeReplicationPair(group, Arrays.asList(pairInDevice));
                    sraProxy.syncOnce(srcDevSN, tgtDevSN, cgId, true);
                } else {
                    sraProxy.splitReplication(srcDevSN, tgtDevSN, pairId, false);
                }
                logger.warn((Object)("deleteReplicationPair:" + this.pair.getReplicationId()));
                sraProxy.deleteReplicationPair(this.pair);
            }
            if (!VerifyUtil.isEmpty((String)tgtLunId)) {
                DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
                logger.warn((Object)("deleteLun:" + tgtLunId));
                drmStorageService.deleteLun(tgtDevSN, Arrays.asList(tgtLunId), new ArrayList());
            }
        }
        catch (LegoCheckedException e) {
            if (DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus() == this.pgStatus) {
                logger.error((Object)"something wrong during getReplicationPair");
            }
            logger.error((Object)"getReplicationPair error:", (Throwable)e);
            this.setException(e);
            throw e;
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)("delete replication pair failed. source LUN id:" + this.pair.getSrcLunId()), (long)1073947728L, (String[])new String[]{this.pair.getSrcDevSN(), this.pair.getSrcLunId(), this.pair.getTgtDevSN(), this.pair.getTgtLunId(), pairId}, (Log)logger);
            logger.error((Object)legoCheckedException.getMessage(), (Throwable)legoCheckedException);
            this.setException(legoCheckedException);
            throw ex;
        }
    }
}

