/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.ism.drm.storage.replication.builder.DeleteReplicationPairTask;
import com.huawei.ism.drm.storage.replication.builder.ReplicationGroupRollbackItem;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StorageReplicationRollbackExecutor
implements IRollBackExecutor {
    private static Log logger = LogFactory.getInstance(StorageReplicationRollbackExecutor.class);
    private Map<String, Class<? extends ReplicationRelation>> classTypeMap = new HashMap<String, Class<? extends ReplicationRelation>>();

    public StorageReplicationRollbackExecutor() {
        this.classTypeMap.put(ReplicationPair.class.getSimpleName(), ReplicationPair.class);
        this.classTypeMap.put(ReplicationGroup.class.getSimpleName(), ReplicationGroup.class);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean execute(String param) {
        logger.debug((Object)("enter in param: " + param));
        String[] params = param.split("->");
        int resultSize = params.length;
        List<String> paramList = Arrays.asList(params);
        for (String jsonStr : paramList) {
            String[] innerParams = jsonStr.split("\\+");
            JSONObject jsonObject = JSONObject.fromObject((Object)innerParams[1]);
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String className = iterator.next().toString();
                if (null == this.classTypeMap.get(className)) {
                    throw new LegoCheckedException("");
                }
                resultSize = this.submitRollbackTask(jsonObject, NumberUtil.convertToInteger((Object)innerParams[0]), className) ? resultSize : --resultSize;
            }
        }
        logger.debug((Object)"excute end ...");
        return resultSize == params.length;
    }

    private boolean submitRollbackTask(JSONObject jsonObject, int pgStatus, String className) {
        boolean resultFlag = true;
        if (ReplicationPair.class.getSimpleName().equals(className)) {
            JSONArray array = JSONArray.fromObject((Object)jsonObject.get(className));
            for (int index = 0; index < array.size(); ++index) {
                ReplicationPair replicationPair = (ReplicationPair)JSONObject.toBean((JSONObject)array.getJSONObject(index), ReplicationPair.class);
                DeleteReplicationPairTask task = new DeleteReplicationPairTask(replicationPair, pgStatus);
                logger.warn((Object)("DeleteReplicationPairTask:" + replicationPair.getReplicationId()));
                try {
                    task.call();
                    continue;
                }
                catch (Exception ex) {
                    resultFlag = false;
                    logger.error((Object)"delete replication pair failed", (Throwable)ex);
                }
            }
        } else {
            JSONObject replicationGJson = jsonObject.getJSONObject(className);
            ReplicationGroup replicationGroup = (ReplicationGroup)JSONObject.toBean((JSONObject)replicationGJson, ReplicationGroup.class);
            ReplicationGroupRollbackItem rollback = new ReplicationGroupRollbackItem(replicationGroup);
            logger.warn((Object)("ReplicationGroupRollback:" + replicationGroup.getReplicationId()));
            return rollback.execute();
        }
        logger.debug((Object)"rollback pair end..");
        return resultFlag;
    }
}

