/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import twaver.IElement;

public class CloneLinkSkin
extends Skin {
    private static final int REPLICATION_ASYN_Y_OFFSET = -25;
    private HyperCloneTargetLun replication;
    private String scheduleInfo;

    public CloneLinkSkin(HyperCloneTargetLun replication) {
        this(replication, null);
    }

    public CloneLinkSkin(HyperCloneTargetLun replication, String scheduleInfo) {
        this.replication = replication;
        this.scheduleInfo = scheduleInfo;
    }

    public void apply(IElement link) {
        link.setStyle("link.width", (Object)1.0);
        link.setClient("linkToXOffset", (Object)10.0);
        link.setStyle("arrow.to", (Object)true);
        this.initReplicationToolTipAndColor(link);
        link.setStyle("link.from.at.edge", (Object)true);
        link.setStyle("link.to.at.edge", (Object)true);
        link.setStyle("arrow.to.width", (Object)7.0);
        link.setStyle("arrow.to.height", (Object)6.0);
        link.setStyle("arrow.to.shape", (Object)"arrow.delta");
        link.setStyle("label.bold", (Object)false);
        link.setStyle("label.font", (Object)this.getTopoResourceManager().getText("ism.drm.topo.label.font"));
        link.setStyle("link.extend", (Object)0);
        link.setStyle("select.alpha", (Object)1.0);
        link.setStyle("select.style", (Object)"none");
    }

    private void initReplicationToolTipAndColor(IElement link) {
        String linkColor = "0xbbbbbb";
        String statusDisplay = this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.status");
        statusDisplay = statusDisplay + " ";
        if (this.replication == null) {
            statusDisplay = statusDisplay + "--";
            linkColor = "0xbbbbbb";
            String linkToolTip = statusDisplay;
            if (!VerifyUtil.isEmpty((String)this.scheduleInfo)) {
                linkToolTip = linkToolTip + "\n" + this.scheduleInfo;
            }
            link.setToolTip(linkToolTip);
            link.setStyle("link.color", (Object)linkColor);
            link.setStyle("arrow.to.color", (Object)linkColor);
            link.setStyle("arrow.to", (Object)false);
            return;
        }
        link.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/ic_asynchronous.png");
        link.setStyle("icons.position", (Object)"top");
        link.setClient("linkType", (Object)"aysnLink");
        int hyperInfoStatus = 0;
        try {
            hyperInfoStatus = TopoServiceUtil.initNewPairStatus((int)Integer.parseInt(this.replication.getRunningState()));
        }
        catch (Exception e) {
            hyperInfoStatus = 0;
        }
        if (this.checkLunPairStatus(hyperInfoStatus)) {
            statusDisplay = statusDisplay + this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.status." + hyperInfoStatus);
            linkColor = this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.color." + hyperInfoStatus);
        } else {
            statusDisplay = statusDisplay + "--";
            linkColor = "0xbbbbbb";
        }
        this.initReplicationToolTip(link, linkColor, statusDisplay, hyperInfoStatus);
    }

    private boolean checkLunPairStatus(int hyperInfoStatus) {
        return hyperInfoStatus >= 1 && hyperInfoStatus <= 6;
    }

    private void initReplicationToolTip(IElement link, String linkColor, String statusDisplay, int hyperInfoStatus) {
        String nameDisplay = this.getTopoResourceManager().getText("ism.drm.topo.clone.name");
        nameDisplay = nameDisplay + " ";
        String scheduleToolTip = "";
        boolean isShowName = false;
        if (!VerifyUtil.isEmpty((String)this.replication.getName())) {
            nameDisplay = nameDisplay + this.replication.getName();
            isShowName = true;
        }
        if (hyperInfoStatus == 2 && this.replication.getProcess() >= 0) {
            link.setName(this.replication.getProcess() + "%");
            link.setStyle("label.yoffset", (Object)-25);
        }
        String linkToolTip = isShowName ? nameDisplay + "\n" + statusDisplay : statusDisplay;
        if (!VerifyUtil.isEmpty((String)this.scheduleInfo)) {
            scheduleToolTip = "\n" + this.scheduleInfo;
        }
        link.setToolTip(linkToolTip + scheduleToolTip);
        link.setStyle("link.color", (Object)linkColor);
        link.setStyle("arrow.to.color", (Object)linkColor);
    }
}

